/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <stack.h>
#include <crypto.h>
#include "pfx.h"

CERTCRL *CERTCRL_new()
{
	CERTCRL *ret=NULL;
	M_ASN1_New_Malloc(ret, CERTCRL);
	ret->bagid = NULL;
	ret->lcerts = NULL;
	return (ret);
	M_ASN1_New_Error(502);
}

CERTCRL *d2i_CERTCRL(a,pp,length)
CERTCRL **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,CERTCRL *,CERTCRL_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->bagid, d2i_ASN1_OBJECT);
	M_ASN1_D2I_get_EXP_opt (ret->lcerts, d2i_CERTS, 0);
	M_ASN1_D2I_Finish(a, CERTCRL_free, 503);
}

void CERTCRL_free (a)
CERTCRL *a;
{
	if (a == NULL) return;
	ASN1_OBJECT_free (a->bagid);
	CERTS_free (a->lcerts);
	Free ((char *)a);
}
