/* Copyright Dr S.N.Henson 1997 */

/* Encrypted private key is same structure as X509_SIG */
#define ENCPKEY X509_SIG
#define ENCPKEY_free X509_SIG_free
#define epkey digest
#define d2i_ENCPKEY d2i_X509_SIG

#ifndef V_ASN1_BMPSTRING
#define V_ASN1_BMPSTRING	30
#endif

typedef struct {
X509_SIG *dinfo;
ASN1_BIT_STRING *salt;
} MAC_DATA;

typedef struct {
MAC_DATA *mac;
PKCS7 *authsafe;
STACK /* SAFEBAG */ *bags; /* NULL until authsafe decrypted */
} PFX;

typedef struct {
STACK *espvks;
ASN1_TYPE *ksafe;
STACK *safebags;
} BAGITEM;

typedef struct {
STACK *prints;
int *regen;  
ASN1_STRING *nickname;
STACK *additional; /* Ignored */
} SUP_DATA;

typedef struct {
ASN1_INTEGER *version;
X509_ALGOR *pkeyalg;
ASN1_OCTET_STRING *pkey;
STACK *attributes;
} PRIV_KEY_INFO;

typedef struct {
ASN1_OBJECT *espvkoid;
SUP_DATA *supdata;
ENCPKEY *cipher;
PRIV_KEY_INFO *pkey; /* NULL until private keys decrypted */
} ESPVK;

typedef struct {
ASN1_INTEGER *version;
ASN1_OBJECT *mode;
ASN1_BIT_STRING *psalt;
STACK /* BAGITEM */ *bagitms;
PKCS7 *safe;
} AUTHSAFE;

typedef struct {
ASN1_OCTET_STRING *salt;
ASN1_INTEGER *iter;
} PBEPARAM;

typedef struct {
ASN1_OBJECT *type;
STACK /* CERTCRL */ *certs;
ASN1_TYPE *other;
} SAFEBAG;

typedef union {
PKCS7 *cchain;
ASN1_IA5STRING *value;
} CERTS;

typedef struct {
ASN1_OBJECT *bagid;
CERTS *lcerts;
} CERTCRL;


/* pfx.c */
int main(int argc, char **argv);
int dump_p7(PFX *p, BIO *op);
int dump_pkeys(AUTHSAFE *asafe, BIO *op, EVP_CIPHER *enc);
/* pfx_asfe.c */
AUTHSAFE *d2i_PFX_AUTHSAFE(AUTHSAFE **a, unsigned char **pp, long length);
AUTHSAFE *PFX_AUTHSAFE_new(void);
void PFX_AUTHSAFE_free(AUTHSAFE *a);
/* pfx_bitm.c */
BAGITEM *d2i_BAGITEM(BAGITEM **a, unsigned char **pp, long length);
BAGITEM *BAGITEM_new(void);
void BAGITEM_free(BAGITEM *a);
/* pfx_ccrl.c */
CERTCRL *CERTCRL_new(void);
CERTCRL *d2i_CERTCRL(CERTCRL **a, unsigned char **pp, long length);
void CERTCRL_free(CERTCRL *a);
/* pfx_crpt.c */
int verify_mac(char *pass, PFX *p);
int decrypt_pkeys(STACK *bags, char *pass);
STACK *decrypt_safe(PFX *pfx, AUTHSAFE *asafe, char *pass);
/* pfx_crts.c */
CERTS *CERTS_new(void);
CERTS *d2i_CERTS(CERTS **a, unsigned char **pp, long length);
void CERTS_free(CERTS *a);
/* pfx_espk.c */
ESPVK *d2i_ESPVK(ESPVK **a, unsigned char **pp, long length);
ESPVK *ESPVK_new(void);
void ESPVK_free(ESPVK *a);
/* pfx_lib.c */
PFX *d2i_PFX(PFX **a, unsigned char **pp, long length);
PFX *PFX_new(void);
void PFX_free(PFX *a);
/* pfx_mac.c */
MAC_DATA *MAC_DATA_new(void);
MAC_DATA *d2i_MAC_DATA(MAC_DATA **a, unsigned char **pp, long length);
void MAC_DATA_free(MAC_DATA *a);
/* pfx_misc.c */
void add_objs(void);
/* pfx_pass.c */
void p_SHA1(unsigned char *end, int endlen, unsigned char *secret, int secretlen, unsigned char *seed, int seedlen);
unsigned char *vpasswd(unsigned char *pass, unsigned char *salt, int saltlen, int *oplen);
void HMAC_SHA1(unsigned char *key, int keylen, unsigned char *data, int datalen, int blocklen, unsigned char *md);
void PKCS5_KEY_GEN(unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, unsigned char *md);
/* pfx_pbe.c */
PBEPARAM *PBEPARAM_new(void);
PBEPARAM *d2i_PBEPARAM(PBEPARAM **a, unsigned char **pp, long length);
void PBEPARAM_free(PBEPARAM *a);
/* pfx_priv.c */
PRIV_KEY_INFO *PRIV_KEY_INFO_new(void);
PRIV_KEY_INFO *d2i_PRIV_KEY_INFO(PRIV_KEY_INFO **a, unsigned char **pp, long length);
void PRIV_KEY_INFO_free(PRIV_KEY_INFO *a);
/* pfx_sbag.c */
SAFEBAG *SAFEBAG_new(void);
SAFEBAG *d2i_SAFEBAG(SAFEBAG **a, unsigned char **pp, long length);
void SAFEBAG_free(SAFEBAG *a);
/* pfx_supd.c */
SUP_DATA *SUP_DATA_new(void);
SUP_DATA *d2i_SUP_DATA(SUP_DATA **a, unsigned char **pp, long length);
void SUP_DATA_free(SUP_DATA *a);
