/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <bio.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <crypto.h>
#include <sha.h>
#include <rc2.h>
#include <stack.h>
#include <evp.h>
#include <rsa.h>
#include <pem.h>
#include "pfx.h"


int main(argc, argv)
int argc;
char **argv;
{
    char *infile=NULL, *outfile=NULL;	
    BIO *in=NULL, *out = NULL;
    char **args;
    PFX *p;
    AUTHSAFE *asafe;
    unsigned char *pbuf;
    char pstr[50] ;
    int dump_priv = 0;
    int dump_chain = 0;
    int badarg = 0;
    EVP_CIPHER *enc = NULL;

    args = argv + 1;

    while (*args) {
	if (*args[0] == '-') {
		if (!strcmp (*args, "-privkey")) dump_priv = 1;
		else if (!strcmp (*args, "-p7chain")) dump_chain = 1;
		else if (!strcmp (*args, "-in")) {
		    if (args[1]) {
			args++;	
			infile = *args;
		    } else badarg = 1;
		} else if (!strcmp (*args, "-out")) {
		    if (args[1]) {
			args++;	
			outfile = *args;
		    } else badarg = 1;
		} else if (!strcmp (*args, "-des")) enc=EVP_des_cbc();
		else if (!strcmp (*args, "-des3")) enc=EVP_des_ede3_cbc();
		else if (!strcmp (*args, "-idea")) enc=EVP_idea_cbc();
		else badarg = 1;
	} else badarg = 1;
	args++;
    }

    if (badarg) {
	fprintf (stderr, "PFX version 0.0\n");
	fprintf (stderr, "Copyright Dr. S.N. Henson 1997.\n");
	fprintf (stderr, "Usage:\npfx [options] filename\n");
	fprintf (stderr, "where options are\n");
	fprintf (stderr, "-in  file  	input filename\n");
	fprintf (stderr, "-out file  	output filename\n");
	fprintf (stderr, "-privkey	output private keys.\n");
	fprintf (stderr, "-p7chain	output PKCS7 chain.\n");
	fprintf (stderr, "-des		encrypt with DES\n");
	fprintf (stderr, "-des3		encrypt with triple DES\n");
	fprintf (stderr, "-idea		encrypt with idea\n");
    	exit (1);
    }

    add_objs ();
    ERR_load_crypto_strings();
    in = BIO_new (BIO_s_file());
    out = BIO_new (BIO_s_file());

    if (!outfile) BIO_set_fp (out, stdout, BIO_NOCLOSE);
    else {
        if (BIO_write_filename (out, outfile) <= 0) {
	    perror (infile);
	    exit (1);
	}
    }

    if (!infile) BIO_set_fp (in, stdin, BIO_NOCLOSE);
    else {
        if (BIO_read_filename (in, infile) <= 0) {
	    perror (infile);
	    exit (1);
	}
    }

    p = (PFX *) ASN1_d2i_bio ((char *(*)())PFX_new, (char *(*)())d2i_PFX, in,
									 NULL);
    if (!p) {
	ERR_print_errors_fp(stderr);
	exit (1);
    }

    if(EVP_read_pw_string (pstr, 50, "Enter Password:", 0)) {
	fprintf (stderr, "Can't read Password\n");
	exit (1);
    }

    if (verify_mac (pstr, p)) {
      fprintf (stderr, "Mac verify errror: invalid password?\n");
      exit (1);
     } else fprintf (stderr, "Password OK\n");

    pbuf =  p->authsafe->d.data->data;
    asafe = d2i_PFX_AUTHSAFE (NULL, &pbuf, p->authsafe->d.data->length);
    if (!asafe) {
	ERR_print_errors_fp(stderr);
	exit (1);
    }

    if (!decrypt_safe (p, asafe, pstr)) {
	ERR_print_errors_fp(stderr);
	exit (1);
    } else fprintf (stderr, "Decrypted Authsafe OK\n");

    if (decrypt_pkeys (asafe->bagitms, pstr)) {
	fprintf (stderr, "Error decrypting private keys\n");
	exit (1);
    } else fprintf (stderr, "Decrypted Private Keys OK\n");

    if (dump_chain) dump_p7 (p, out);
    if (dump_priv) dump_pkeys (asafe, out, enc);
    return (0);
}

int dump_p7 (p, op)
PFX *p;
BIO *op;
{
	int i, j;
	SAFEBAG *sbag;
	CERTCRL *ccrl;
	if (!p->bags) return 1;
	for (i = 0; i < sk_num(p->bags); i++) {
		sbag = (SAFEBAG *) sk_value (p->bags, i); 
		if (sbag->certs) for (j = 0; j < sk_num (sbag->certs); j++) {
	        	ccrl = (CERTCRL *) sk_value (sbag->certs, j);
			if (ccrl->lcerts && ccrl->lcerts->cchain) 
				PEM_write_bio_PKCS7 (op, ccrl->lcerts->cchain);
		}
        }
	return 0;
}

int dump_pkeys (asafe, op, enc)
AUTHSAFE *asafe;
BIO *op;
EVP_CIPHER *enc;
{
int i, j;
BAGITEM *tmpbag;
ESPVK *tmpsbag;
unsigned char *p;
RSA *rsa;

/* Get all private keys */
for (i = 0; i < sk_num (asafe->bagitms); i++) {
    tmpbag = (BAGITEM *) sk_value (asafe->bagitms, i) ;
    for (j = 0 ; j < sk_num (tmpbag->espvks); j++) {
        tmpsbag = (ESPVK *) sk_value (tmpbag->espvks, j);
        if (tmpsbag->pkey && OBJ_obj2nid (tmpsbag->pkey->pkeyalg->algorithm) 
							 == NID_rsaEncryption) {
	    p = (unsigned char *) tmpsbag->pkey->pkey->data;
            rsa = d2i_RSAPrivateKey (NULL, &p, tmpsbag->pkey->pkey->length);
	    PEM_write_bio_RSAPrivateKey (op, rsa, enc, NULL, 0, NULL);
	    RSA_free (rsa);
	}
  }
} 
return 0;
}
