# This makefile has been automatically generated from the SSLeay distribution.
# This single makefile will build the complete SSLeay distribution and
# by default leave the 'intertesting' output files in .\out and the stuff
# that needs deleting in .\tmp.
# The file was generated by running 'make makefile.one', which
# does a 'make files', which writes all the environment variables from all
# the makefiles to the file call MINFO.  This file is used by
# util\mk1mf.pl to generate makefile.one.
# The 'makefile per directory' system suites me when developing this
# library and also so I can 'distribute' indervidual library sections.
# The one monster makefile better suits building in non-unix
# environments.

INSTALLTOP=/usr/local/ssl

# Set your compiler options
CC=cl
CFLAG=/ALw /Gx- /Gf /G2 /f- /Ocgnotb2 /W3 /WX -DL_ENDIAN /nologo -DMSDOS -DNO_SOCK
APP_CFLAG=
LIB_CFLAG=
APP_EX_OBJ=setargv.obj
SHLIB_EX_OBJ=
EX_LIBS=oldnames.lib llibce.lib

# The SSLeay directory
SRC_D=.

LINK=link
LFLAGS=/NOLOGO /NOD /SEG:1024 /ONERROR:NOEXE /NOE /PACKC:60000 /FARCALL /STACK:20000 /EXEPACK

BN_MULW_OBJ=crypto\bn\asm\x86w16.obj
BN_MULW_SRC=crypto\bn\asm\x86w16.asm

# The output directory for everything intersting
OUT_D=out
# The output directory for all the temporary muck
TMP_D=tmp

CP=copy
RM=del
RANLIB=
MKDIR=mkdir
MKLIB=lib
MLFLAGS=
ASM=ml /Cp /c /Cx

######################################################
# You should not need to touch anything below this point
######################################################

E_EXE=ssleay
SSL=ssl16
CRYPTO=crypt16
RSAGLUE=RSAglue

O_SSL=     $(LIB_D)\$(SSL).lib
O_CRYPTO=  $(LIB_D)\$(CRYPTO).lib
O_RSAGLUE= $(LIB_D)\$(RSAGLUE).lib
L_SSL=     $(LIB_D)\$(SSL).lib
L_CRYPTO=  $(LIB_D)\$(CRYPTO).lib

L_LIBS= $(L_SSL) $(L_CRYPTO)
#L_LIBS= $(O_SSL) $(O_RSAGLUE) -lrsaref $(O_CRYPTO)

# BIN_D  - Binary output directory
# TEST_D - Binary test file output directory
# LIB_D  - library output directory
# INC_D  - include directory
BIN_D=$(OUT_D)
TEST_D=$(OUT_D)
LIB_D=$(OUT_D)
INC_D=$(OUT_D)

# INCL_D - local library directory
# OBJ_D  - temp object file directory
OBJ_D=$(TMP_D)
INCL_D=$(TMP_D)

######################################################
# Don't touch anything below this point
######################################################

INC=-DFLAT_INC -I$(INC_D) -I$(INCL_D)
APP_CFLAGS=$(INC) $(CFLAG) $(APP_CFLAG)
LIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG)
LIBS_DEP=$(O_CRYPTO) $(O_RSAGLUE) $(O_SSL)

#############################################
HEADER=$(INCL_D)\e_os.h \
	$(INCL_D)\cryptlib.h $(INCL_D)\date.h $(INCL_D)\md5_locl.h \
	$(INCL_D)\sha_locl.h $(INCL_D)\des_locl.h $(INCL_D)\rpc_des.h \
	$(INCL_D)\podd.h $(INCL_D)\sk.h $(INCL_D)\spr.h \
	$(INCL_D)\des_ver.h $(INCL_D)\rc2_locl.h $(INCL_D)\idea_lcl.h \
	$(INCL_D)\bn_lcl.h $(INCL_D)\bn_prime.h $(INCL_D)\obj_dat.h \
	$(INCL_D)\meth_lcl.h $(INCL_D)\x509meth.h $(INCL_D)\conf_lcl.h \
	$(INCL_D)\ssl_locl.h $(INCL_D)\ssl_trc.h $(INCL_D)\ssl_rsa.h \
	$(INCL_D)\ssl_null.h $(INCL_D)\ssl_md5.h $(INCL_D)\ssl_sha.h \
	$(INCL_D)\ssl_des.h $(INCL_D)\ssl_idea.h $(INCL_D)\ssl_rc4.h \
	$(INCL_D)\ssl_rc2.h $(INCL_D)\rsaref.h $(INCL_D)\apps.h \
	$(INCL_D)\progs.h $(INCL_D)\testcert.h

EXHEADER=$(INC_D)\crypto.h \
	$(INC_D)\cryptoall.h $(INC_D)\md2.h $(INC_D)\md5.h \
	$(INC_D)\sha.h $(INC_D)\des.h $(INC_D)\rc4.h \
	$(INC_D)\rc2.h $(INC_D)\idea.h $(INC_D)\bn.h \
	$(INC_D)\rsa.h $(INC_D)\dsa.h $(INC_D)\dh.h \
	$(INC_D)\buffer.h $(INC_D)\stack.h $(INC_D)\lhash.h \
	$(INC_D)\rand.h $(INC_D)\err.h $(INC_D)\objects.h \
	$(INC_D)\envelope.h $(INC_D)\pem.h $(INC_D)\x509.h \
	$(INC_D)\asn1.h $(INC_D)\asn1_mac.h $(INC_D)\meth.h \
	$(INC_D)\conf.h $(INC_D)\txt_db.h $(INC_D)\pkcs7.h \
	$(INC_D)\ssl.h

T_OBJ=$(OBJ_D)\md2test.obj \
	$(OBJ_D)\md5test.obj $(OBJ_D)\shatest.obj $(OBJ_D)\sha1test.obj \
	$(OBJ_D)\destest.obj $(OBJ_D)\rc4test.obj $(OBJ_D)\rc2test.obj \
	$(OBJ_D)\ideatest.obj $(OBJ_D)\bntest.obj $(OBJ_D)\dhtest.obj \
	$(OBJ_D)\randtest.obj $(OBJ_D)\ssltest.obj

E_OBJ=$(OBJ_D)\verify.obj \
	$(OBJ_D)\asn1pars.obj $(OBJ_D)\req.obj $(OBJ_D)\dgst.obj \
	$(OBJ_D)\dh.obj $(OBJ_D)\enc.obj $(OBJ_D)\gendh.obj \
	$(OBJ_D)\errstr.obj $(OBJ_D)\ca.obj $(OBJ_D)\pkcs7.obj \
	$(OBJ_D)\crl2p7.obj $(OBJ_D)\crl.obj $(OBJ_D)\rsa.obj \
	$(OBJ_D)\x509.obj $(OBJ_D)\genrsa.obj $(OBJ_D)\speed.obj \
	$(OBJ_D)\hashdir.obj $(OBJ_D)\apps.obj $(OBJ_D)\version.obj \
	$(OBJ_D)\sess_id.obj $(OBJ_D)\ssleay.obj

CRYPTOOBJ=$(OBJ_D)\cryptlib.obj \
	$(OBJ_D)\md2_dgst.obj $(OBJ_D)\md5_dgst.obj $(OBJ_D)\md2_one.obj \
	$(OBJ_D)\md5_one.obj $(OBJ_D)\sha_dgst.obj $(OBJ_D)\sha1dgst.obj \
	$(OBJ_D)\sha_one.obj $(OBJ_D)\sha1_one.obj $(OBJ_D)\set_key.obj \
	$(OBJ_D)\ecb_enc.obj $(OBJ_D)\ede_enc.obj $(OBJ_D)\cbc_enc.obj \
	$(OBJ_D)\cbc3_enc.obj $(OBJ_D)\ecb3_enc.obj $(OBJ_D)\cfb64enc.obj \
	$(OBJ_D)\cfb64ede.obj $(OBJ_D)\cfb_enc.obj $(OBJ_D)\ofb64ede.obj \
	$(OBJ_D)\enc_read.obj $(OBJ_D)\enc_writ.obj $(OBJ_D)\fcrypt.obj \
	$(OBJ_D)\ncbc_enc.obj $(OBJ_D)\ofb64enc.obj $(OBJ_D)\ofb_enc.obj \
	$(OBJ_D)\str2key.obj $(OBJ_D)\pcbc_enc.obj $(OBJ_D)\qud_cksm.obj \
	$(OBJ_D)\rand_key.obj $(OBJ_D)\xcbc_enc.obj $(OBJ_D)\read_pwd.obj \
	$(OBJ_D)\rpc_enc.obj $(OBJ_D)\cbc_cksm.obj $(OBJ_D)\supp.obj \
	$(OBJ_D)\rc4_enc.obj $(OBJ_D)\rc2_ecb.obj $(OBJ_D)\rc2_skey.obj \
	$(OBJ_D)\rc2_cbc.obj $(OBJ_D)\rc2cfb64.obj $(OBJ_D)\rc2ofb64.obj \
	$(OBJ_D)\i_cbc.obj $(OBJ_D)\i_cfb64.obj $(OBJ_D)\i_ofb64.obj \
	$(OBJ_D)\i_ecb.obj $(OBJ_D)\i_skey.obj $(OBJ_D)\bn_add.obj \
	$(OBJ_D)\bn_div.obj $(OBJ_D)\bn_exp.obj $(OBJ_D)\bn_lib.obj \
	$(OBJ_D)\bn_mod.obj $(OBJ_D)\bn_mul.obj $(OBJ_D)\bn_print.obj \
	$(OBJ_D)\bn_rand.obj $(OBJ_D)\bn_shift.obj $(OBJ_D)\bn_sub.obj \
	$(OBJ_D)\bn_word.obj $(OBJ_D)\bn_gcd.obj $(OBJ_D)\bn_prime.obj \
	$(OBJ_D)\bn_err.obj $(OBJ_D)\bn_sqr.obj $(BN_MULW_OBJ) \
	$(OBJ_D)\bn_recp.obj $(OBJ_D)\bn_mont.obj $(OBJ_D)\rsa_enc.obj \
	$(OBJ_D)\rsa_gen.obj $(OBJ_D)\rsa_lib.obj $(OBJ_D)\rsa_sign.obj \
	$(OBJ_D)\rsa_err.obj $(OBJ_D)\dsa_lib.obj $(OBJ_D)\dsa_vrf.obj \
	$(OBJ_D)\dsa_sign.obj $(OBJ_D)\dsa_err.obj $(OBJ_D)\dh_gen.obj \
	$(OBJ_D)\dh_key.obj $(OBJ_D)\dh_lib.obj $(OBJ_D)\dh_check.obj \
	$(OBJ_D)\dh_err.obj $(OBJ_D)\buffer.obj $(OBJ_D)\bio_lib.obj \
	$(OBJ_D)\bio_cb.obj $(OBJ_D)\buf_err.obj $(OBJ_D)\bss_mem.obj \
	$(OBJ_D)\bss_null.obj $(OBJ_D)\bss_fd.obj $(OBJ_D)\bss_file.obj \
	$(OBJ_D)\bss_sock.obj $(OBJ_D)\bf_buff.obj $(OBJ_D)\stack.obj \
	$(OBJ_D)\lhash.obj $(OBJ_D)\lh_stats.obj $(OBJ_D)\md5_rand.obj \
	$(OBJ_D)\randfile.obj $(OBJ_D)\err.obj $(OBJ_D)\err_all.obj \
	$(OBJ_D)\obj_dat.obj $(OBJ_D)\obj_lib.obj $(OBJ_D)\obj_err.obj \
	$(OBJ_D)\encode.obj $(OBJ_D)\digest.obj $(OBJ_D)\evp_enc.obj \
	$(OBJ_D)\evp_key.obj $(OBJ_D)\e_ecb_d.obj $(OBJ_D)\e_cbc_d.obj \
	$(OBJ_D)\e_cfb_d.obj $(OBJ_D)\e_ofb_d.obj $(OBJ_D)\e_ecb_i.obj \
	$(OBJ_D)\e_cbc_i.obj $(OBJ_D)\e_cfb_i.obj $(OBJ_D)\e_ofb_i.obj \
	$(OBJ_D)\e_ecb_3d.obj $(OBJ_D)\e_cbc_3d.obj $(OBJ_D)\e_rc4.obj \
	$(OBJ_D)\e_names.obj $(OBJ_D)\e_cfb_3d.obj $(OBJ_D)\e_ofb_3d.obj \
	$(OBJ_D)\e_xcbc_d.obj $(OBJ_D)\e_ecb_r2.obj $(OBJ_D)\e_cbc_r2.obj \
	$(OBJ_D)\e_cfb_r2.obj $(OBJ_D)\e_ofb_r2.obj $(OBJ_D)\m_md2.obj \
	$(OBJ_D)\m_md5.obj $(OBJ_D)\m_sha.obj $(OBJ_D)\m_sha1.obj \
	$(OBJ_D)\m_dss.obj $(OBJ_D)\m_dss1.obj $(OBJ_D)\m_names.obj \
	$(OBJ_D)\p_open.obj $(OBJ_D)\p_seal.obj $(OBJ_D)\p_sign.obj \
	$(OBJ_D)\p_verify.obj $(OBJ_D)\p_lib.obj $(OBJ_D)\bio_md.obj \
	$(OBJ_D)\evp_err.obj $(OBJ_D)\pem_sign.obj $(OBJ_D)\pem_seal.obj \
	$(OBJ_D)\pem_info.obj $(OBJ_D)\pem_lib.obj $(OBJ_D)\pem_err.obj \
	$(OBJ_D)\x509_def.obj $(OBJ_D)\x509_r2x.obj $(OBJ_D)\x509_cmp.obj \
	$(OBJ_D)\x509_obj.obj $(OBJ_D)\x509_req.obj $(OBJ_D)\x509_vrf.obj \
	$(OBJ_D)\x509_crt.obj $(OBJ_D)\x509_ath.obj $(OBJ_D)\x509_err.obj \
	$(OBJ_D)\a_object.obj $(OBJ_D)\a_bitstr.obj $(OBJ_D)\a_utctm.obj \
	$(OBJ_D)\a_int.obj $(OBJ_D)\a_octet.obj $(OBJ_D)\a_print.obj \
	$(OBJ_D)\a_type.obj $(OBJ_D)\a_set.obj $(OBJ_D)\a_dup.obj \
	$(OBJ_D)\a_d2i_fp.obj $(OBJ_D)\a_i2d_fp.obj $(OBJ_D)\a_sign.obj \
	$(OBJ_D)\a_verify.obj $(OBJ_D)\x_algor.obj $(OBJ_D)\x_val.obj \
	$(OBJ_D)\x_pubkey.obj $(OBJ_D)\x_sig.obj $(OBJ_D)\x_req.obj \
	$(OBJ_D)\x_attrib.obj $(OBJ_D)\x_name.obj $(OBJ_D)\x_cinf.obj \
	$(OBJ_D)\x_x509.obj $(OBJ_D)\x_crl.obj $(OBJ_D)\x_info.obj \
	$(OBJ_D)\x_spki.obj $(OBJ_D)\d2i_r_pr.obj $(OBJ_D)\i2d_r_pr.obj \
	$(OBJ_D)\d2i_r_pu.obj $(OBJ_D)\i2d_r_pu.obj $(OBJ_D)\d2i_s_pr.obj \
	$(OBJ_D)\d2i_s_pu.obj $(OBJ_D)\d2i_pu.obj $(OBJ_D)\d2i_pr.obj \
	$(OBJ_D)\i2d_pu.obj $(OBJ_D)\i2d_pr.obj $(OBJ_D)\t_req.obj \
	$(OBJ_D)\t_x509.obj $(OBJ_D)\t_pkey.obj $(OBJ_D)\p7_i_s.obj \
	$(OBJ_D)\p7_signi.obj $(OBJ_D)\p7_signd.obj $(OBJ_D)\p7_recip.obj \
	$(OBJ_D)\p7_enc_c.obj $(OBJ_D)\p7_evp.obj $(OBJ_D)\p7_dgst.obj \
	$(OBJ_D)\p7_s_e.obj $(OBJ_D)\p7_enc.obj $(OBJ_D)\p7_lib.obj \
	$(OBJ_D)\f_int.obj $(OBJ_D)\i2d_dh.obj $(OBJ_D)\d2i_dh.obj \
	$(OBJ_D)\n_pkey.obj $(OBJ_D)\a_hdr.obj $(OBJ_D)\x_pkey.obj \
	$(OBJ_D)\a_bool.obj $(OBJ_D)\x_exten.obj $(OBJ_D)\asn1_par.obj \
	$(OBJ_D)\asn1_lib.obj $(OBJ_D)\asn1_err.obj $(OBJ_D)\meth_lib.obj \
	$(OBJ_D)\x509meth.obj $(OBJ_D)\by_file.obj $(OBJ_D)\by_dir.obj \
	$(OBJ_D)\meth_err.obj $(OBJ_D)\conf.obj $(OBJ_D)\conf_err.obj \
	$(OBJ_D)\txt_db.obj

SSLOBJ=$(OBJ_D)\ssl_lib.obj \
	$(OBJ_D)\ssl_err2.obj $(OBJ_D)\ssl_trc.obj $(OBJ_D)\ssl_cert.obj \
	$(OBJ_D)\ssl_sess.obj $(OBJ_D)\ssl_srvr.obj $(OBJ_D)\ssl_clnt.obj \
	$(OBJ_D)\ssl_pkt.obj $(OBJ_D)\ssl_auth.obj $(OBJ_D)\ssl_stat.obj \
	$(OBJ_D)\ssl_asn1.obj $(OBJ_D)\ssl_txt.obj $(OBJ_D)\ssl_rsa.obj \
	$(OBJ_D)\ssl_null.obj $(OBJ_D)\ssl_des.obj $(OBJ_D)\ssl_idea.obj \
	$(OBJ_D)\ssl_rc4.obj $(OBJ_D)\ssl_rc2.obj $(OBJ_D)\bio_ssl.obj \
	$(OBJ_D)\ssl_md5.obj $(OBJ_D)\ssl_sha.obj $(OBJ_D)\ssl_err.obj

RSAGLUEOBJ=$(OBJ_D)\rsaref.obj \
	$(OBJ_D)\rsar_err.obj

T_EXE=$(TEST_D)\md2test.exe \
	$(TEST_D)\md5test.exe $(TEST_D)\shatest.exe $(TEST_D)\sha1test.exe \
	$(TEST_D)\destest.exe $(TEST_D)\rc4test.exe $(TEST_D)\rc2test.exe \
	$(TEST_D)\ideatest.exe $(TEST_D)\bntest.exe $(TEST_D)\dhtest.exe \
	$(TEST_D)\randtest.exe $(TEST_D)\ssltest.exe

###################################################################
all: banner $(OUT_D) $(TMP_D) headers lib exe

banner:
	@echo Make sure you have run 'perl Configure VC-MSDOS' in the
	@echo top level directory, if you don't have perl, you will
	@echo need to probably edit crypto/bn/bn.h, check the
	@echo documentation for details.


$(OUT_D):
	$(MKDIR) $(OUT_D)

$(TMP_D):
	$(MKDIR) $(TMP_D)

headers: $(HEADER) $(EXHEADER)

lib: $(LIBS_DEP)

exe: $(T_EXE) $(BIN_D)\$(E_EXE).exe

install:
	$(MKDIR) $(INSTALLTOP)
	$(MKDIR) $(INSTALLTOP)\bin
	$(MKDIR) $(INSTALLTOP)\include
	$(MKDIR) $(INSTALLTOP)\lib
	$(CP) $(INC_D)\*.h $(INSTALLTOP)\include
	$(CP) $(BIN_D)\$(E_EXE).exe $(INSTALLTOP)\bin
	$(CP) $(LIB_D)\$(O_SSL) $(INSTALLTOP)\lib
	$(CP) $(LIB_D)\$(O_CRYPTO) $(INSTALLTOP)\lib

clean:
	$(RM) $(TMP_D)\*.*

vclean:
	$(RM) $(TMP_D)\*.*
	$(RM) $(OUT_D)\*.*

$(INCL_D)\e_os.h: $(SRC_D)\.\e_os.h
	$(CP) $(SRC_D)\.\e_os.h $(INCL_D)\e_os.h

$(INCL_D)\cryptlib.h: $(SRC_D)\crypto\cryptlib.h
	$(CP) $(SRC_D)\crypto\cryptlib.h $(INCL_D)\cryptlib.h

$(INCL_D)\date.h: $(SRC_D)\crypto\date.h
	$(CP) $(SRC_D)\crypto\date.h $(INCL_D)\date.h

$(INCL_D)\md5_locl.h: $(SRC_D)\crypto\md\md5_locl.h
	$(CP) $(SRC_D)\crypto\md\md5_locl.h $(INCL_D)\md5_locl.h

$(INCL_D)\sha_locl.h: $(SRC_D)\crypto\sha\sha_locl.h
	$(CP) $(SRC_D)\crypto\sha\sha_locl.h $(INCL_D)\sha_locl.h

$(INCL_D)\des_locl.h: $(SRC_D)\crypto\des\des_locl.h
	$(CP) $(SRC_D)\crypto\des\des_locl.h $(INCL_D)\des_locl.h

$(INCL_D)\rpc_des.h: $(SRC_D)\crypto\des\rpc_des.h
	$(CP) $(SRC_D)\crypto\des\rpc_des.h $(INCL_D)\rpc_des.h

$(INCL_D)\podd.h: $(SRC_D)\crypto\des\podd.h
	$(CP) $(SRC_D)\crypto\des\podd.h $(INCL_D)\podd.h

$(INCL_D)\sk.h: $(SRC_D)\crypto\des\sk.h
	$(CP) $(SRC_D)\crypto\des\sk.h $(INCL_D)\sk.h

$(INCL_D)\spr.h: $(SRC_D)\crypto\des\spr.h
	$(CP) $(SRC_D)\crypto\des\spr.h $(INCL_D)\spr.h

$(INCL_D)\des_ver.h: $(SRC_D)\crypto\des\des_ver.h
	$(CP) $(SRC_D)\crypto\des\des_ver.h $(INCL_D)\des_ver.h

$(INCL_D)\rc2_locl.h: $(SRC_D)\crypto\rc2\rc2_locl.h
	$(CP) $(SRC_D)\crypto\rc2\rc2_locl.h $(INCL_D)\rc2_locl.h

$(INCL_D)\idea_lcl.h: $(SRC_D)\crypto\idea\idea_lcl.h
	$(CP) $(SRC_D)\crypto\idea\idea_lcl.h $(INCL_D)\idea_lcl.h

$(INCL_D)\bn_lcl.h: $(SRC_D)\crypto\bn\bn_lcl.h
	$(CP) $(SRC_D)\crypto\bn\bn_lcl.h $(INCL_D)\bn_lcl.h

$(INCL_D)\bn_prime.h: $(SRC_D)\crypto\bn\bn_prime.h
	$(CP) $(SRC_D)\crypto\bn\bn_prime.h $(INCL_D)\bn_prime.h

$(INCL_D)\obj_dat.h: $(SRC_D)\crypto\objects\obj_dat.h
	$(CP) $(SRC_D)\crypto\objects\obj_dat.h $(INCL_D)\obj_dat.h

$(INCL_D)\meth_lcl.h: $(SRC_D)\crypto\meth\meth_lcl.h
	$(CP) $(SRC_D)\crypto\meth\meth_lcl.h $(INCL_D)\meth_lcl.h

$(INCL_D)\x509meth.h: $(SRC_D)\crypto\meth\x509meth.h
	$(CP) $(SRC_D)\crypto\meth\x509meth.h $(INCL_D)\x509meth.h

$(INCL_D)\conf_lcl.h: $(SRC_D)\crypto\conf\conf_lcl.h
	$(CP) $(SRC_D)\crypto\conf\conf_lcl.h $(INCL_D)\conf_lcl.h

$(INCL_D)\ssl_locl.h: $(SRC_D)\ssl\ssl_locl.h
	$(CP) $(SRC_D)\ssl\ssl_locl.h $(INCL_D)\ssl_locl.h

$(INCL_D)\ssl_trc.h: $(SRC_D)\ssl\ssl_trc.h
	$(CP) $(SRC_D)\ssl\ssl_trc.h $(INCL_D)\ssl_trc.h

$(INCL_D)\ssl_rsa.h: $(SRC_D)\ssl\ssl_rsa.h
	$(CP) $(SRC_D)\ssl\ssl_rsa.h $(INCL_D)\ssl_rsa.h

$(INCL_D)\ssl_null.h: $(SRC_D)\ssl\ssl_null.h
	$(CP) $(SRC_D)\ssl\ssl_null.h $(INCL_D)\ssl_null.h

$(INCL_D)\ssl_md5.h: $(SRC_D)\ssl\ssl_md5.h
	$(CP) $(SRC_D)\ssl\ssl_md5.h $(INCL_D)\ssl_md5.h

$(INCL_D)\ssl_sha.h: $(SRC_D)\ssl\ssl_sha.h
	$(CP) $(SRC_D)\ssl\ssl_sha.h $(INCL_D)\ssl_sha.h

$(INCL_D)\ssl_des.h: $(SRC_D)\ssl\ssl_des.h
	$(CP) $(SRC_D)\ssl\ssl_des.h $(INCL_D)\ssl_des.h

$(INCL_D)\ssl_idea.h: $(SRC_D)\ssl\ssl_idea.h
	$(CP) $(SRC_D)\ssl\ssl_idea.h $(INCL_D)\ssl_idea.h

$(INCL_D)\ssl_rc4.h: $(SRC_D)\ssl\ssl_rc4.h
	$(CP) $(SRC_D)\ssl\ssl_rc4.h $(INCL_D)\ssl_rc4.h

$(INCL_D)\ssl_rc2.h: $(SRC_D)\ssl\ssl_rc2.h
	$(CP) $(SRC_D)\ssl\ssl_rc2.h $(INCL_D)\ssl_rc2.h

$(INCL_D)\rsaref.h: $(SRC_D)\rsaref\rsaref.h
	$(CP) $(SRC_D)\rsaref\rsaref.h $(INCL_D)\rsaref.h

$(INCL_D)\apps.h: $(SRC_D)\apps\apps.h
	$(CP) $(SRC_D)\apps\apps.h $(INCL_D)\apps.h

$(INCL_D)\progs.h: $(SRC_D)\apps\progs.h
	$(CP) $(SRC_D)\apps\progs.h $(INCL_D)\progs.h

$(INCL_D)\testcert.h: $(SRC_D)\apps\testcert.h
	$(CP) $(SRC_D)\apps\testcert.h $(INCL_D)\testcert.h

$(INC_D)\crypto.h: $(SRC_D)\crypto\crypto.h
	$(CP) $(SRC_D)\crypto\crypto.h $(INC_D)\crypto.h

$(INC_D)\cryptoall.h: $(SRC_D)\crypto\cryptoall.h
	$(CP) $(SRC_D)\crypto\cryptoall.h $(INC_D)\cryptoall.h

$(INC_D)\md2.h: $(SRC_D)\crypto\md\md2.h
	$(CP) $(SRC_D)\crypto\md\md2.h $(INC_D)\md2.h

$(INC_D)\md5.h: $(SRC_D)\crypto\md\md5.h
	$(CP) $(SRC_D)\crypto\md\md5.h $(INC_D)\md5.h

$(INC_D)\sha.h: $(SRC_D)\crypto\sha\sha.h
	$(CP) $(SRC_D)\crypto\sha\sha.h $(INC_D)\sha.h

$(INC_D)\des.h: $(SRC_D)\crypto\des\des.h
	$(CP) $(SRC_D)\crypto\des\des.h $(INC_D)\des.h

$(INC_D)\rc4.h: $(SRC_D)\crypto\rc4\rc4.h
	$(CP) $(SRC_D)\crypto\rc4\rc4.h $(INC_D)\rc4.h

$(INC_D)\rc2.h: $(SRC_D)\crypto\rc2\rc2.h
	$(CP) $(SRC_D)\crypto\rc2\rc2.h $(INC_D)\rc2.h

$(INC_D)\idea.h: $(SRC_D)\crypto\idea\idea.h
	$(CP) $(SRC_D)\crypto\idea\idea.h $(INC_D)\idea.h

$(INC_D)\bn.h: $(SRC_D)\crypto\bn\bn.h
	$(CP) $(SRC_D)\crypto\bn\bn.h $(INC_D)\bn.h

$(INC_D)\rsa.h: $(SRC_D)\crypto\rsa\rsa.h
	$(CP) $(SRC_D)\crypto\rsa\rsa.h $(INC_D)\rsa.h

$(INC_D)\dsa.h: $(SRC_D)\crypto\dsa\dsa.h
	$(CP) $(SRC_D)\crypto\dsa\dsa.h $(INC_D)\dsa.h

$(INC_D)\dh.h: $(SRC_D)\crypto\dh\dh.h
	$(CP) $(SRC_D)\crypto\dh\dh.h $(INC_D)\dh.h

$(INC_D)\buffer.h: $(SRC_D)\crypto\buffer\buffer.h
	$(CP) $(SRC_D)\crypto\buffer\buffer.h $(INC_D)\buffer.h

$(INC_D)\stack.h: $(SRC_D)\crypto\stack\stack.h
	$(CP) $(SRC_D)\crypto\stack\stack.h $(INC_D)\stack.h

$(INC_D)\lhash.h: $(SRC_D)\crypto\lhash\lhash.h
	$(CP) $(SRC_D)\crypto\lhash\lhash.h $(INC_D)\lhash.h

$(INC_D)\rand.h: $(SRC_D)\crypto\rand\rand.h
	$(CP) $(SRC_D)\crypto\rand\rand.h $(INC_D)\rand.h

$(INC_D)\err.h: $(SRC_D)\crypto\error\err.h
	$(CP) $(SRC_D)\crypto\error\err.h $(INC_D)\err.h

$(INC_D)\objects.h: $(SRC_D)\crypto\objects\objects.h
	$(CP) $(SRC_D)\crypto\objects\objects.h $(INC_D)\objects.h

$(INC_D)\envelope.h: $(SRC_D)\crypto\evp\envelope.h
	$(CP) $(SRC_D)\crypto\evp\envelope.h $(INC_D)\envelope.h

$(INC_D)\pem.h: $(SRC_D)\crypto\pem\pem.h
	$(CP) $(SRC_D)\crypto\pem\pem.h $(INC_D)\pem.h

$(INC_D)\x509.h: $(SRC_D)\crypto\x509\x509.h
	$(CP) $(SRC_D)\crypto\x509\x509.h $(INC_D)\x509.h

$(INC_D)\asn1.h: $(SRC_D)\crypto\asn1\asn1.h
	$(CP) $(SRC_D)\crypto\asn1\asn1.h $(INC_D)\asn1.h

$(INC_D)\asn1_mac.h: $(SRC_D)\crypto\asn1\asn1_mac.h
	$(CP) $(SRC_D)\crypto\asn1\asn1_mac.h $(INC_D)\asn1_mac.h

$(INC_D)\meth.h: $(SRC_D)\crypto\meth\meth.h
	$(CP) $(SRC_D)\crypto\meth\meth.h $(INC_D)\meth.h

$(INC_D)\conf.h: $(SRC_D)\crypto\conf\conf.h
	$(CP) $(SRC_D)\crypto\conf\conf.h $(INC_D)\conf.h

$(INC_D)\txt_db.h: $(SRC_D)\crypto\txt_db\txt_db.h
	$(CP) $(SRC_D)\crypto\txt_db\txt_db.h $(INC_D)\txt_db.h

$(INC_D)\pkcs7.h: $(SRC_D)\crypto\pkcs7\pkcs7.h
	$(CP) $(SRC_D)\crypto\pkcs7\pkcs7.h $(INC_D)\pkcs7.h

$(INC_D)\ssl.h: $(SRC_D)\ssl\ssl.h
	$(CP) $(SRC_D)\ssl\ssl.h $(INC_D)\ssl.h

$(OBJ_D)\md2test.obj: $(SRC_D)\crypto\md\md2test.c
	$(CC) /Fo$(OBJ_D)\md2test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\md\md2test.c

$(OBJ_D)\md5test.obj: $(SRC_D)\crypto\md\md5test.c
	$(CC) /Fo$(OBJ_D)\md5test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\md\md5test.c

$(OBJ_D)\shatest.obj: $(SRC_D)\crypto\sha\shatest.c
	$(CC) /Fo$(OBJ_D)\shatest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\shatest.c

$(OBJ_D)\sha1test.obj: $(SRC_D)\crypto\sha\sha1test.c
	$(CC) /Fo$(OBJ_D)\sha1test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\sha\sha1test.c

$(OBJ_D)\destest.obj: $(SRC_D)\crypto\des\destest.c
	$(CC) /Fo$(OBJ_D)\destest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\des\destest.c

$(OBJ_D)\rc4test.obj: $(SRC_D)\crypto\rc4\rc4test.c
	$(CC) /Fo$(OBJ_D)\rc4test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4test.c

$(OBJ_D)\rc2test.obj: $(SRC_D)\crypto\rc2\rc2test.c
	$(CC) /Fo$(OBJ_D)\rc2test.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2test.c

$(OBJ_D)\ideatest.obj: $(SRC_D)\crypto\idea\ideatest.c
	$(CC) /Fo$(OBJ_D)\ideatest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\idea\ideatest.c

$(OBJ_D)\bntest.obj: $(SRC_D)\crypto\bn\bntest.c
	$(CC) /Fo$(OBJ_D)\bntest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\bn\bntest.c

$(OBJ_D)\dhtest.obj: $(SRC_D)\crypto\dh\dhtest.c
	$(CC) /Fo$(OBJ_D)\dhtest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\dh\dhtest.c

$(OBJ_D)\randtest.obj: $(SRC_D)\crypto\rand\randtest.c
	$(CC) /Fo$(OBJ_D)\randtest.obj $(APP_CFLAGS) -c $(SRC_D)\crypto\rand\randtest.c

$(OBJ_D)\ssltest.obj: $(SRC_D)\ssl\ssltest.c
	$(CC) /Fo$(OBJ_D)\ssltest.obj $(APP_CFLAGS) -c $(SRC_D)\ssl\ssltest.c

$(OBJ_D)\verify.obj: $(SRC_D)\apps\verify.c
	$(CC) /Fo$(OBJ_D)\verify.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\verify.c

$(OBJ_D)\asn1pars.obj: $(SRC_D)\apps\asn1pars.c
	$(CC) /Fo$(OBJ_D)\asn1pars.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\asn1pars.c

$(OBJ_D)\req.obj: $(SRC_D)\apps\req.c
	$(CC) /Fo$(OBJ_D)\req.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\req.c

$(OBJ_D)\dgst.obj: $(SRC_D)\apps\dgst.c
	$(CC) /Fo$(OBJ_D)\dgst.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dgst.c

$(OBJ_D)\dh.obj: $(SRC_D)\apps\dh.c
	$(CC) /Fo$(OBJ_D)\dh.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\dh.c

$(OBJ_D)\enc.obj: $(SRC_D)\apps\enc.c
	$(CC) /Fo$(OBJ_D)\enc.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\enc.c

$(OBJ_D)\gendh.obj: $(SRC_D)\apps\gendh.c
	$(CC) /Fo$(OBJ_D)\gendh.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\gendh.c

$(OBJ_D)\errstr.obj: $(SRC_D)\apps\errstr.c
	$(CC) /Fo$(OBJ_D)\errstr.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\errstr.c

$(OBJ_D)\ca.obj: $(SRC_D)\apps\ca.c
	$(CC) /Fo$(OBJ_D)\ca.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ca.c

$(OBJ_D)\pkcs7.obj: $(SRC_D)\apps\pkcs7.c
	$(CC) /Fo$(OBJ_D)\pkcs7.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\pkcs7.c

$(OBJ_D)\crl2p7.obj: $(SRC_D)\apps\crl2p7.c
	$(CC) /Fo$(OBJ_D)\crl2p7.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl2p7.c

$(OBJ_D)\crl.obj: $(SRC_D)\apps\crl.c
	$(CC) /Fo$(OBJ_D)\crl.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\crl.c

$(OBJ_D)\rsa.obj: $(SRC_D)\apps\rsa.c
	$(CC) /Fo$(OBJ_D)\rsa.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\rsa.c

$(OBJ_D)\x509.obj: $(SRC_D)\apps\x509.c
	$(CC) /Fo$(OBJ_D)\x509.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\x509.c

$(OBJ_D)\genrsa.obj: $(SRC_D)\apps\genrsa.c
	$(CC) /Fo$(OBJ_D)\genrsa.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\genrsa.c

$(OBJ_D)\speed.obj: $(SRC_D)\apps\speed.c
	$(CC) /Fo$(OBJ_D)\speed.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\speed.c

$(OBJ_D)\hashdir.obj: $(SRC_D)\apps\hashdir.c
	$(CC) /Fo$(OBJ_D)\hashdir.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\hashdir.c

$(OBJ_D)\apps.obj: $(SRC_D)\apps\apps.c
	$(CC) /Fo$(OBJ_D)\apps.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\apps.c

$(OBJ_D)\version.obj: $(SRC_D)\apps\version.c
	$(CC) /Fo$(OBJ_D)\version.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\version.c

$(OBJ_D)\sess_id.obj: $(SRC_D)\apps\sess_id.c
	$(CC) /Fo$(OBJ_D)\sess_id.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\sess_id.c

$(OBJ_D)\ssleay.obj: $(SRC_D)\apps\ssleay.c
	$(CC) /Fo$(OBJ_D)\ssleay.obj -DMONOLITH $(APP_CFLAGS) -c $(SRC_D)\apps\ssleay.c

$(BN_MULW_OBJ): $(BN_MULW_SRC)
	$(ASM) /Fo$(BN_MULW_OBJ) $(SRC_D)\$(BN_MULW_SRC)

$(OBJ_D)\cryptlib.obj: $(SRC_D)\crypto\cryptlib.c
	$(CC) /Fo$(OBJ_D)\cryptlib.obj $(LIB_CFLAGS) -DCFLAGS="\"$(CC) $(CFLAG)\"" -c $(SRC_D)\crypto\cryptlib.c

$(OBJ_D)\md2_dgst.obj: $(SRC_D)\crypto\md\md2_dgst.c
	$(CC) /Fo$(OBJ_D)\md2_dgst.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\md\md2_dgst.c

$(OBJ_D)\md5_dgst.obj: $(SRC_D)\crypto\md\md5_dgst.c
	$(CC) /Fo$(OBJ_D)\md5_dgst.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\md\md5_dgst.c

$(OBJ_D)\md2_one.obj: $(SRC_D)\crypto\md\md2_one.c
	$(CC) /Fo$(OBJ_D)\md2_one.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\md\md2_one.c

$(OBJ_D)\md5_one.obj: $(SRC_D)\crypto\md\md5_one.c
	$(CC) /Fo$(OBJ_D)\md5_one.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\md\md5_one.c

$(OBJ_D)\sha_dgst.obj: $(SRC_D)\crypto\sha\sha_dgst.c
	$(CC) /Fo$(OBJ_D)\sha_dgst.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_dgst.c

$(OBJ_D)\sha1dgst.obj: $(SRC_D)\crypto\sha\sha1dgst.c
	$(CC) /Fo$(OBJ_D)\sha1dgst.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1dgst.c

$(OBJ_D)\sha_one.obj: $(SRC_D)\crypto\sha\sha_one.c
	$(CC) /Fo$(OBJ_D)\sha_one.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha_one.c

$(OBJ_D)\sha1_one.obj: $(SRC_D)\crypto\sha\sha1_one.c
	$(CC) /Fo$(OBJ_D)\sha1_one.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\sha\sha1_one.c

$(OBJ_D)\set_key.obj: $(SRC_D)\crypto\des\set_key.c
	$(CC) /Fo$(OBJ_D)\set_key.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\set_key.c

$(OBJ_D)\ecb_enc.obj: $(SRC_D)\crypto\des\ecb_enc.c
	$(CC) /Fo$(OBJ_D)\ecb_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb_enc.c

$(OBJ_D)\ede_enc.obj: $(SRC_D)\crypto\des\ede_enc.c
	$(CC) /Fo$(OBJ_D)\ede_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ede_enc.c

$(OBJ_D)\cbc_enc.obj: $(SRC_D)\crypto\des\cbc_enc.c
	$(CC) /Fo$(OBJ_D)\cbc_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_enc.c

$(OBJ_D)\cbc3_enc.obj: $(SRC_D)\crypto\des\cbc3_enc.c
	$(CC) /Fo$(OBJ_D)\cbc3_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc3_enc.c

$(OBJ_D)\ecb3_enc.obj: $(SRC_D)\crypto\des\ecb3_enc.c
	$(CC) /Fo$(OBJ_D)\ecb3_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ecb3_enc.c

$(OBJ_D)\cfb64enc.obj: $(SRC_D)\crypto\des\cfb64enc.c
	$(CC) /Fo$(OBJ_D)\cfb64enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64enc.c

$(OBJ_D)\cfb64ede.obj: $(SRC_D)\crypto\des\cfb64ede.c
	$(CC) /Fo$(OBJ_D)\cfb64ede.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb64ede.c

$(OBJ_D)\cfb_enc.obj: $(SRC_D)\crypto\des\cfb_enc.c
	$(CC) /Fo$(OBJ_D)\cfb_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cfb_enc.c

$(OBJ_D)\ofb64ede.obj: $(SRC_D)\crypto\des\ofb64ede.c
	$(CC) /Fo$(OBJ_D)\ofb64ede.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64ede.c

$(OBJ_D)\enc_read.obj: $(SRC_D)\crypto\des\enc_read.c
	$(CC) /Fo$(OBJ_D)\enc_read.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_read.c

$(OBJ_D)\enc_writ.obj: $(SRC_D)\crypto\des\enc_writ.c
	$(CC) /Fo$(OBJ_D)\enc_writ.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\enc_writ.c

$(OBJ_D)\fcrypt.obj: $(SRC_D)\crypto\des\fcrypt.c
	$(CC) /Fo$(OBJ_D)\fcrypt.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\fcrypt.c

$(OBJ_D)\ncbc_enc.obj: $(SRC_D)\crypto\des\ncbc_enc.c
	$(CC) /Fo$(OBJ_D)\ncbc_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ncbc_enc.c

$(OBJ_D)\ofb64enc.obj: $(SRC_D)\crypto\des\ofb64enc.c
	$(CC) /Fo$(OBJ_D)\ofb64enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb64enc.c

$(OBJ_D)\ofb_enc.obj: $(SRC_D)\crypto\des\ofb_enc.c
	$(CC) /Fo$(OBJ_D)\ofb_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\ofb_enc.c

$(OBJ_D)\str2key.obj: $(SRC_D)\crypto\des\str2key.c
	$(CC) /Fo$(OBJ_D)\str2key.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\str2key.c

$(OBJ_D)\pcbc_enc.obj: $(SRC_D)\crypto\des\pcbc_enc.c
	$(CC) /Fo$(OBJ_D)\pcbc_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\pcbc_enc.c

$(OBJ_D)\qud_cksm.obj: $(SRC_D)\crypto\des\qud_cksm.c
	$(CC) /Fo$(OBJ_D)\qud_cksm.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\qud_cksm.c

$(OBJ_D)\rand_key.obj: $(SRC_D)\crypto\des\rand_key.c
	$(CC) /Fo$(OBJ_D)\rand_key.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\rand_key.c

$(OBJ_D)\xcbc_enc.obj: $(SRC_D)\crypto\des\xcbc_enc.c
	$(CC) /Fo$(OBJ_D)\xcbc_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\xcbc_enc.c

$(OBJ_D)\read_pwd.obj: $(SRC_D)\crypto\des\read_pwd.c
	$(CC) /Fo$(OBJ_D)\read_pwd.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\read_pwd.c

$(OBJ_D)\rpc_enc.obj: $(SRC_D)\crypto\des\rpc_enc.c
	$(CC) /Fo$(OBJ_D)\rpc_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\rpc_enc.c

$(OBJ_D)\cbc_cksm.obj: $(SRC_D)\crypto\des\cbc_cksm.c
	$(CC) /Fo$(OBJ_D)\cbc_cksm.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\cbc_cksm.c

$(OBJ_D)\supp.obj: $(SRC_D)\crypto\des\supp.c
	$(CC) /Fo$(OBJ_D)\supp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\des\supp.c

$(OBJ_D)\rc4_enc.obj: $(SRC_D)\crypto\rc4\rc4_enc.c
	$(CC) /Fo$(OBJ_D)\rc4_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc4\rc4_enc.c

$(OBJ_D)\rc2_ecb.obj: $(SRC_D)\crypto\rc2\rc2_ecb.c
	$(CC) /Fo$(OBJ_D)\rc2_ecb.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_ecb.c

$(OBJ_D)\rc2_skey.obj: $(SRC_D)\crypto\rc2\rc2_skey.c
	$(CC) /Fo$(OBJ_D)\rc2_skey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_skey.c

$(OBJ_D)\rc2_cbc.obj: $(SRC_D)\crypto\rc2\rc2_cbc.c
	$(CC) /Fo$(OBJ_D)\rc2_cbc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2_cbc.c

$(OBJ_D)\rc2cfb64.obj: $(SRC_D)\crypto\rc2\rc2cfb64.c
	$(CC) /Fo$(OBJ_D)\rc2cfb64.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2cfb64.c

$(OBJ_D)\rc2ofb64.obj: $(SRC_D)\crypto\rc2\rc2ofb64.c
	$(CC) /Fo$(OBJ_D)\rc2ofb64.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rc2\rc2ofb64.c

$(OBJ_D)\i_cbc.obj: $(SRC_D)\crypto\idea\i_cbc.c
	$(CC) /Fo$(OBJ_D)\i_cbc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cbc.c

$(OBJ_D)\i_cfb64.obj: $(SRC_D)\crypto\idea\i_cfb64.c
	$(CC) /Fo$(OBJ_D)\i_cfb64.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_cfb64.c

$(OBJ_D)\i_ofb64.obj: $(SRC_D)\crypto\idea\i_ofb64.c
	$(CC) /Fo$(OBJ_D)\i_ofb64.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ofb64.c

$(OBJ_D)\i_ecb.obj: $(SRC_D)\crypto\idea\i_ecb.c
	$(CC) /Fo$(OBJ_D)\i_ecb.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_ecb.c

$(OBJ_D)\i_skey.obj: $(SRC_D)\crypto\idea\i_skey.c
	$(CC) /Fo$(OBJ_D)\i_skey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\idea\i_skey.c

$(OBJ_D)\bn_add.obj: $(SRC_D)\crypto\bn\bn_add.c
	$(CC) /Fo$(OBJ_D)\bn_add.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_add.c

$(OBJ_D)\bn_div.obj: $(SRC_D)\crypto\bn\bn_div.c
	$(CC) /Fo$(OBJ_D)\bn_div.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_div.c

$(OBJ_D)\bn_exp.obj: $(SRC_D)\crypto\bn\bn_exp.c
	$(CC) /Fo$(OBJ_D)\bn_exp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_exp.c

$(OBJ_D)\bn_lib.obj: $(SRC_D)\crypto\bn\bn_lib.c
	$(CC) /Fo$(OBJ_D)\bn_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_lib.c

$(OBJ_D)\bn_mod.obj: $(SRC_D)\crypto\bn\bn_mod.c
	$(CC) /Fo$(OBJ_D)\bn_mod.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mod.c

$(OBJ_D)\bn_mul.obj: $(SRC_D)\crypto\bn\bn_mul.c
	$(CC) /Fo$(OBJ_D)\bn_mul.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mul.c

$(OBJ_D)\bn_print.obj: $(SRC_D)\crypto\bn\bn_print.c
	$(CC) /Fo$(OBJ_D)\bn_print.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_print.c

$(OBJ_D)\bn_rand.obj: $(SRC_D)\crypto\bn\bn_rand.c
	$(CC) /Fo$(OBJ_D)\bn_rand.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_rand.c

$(OBJ_D)\bn_shift.obj: $(SRC_D)\crypto\bn\bn_shift.c
	$(CC) /Fo$(OBJ_D)\bn_shift.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_shift.c

$(OBJ_D)\bn_sub.obj: $(SRC_D)\crypto\bn\bn_sub.c
	$(CC) /Fo$(OBJ_D)\bn_sub.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_sub.c

$(OBJ_D)\bn_word.obj: $(SRC_D)\crypto\bn\bn_word.c
	$(CC) /Fo$(OBJ_D)\bn_word.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_word.c

$(OBJ_D)\bn_gcd.obj: $(SRC_D)\crypto\bn\bn_gcd.c
	$(CC) /Fo$(OBJ_D)\bn_gcd.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_gcd.c

$(OBJ_D)\bn_prime.obj: $(SRC_D)\crypto\bn\bn_prime.c
	$(CC) /Fo$(OBJ_D)\bn_prime.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_prime.c

$(OBJ_D)\bn_err.obj: $(SRC_D)\crypto\bn\bn_err.c
	$(CC) /Fo$(OBJ_D)\bn_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_err.c

$(OBJ_D)\bn_sqr.obj: $(SRC_D)\crypto\bn\bn_sqr.c
	$(CC) /Fo$(OBJ_D)\bn_sqr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_sqr.c

$(OBJ_D)\bn_mulw.obj: $(SRC_D)\crypto\bn\bn_mulw.c
	$(CC) /Fo$(OBJ_D)\bn_mulw.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mulw.c

$(OBJ_D)\bn_recp.obj: $(SRC_D)\crypto\bn\bn_recp.c
	$(CC) /Fo$(OBJ_D)\bn_recp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_recp.c

$(OBJ_D)\bn_mont.obj: $(SRC_D)\crypto\bn\bn_mont.c
	$(CC) /Fo$(OBJ_D)\bn_mont.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\bn\bn_mont.c

$(OBJ_D)\rsa_enc.obj: $(SRC_D)\crypto\rsa\rsa_enc.c
	$(CC) /Fo$(OBJ_D)\rsa_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_enc.c

$(OBJ_D)\rsa_gen.obj: $(SRC_D)\crypto\rsa\rsa_gen.c
	$(CC) /Fo$(OBJ_D)\rsa_gen.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_gen.c

$(OBJ_D)\rsa_lib.obj: $(SRC_D)\crypto\rsa\rsa_lib.c
	$(CC) /Fo$(OBJ_D)\rsa_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_lib.c

$(OBJ_D)\rsa_sign.obj: $(SRC_D)\crypto\rsa\rsa_sign.c
	$(CC) /Fo$(OBJ_D)\rsa_sign.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_sign.c

$(OBJ_D)\rsa_err.obj: $(SRC_D)\crypto\rsa\rsa_err.c
	$(CC) /Fo$(OBJ_D)\rsa_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rsa\rsa_err.c

$(OBJ_D)\dsa_lib.obj: $(SRC_D)\crypto\dsa\dsa_lib.c
	$(CC) /Fo$(OBJ_D)\dsa_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_lib.c

$(OBJ_D)\dsa_vrf.obj: $(SRC_D)\crypto\dsa\dsa_vrf.c
	$(CC) /Fo$(OBJ_D)\dsa_vrf.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_vrf.c

$(OBJ_D)\dsa_sign.obj: $(SRC_D)\crypto\dsa\dsa_sign.c
	$(CC) /Fo$(OBJ_D)\dsa_sign.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_sign.c

$(OBJ_D)\dsa_err.obj: $(SRC_D)\crypto\dsa\dsa_err.c
	$(CC) /Fo$(OBJ_D)\dsa_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dsa\dsa_err.c

$(OBJ_D)\dh_gen.obj: $(SRC_D)\crypto\dh\dh_gen.c
	$(CC) /Fo$(OBJ_D)\dh_gen.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_gen.c

$(OBJ_D)\dh_key.obj: $(SRC_D)\crypto\dh\dh_key.c
	$(CC) /Fo$(OBJ_D)\dh_key.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_key.c

$(OBJ_D)\dh_lib.obj: $(SRC_D)\crypto\dh\dh_lib.c
	$(CC) /Fo$(OBJ_D)\dh_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_lib.c

$(OBJ_D)\dh_check.obj: $(SRC_D)\crypto\dh\dh_check.c
	$(CC) /Fo$(OBJ_D)\dh_check.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_check.c

$(OBJ_D)\dh_err.obj: $(SRC_D)\crypto\dh\dh_err.c
	$(CC) /Fo$(OBJ_D)\dh_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\dh\dh_err.c

$(OBJ_D)\buffer.obj: $(SRC_D)\crypto\buffer\buffer.c
	$(CC) /Fo$(OBJ_D)\buffer.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buffer.c

$(OBJ_D)\bio_lib.obj: $(SRC_D)\crypto\buffer\bio_lib.c
	$(CC) /Fo$(OBJ_D)\bio_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bio_lib.c

$(OBJ_D)\bio_cb.obj: $(SRC_D)\crypto\buffer\bio_cb.c
	$(CC) /Fo$(OBJ_D)\bio_cb.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bio_cb.c

$(OBJ_D)\buf_err.obj: $(SRC_D)\crypto\buffer\buf_err.c
	$(CC) /Fo$(OBJ_D)\buf_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\buf_err.c

$(OBJ_D)\bss_mem.obj: $(SRC_D)\crypto\buffer\bss_mem.c
	$(CC) /Fo$(OBJ_D)\bss_mem.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bss_mem.c

$(OBJ_D)\bss_null.obj: $(SRC_D)\crypto\buffer\bss_null.c
	$(CC) /Fo$(OBJ_D)\bss_null.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bss_null.c

$(OBJ_D)\bss_fd.obj: $(SRC_D)\crypto\buffer\bss_fd.c
	$(CC) /Fo$(OBJ_D)\bss_fd.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bss_fd.c

$(OBJ_D)\bss_file.obj: $(SRC_D)\crypto\buffer\bss_file.c
	$(CC) /Fo$(OBJ_D)\bss_file.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bss_file.c

$(OBJ_D)\bss_sock.obj: $(SRC_D)\crypto\buffer\bss_sock.c
	$(CC) /Fo$(OBJ_D)\bss_sock.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bss_sock.c

$(OBJ_D)\bf_buff.obj: $(SRC_D)\crypto\buffer\bf_buff.c
	$(CC) /Fo$(OBJ_D)\bf_buff.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\buffer\bf_buff.c

$(OBJ_D)\stack.obj: $(SRC_D)\crypto\stack\stack.c
	$(CC) /Fo$(OBJ_D)\stack.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\stack\stack.c

$(OBJ_D)\lhash.obj: $(SRC_D)\crypto\lhash\lhash.c
	$(CC) /Fo$(OBJ_D)\lhash.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lhash.c

$(OBJ_D)\lh_stats.obj: $(SRC_D)\crypto\lhash\lh_stats.c
	$(CC) /Fo$(OBJ_D)\lh_stats.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\lhash\lh_stats.c

$(OBJ_D)\md5_rand.obj: $(SRC_D)\crypto\rand\md5_rand.c
	$(CC) /Fo$(OBJ_D)\md5_rand.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\md5_rand.c

$(OBJ_D)\randfile.obj: $(SRC_D)\crypto\rand\randfile.c
	$(CC) /Fo$(OBJ_D)\randfile.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\rand\randfile.c

$(OBJ_D)\err.obj: $(SRC_D)\crypto\error\err.c
	$(CC) /Fo$(OBJ_D)\err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\error\err.c

$(OBJ_D)\err_all.obj: $(SRC_D)\crypto\error\err_all.c
	$(CC) /Fo$(OBJ_D)\err_all.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\error\err_all.c

$(OBJ_D)\obj_dat.obj: $(SRC_D)\crypto\objects\obj_dat.c
	$(CC) /Fo$(OBJ_D)\obj_dat.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_dat.c

$(OBJ_D)\obj_lib.obj: $(SRC_D)\crypto\objects\obj_lib.c
	$(CC) /Fo$(OBJ_D)\obj_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_lib.c

$(OBJ_D)\obj_err.obj: $(SRC_D)\crypto\objects\obj_err.c
	$(CC) /Fo$(OBJ_D)\obj_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\objects\obj_err.c

$(OBJ_D)\encode.obj: $(SRC_D)\crypto\evp\encode.c
	$(CC) /Fo$(OBJ_D)\encode.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\encode.c

$(OBJ_D)\digest.obj: $(SRC_D)\crypto\evp\digest.c
	$(CC) /Fo$(OBJ_D)\digest.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\digest.c

$(OBJ_D)\evp_enc.obj: $(SRC_D)\crypto\evp\evp_enc.c
	$(CC) /Fo$(OBJ_D)\evp_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_enc.c

$(OBJ_D)\evp_key.obj: $(SRC_D)\crypto\evp\evp_key.c
	$(CC) /Fo$(OBJ_D)\evp_key.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_key.c

$(OBJ_D)\e_ecb_d.obj: $(SRC_D)\crypto\evp\e_ecb_d.c
	$(CC) /Fo$(OBJ_D)\e_ecb_d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_d.c

$(OBJ_D)\e_cbc_d.obj: $(SRC_D)\crypto\evp\e_cbc_d.c
	$(CC) /Fo$(OBJ_D)\e_cbc_d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_d.c

$(OBJ_D)\e_cfb_d.obj: $(SRC_D)\crypto\evp\e_cfb_d.c
	$(CC) /Fo$(OBJ_D)\e_cfb_d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_d.c

$(OBJ_D)\e_ofb_d.obj: $(SRC_D)\crypto\evp\e_ofb_d.c
	$(CC) /Fo$(OBJ_D)\e_ofb_d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_d.c

$(OBJ_D)\e_ecb_i.obj: $(SRC_D)\crypto\evp\e_ecb_i.c
	$(CC) /Fo$(OBJ_D)\e_ecb_i.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_i.c

$(OBJ_D)\e_cbc_i.obj: $(SRC_D)\crypto\evp\e_cbc_i.c
	$(CC) /Fo$(OBJ_D)\e_cbc_i.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_i.c

$(OBJ_D)\e_cfb_i.obj: $(SRC_D)\crypto\evp\e_cfb_i.c
	$(CC) /Fo$(OBJ_D)\e_cfb_i.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_i.c

$(OBJ_D)\e_ofb_i.obj: $(SRC_D)\crypto\evp\e_ofb_i.c
	$(CC) /Fo$(OBJ_D)\e_ofb_i.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_i.c

$(OBJ_D)\e_ecb_3d.obj: $(SRC_D)\crypto\evp\e_ecb_3d.c
	$(CC) /Fo$(OBJ_D)\e_ecb_3d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_3d.c

$(OBJ_D)\e_cbc_3d.obj: $(SRC_D)\crypto\evp\e_cbc_3d.c
	$(CC) /Fo$(OBJ_D)\e_cbc_3d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_3d.c

$(OBJ_D)\e_rc4.obj: $(SRC_D)\crypto\evp\e_rc4.c
	$(CC) /Fo$(OBJ_D)\e_rc4.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_rc4.c

$(OBJ_D)\e_names.obj: $(SRC_D)\crypto\evp\e_names.c
	$(CC) /Fo$(OBJ_D)\e_names.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_names.c

$(OBJ_D)\e_cfb_3d.obj: $(SRC_D)\crypto\evp\e_cfb_3d.c
	$(CC) /Fo$(OBJ_D)\e_cfb_3d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_3d.c

$(OBJ_D)\e_ofb_3d.obj: $(SRC_D)\crypto\evp\e_ofb_3d.c
	$(CC) /Fo$(OBJ_D)\e_ofb_3d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_3d.c

$(OBJ_D)\e_xcbc_d.obj: $(SRC_D)\crypto\evp\e_xcbc_d.c
	$(CC) /Fo$(OBJ_D)\e_xcbc_d.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_xcbc_d.c

$(OBJ_D)\e_ecb_r2.obj: $(SRC_D)\crypto\evp\e_ecb_r2.c
	$(CC) /Fo$(OBJ_D)\e_ecb_r2.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ecb_r2.c

$(OBJ_D)\e_cbc_r2.obj: $(SRC_D)\crypto\evp\e_cbc_r2.c
	$(CC) /Fo$(OBJ_D)\e_cbc_r2.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cbc_r2.c

$(OBJ_D)\e_cfb_r2.obj: $(SRC_D)\crypto\evp\e_cfb_r2.c
	$(CC) /Fo$(OBJ_D)\e_cfb_r2.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_cfb_r2.c

$(OBJ_D)\e_ofb_r2.obj: $(SRC_D)\crypto\evp\e_ofb_r2.c
	$(CC) /Fo$(OBJ_D)\e_ofb_r2.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\e_ofb_r2.c

$(OBJ_D)\m_md2.obj: $(SRC_D)\crypto\evp\m_md2.c
	$(CC) /Fo$(OBJ_D)\m_md2.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md2.c

$(OBJ_D)\m_md5.obj: $(SRC_D)\crypto\evp\m_md5.c
	$(CC) /Fo$(OBJ_D)\m_md5.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_md5.c

$(OBJ_D)\m_sha.obj: $(SRC_D)\crypto\evp\m_sha.c
	$(CC) /Fo$(OBJ_D)\m_sha.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha.c

$(OBJ_D)\m_sha1.obj: $(SRC_D)\crypto\evp\m_sha1.c
	$(CC) /Fo$(OBJ_D)\m_sha1.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_sha1.c

$(OBJ_D)\m_dss.obj: $(SRC_D)\crypto\evp\m_dss.c
	$(CC) /Fo$(OBJ_D)\m_dss.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss.c

$(OBJ_D)\m_dss1.obj: $(SRC_D)\crypto\evp\m_dss1.c
	$(CC) /Fo$(OBJ_D)\m_dss1.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_dss1.c

$(OBJ_D)\m_names.obj: $(SRC_D)\crypto\evp\m_names.c
	$(CC) /Fo$(OBJ_D)\m_names.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\m_names.c

$(OBJ_D)\p_open.obj: $(SRC_D)\crypto\evp\p_open.c
	$(CC) /Fo$(OBJ_D)\p_open.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_open.c

$(OBJ_D)\p_seal.obj: $(SRC_D)\crypto\evp\p_seal.c
	$(CC) /Fo$(OBJ_D)\p_seal.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_seal.c

$(OBJ_D)\p_sign.obj: $(SRC_D)\crypto\evp\p_sign.c
	$(CC) /Fo$(OBJ_D)\p_sign.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_sign.c

$(OBJ_D)\p_verify.obj: $(SRC_D)\crypto\evp\p_verify.c
	$(CC) /Fo$(OBJ_D)\p_verify.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_verify.c

$(OBJ_D)\p_lib.obj: $(SRC_D)\crypto\evp\p_lib.c
	$(CC) /Fo$(OBJ_D)\p_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\p_lib.c

$(OBJ_D)\bio_md.obj: $(SRC_D)\crypto\evp\bio_md.c
	$(CC) /Fo$(OBJ_D)\bio_md.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\bio_md.c

$(OBJ_D)\evp_err.obj: $(SRC_D)\crypto\evp\evp_err.c
	$(CC) /Fo$(OBJ_D)\evp_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\evp\evp_err.c

$(OBJ_D)\pem_sign.obj: $(SRC_D)\crypto\pem\pem_sign.c
	$(CC) /Fo$(OBJ_D)\pem_sign.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_sign.c

$(OBJ_D)\pem_seal.obj: $(SRC_D)\crypto\pem\pem_seal.c
	$(CC) /Fo$(OBJ_D)\pem_seal.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_seal.c

$(OBJ_D)\pem_info.obj: $(SRC_D)\crypto\pem\pem_info.c
	$(CC) /Fo$(OBJ_D)\pem_info.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_info.c

$(OBJ_D)\pem_lib.obj: $(SRC_D)\crypto\pem\pem_lib.c
	$(CC) /Fo$(OBJ_D)\pem_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_lib.c

$(OBJ_D)\pem_err.obj: $(SRC_D)\crypto\pem\pem_err.c
	$(CC) /Fo$(OBJ_D)\pem_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\pem\pem_err.c

$(OBJ_D)\x509_def.obj: $(SRC_D)\crypto\x509\x509_def.c
	$(CC) /Fo$(OBJ_D)\x509_def.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_def.c

$(OBJ_D)\x509_r2x.obj: $(SRC_D)\crypto\x509\x509_r2x.c
	$(CC) /Fo$(OBJ_D)\x509_r2x.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_r2x.c

$(OBJ_D)\x509_cmp.obj: $(SRC_D)\crypto\x509\x509_cmp.c
	$(CC) /Fo$(OBJ_D)\x509_cmp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_cmp.c

$(OBJ_D)\x509_obj.obj: $(SRC_D)\crypto\x509\x509_obj.c
	$(CC) /Fo$(OBJ_D)\x509_obj.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_obj.c

$(OBJ_D)\x509_req.obj: $(SRC_D)\crypto\x509\x509_req.c
	$(CC) /Fo$(OBJ_D)\x509_req.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_req.c

$(OBJ_D)\x509_vrf.obj: $(SRC_D)\crypto\x509\x509_vrf.c
	$(CC) /Fo$(OBJ_D)\x509_vrf.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_vrf.c

$(OBJ_D)\x509_crt.obj: $(SRC_D)\crypto\x509\x509_crt.c
	$(CC) /Fo$(OBJ_D)\x509_crt.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_crt.c

$(OBJ_D)\x509_ath.obj: $(SRC_D)\crypto\x509\x509_ath.c
	$(CC) /Fo$(OBJ_D)\x509_ath.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_ath.c

$(OBJ_D)\x509_err.obj: $(SRC_D)\crypto\x509\x509_err.c
	$(CC) /Fo$(OBJ_D)\x509_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\x509\x509_err.c

$(OBJ_D)\a_object.obj: $(SRC_D)\crypto\asn1\a_object.c
	$(CC) /Fo$(OBJ_D)\a_object.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_object.c

$(OBJ_D)\a_bitstr.obj: $(SRC_D)\crypto\asn1\a_bitstr.c
	$(CC) /Fo$(OBJ_D)\a_bitstr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bitstr.c

$(OBJ_D)\a_utctm.obj: $(SRC_D)\crypto\asn1\a_utctm.c
	$(CC) /Fo$(OBJ_D)\a_utctm.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_utctm.c

$(OBJ_D)\a_int.obj: $(SRC_D)\crypto\asn1\a_int.c
	$(CC) /Fo$(OBJ_D)\a_int.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_int.c

$(OBJ_D)\a_octet.obj: $(SRC_D)\crypto\asn1\a_octet.c
	$(CC) /Fo$(OBJ_D)\a_octet.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_octet.c

$(OBJ_D)\a_print.obj: $(SRC_D)\crypto\asn1\a_print.c
	$(CC) /Fo$(OBJ_D)\a_print.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_print.c

$(OBJ_D)\a_type.obj: $(SRC_D)\crypto\asn1\a_type.c
	$(CC) /Fo$(OBJ_D)\a_type.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_type.c

$(OBJ_D)\a_set.obj: $(SRC_D)\crypto\asn1\a_set.c
	$(CC) /Fo$(OBJ_D)\a_set.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_set.c

$(OBJ_D)\a_dup.obj: $(SRC_D)\crypto\asn1\a_dup.c
	$(CC) /Fo$(OBJ_D)\a_dup.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_dup.c

$(OBJ_D)\a_d2i_fp.obj: $(SRC_D)\crypto\asn1\a_d2i_fp.c
	$(CC) /Fo$(OBJ_D)\a_d2i_fp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_d2i_fp.c

$(OBJ_D)\a_i2d_fp.obj: $(SRC_D)\crypto\asn1\a_i2d_fp.c
	$(CC) /Fo$(OBJ_D)\a_i2d_fp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_i2d_fp.c

$(OBJ_D)\a_sign.obj: $(SRC_D)\crypto\asn1\a_sign.c
	$(CC) /Fo$(OBJ_D)\a_sign.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_sign.c

$(OBJ_D)\a_verify.obj: $(SRC_D)\crypto\asn1\a_verify.c
	$(CC) /Fo$(OBJ_D)\a_verify.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_verify.c

$(OBJ_D)\x_algor.obj: $(SRC_D)\crypto\asn1\x_algor.c
	$(CC) /Fo$(OBJ_D)\x_algor.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_algor.c

$(OBJ_D)\x_val.obj: $(SRC_D)\crypto\asn1\x_val.c
	$(CC) /Fo$(OBJ_D)\x_val.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_val.c

$(OBJ_D)\x_pubkey.obj: $(SRC_D)\crypto\asn1\x_pubkey.c
	$(CC) /Fo$(OBJ_D)\x_pubkey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pubkey.c

$(OBJ_D)\x_sig.obj: $(SRC_D)\crypto\asn1\x_sig.c
	$(CC) /Fo$(OBJ_D)\x_sig.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_sig.c

$(OBJ_D)\x_req.obj: $(SRC_D)\crypto\asn1\x_req.c
	$(CC) /Fo$(OBJ_D)\x_req.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_req.c

$(OBJ_D)\x_attrib.obj: $(SRC_D)\crypto\asn1\x_attrib.c
	$(CC) /Fo$(OBJ_D)\x_attrib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_attrib.c

$(OBJ_D)\x_name.obj: $(SRC_D)\crypto\asn1\x_name.c
	$(CC) /Fo$(OBJ_D)\x_name.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_name.c

$(OBJ_D)\x_cinf.obj: $(SRC_D)\crypto\asn1\x_cinf.c
	$(CC) /Fo$(OBJ_D)\x_cinf.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_cinf.c

$(OBJ_D)\x_x509.obj: $(SRC_D)\crypto\asn1\x_x509.c
	$(CC) /Fo$(OBJ_D)\x_x509.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_x509.c

$(OBJ_D)\x_crl.obj: $(SRC_D)\crypto\asn1\x_crl.c
	$(CC) /Fo$(OBJ_D)\x_crl.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_crl.c

$(OBJ_D)\x_info.obj: $(SRC_D)\crypto\asn1\x_info.c
	$(CC) /Fo$(OBJ_D)\x_info.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_info.c

$(OBJ_D)\x_spki.obj: $(SRC_D)\crypto\asn1\x_spki.c
	$(CC) /Fo$(OBJ_D)\x_spki.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_spki.c

$(OBJ_D)\d2i_r_pr.obj: $(SRC_D)\crypto\asn1\d2i_r_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_r_pr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_r_pr.c

$(OBJ_D)\i2d_r_pr.obj: $(SRC_D)\crypto\asn1\i2d_r_pr.c
	$(CC) /Fo$(OBJ_D)\i2d_r_pr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_r_pr.c

$(OBJ_D)\d2i_r_pu.obj: $(SRC_D)\crypto\asn1\d2i_r_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_r_pu.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_r_pu.c

$(OBJ_D)\i2d_r_pu.obj: $(SRC_D)\crypto\asn1\i2d_r_pu.c
	$(CC) /Fo$(OBJ_D)\i2d_r_pu.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_r_pu.c

$(OBJ_D)\d2i_s_pr.obj: $(SRC_D)\crypto\asn1\d2i_s_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_s_pr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_s_pr.c

$(OBJ_D)\d2i_s_pu.obj: $(SRC_D)\crypto\asn1\d2i_s_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_s_pu.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_s_pu.c

$(OBJ_D)\d2i_pu.obj: $(SRC_D)\crypto\asn1\d2i_pu.c
	$(CC) /Fo$(OBJ_D)\d2i_pu.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pu.c

$(OBJ_D)\d2i_pr.obj: $(SRC_D)\crypto\asn1\d2i_pr.c
	$(CC) /Fo$(OBJ_D)\d2i_pr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_pr.c

$(OBJ_D)\i2d_pu.obj: $(SRC_D)\crypto\asn1\i2d_pu.c
	$(CC) /Fo$(OBJ_D)\i2d_pu.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pu.c

$(OBJ_D)\i2d_pr.obj: $(SRC_D)\crypto\asn1\i2d_pr.c
	$(CC) /Fo$(OBJ_D)\i2d_pr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_pr.c

$(OBJ_D)\t_req.obj: $(SRC_D)\crypto\asn1\t_req.c
	$(CC) /Fo$(OBJ_D)\t_req.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_req.c

$(OBJ_D)\t_x509.obj: $(SRC_D)\crypto\asn1\t_x509.c
	$(CC) /Fo$(OBJ_D)\t_x509.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_x509.c

$(OBJ_D)\t_pkey.obj: $(SRC_D)\crypto\asn1\t_pkey.c
	$(CC) /Fo$(OBJ_D)\t_pkey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\t_pkey.c

$(OBJ_D)\p7_i_s.obj: $(SRC_D)\crypto\asn1\p7_i_s.c
	$(CC) /Fo$(OBJ_D)\p7_i_s.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_i_s.c

$(OBJ_D)\p7_signi.obj: $(SRC_D)\crypto\asn1\p7_signi.c
	$(CC) /Fo$(OBJ_D)\p7_signi.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_signi.c

$(OBJ_D)\p7_signd.obj: $(SRC_D)\crypto\asn1\p7_signd.c
	$(CC) /Fo$(OBJ_D)\p7_signd.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_signd.c

$(OBJ_D)\p7_recip.obj: $(SRC_D)\crypto\asn1\p7_recip.c
	$(CC) /Fo$(OBJ_D)\p7_recip.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_recip.c

$(OBJ_D)\p7_enc_c.obj: $(SRC_D)\crypto\asn1\p7_enc_c.c
	$(CC) /Fo$(OBJ_D)\p7_enc_c.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_enc_c.c

$(OBJ_D)\p7_evp.obj: $(SRC_D)\crypto\asn1\p7_evp.c
	$(CC) /Fo$(OBJ_D)\p7_evp.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_evp.c

$(OBJ_D)\p7_dgst.obj: $(SRC_D)\crypto\asn1\p7_dgst.c
	$(CC) /Fo$(OBJ_D)\p7_dgst.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_dgst.c

$(OBJ_D)\p7_s_e.obj: $(SRC_D)\crypto\asn1\p7_s_e.c
	$(CC) /Fo$(OBJ_D)\p7_s_e.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_s_e.c

$(OBJ_D)\p7_enc.obj: $(SRC_D)\crypto\asn1\p7_enc.c
	$(CC) /Fo$(OBJ_D)\p7_enc.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_enc.c

$(OBJ_D)\p7_lib.obj: $(SRC_D)\crypto\asn1\p7_lib.c
	$(CC) /Fo$(OBJ_D)\p7_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\p7_lib.c

$(OBJ_D)\f_int.obj: $(SRC_D)\crypto\asn1\f_int.c
	$(CC) /Fo$(OBJ_D)\f_int.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\f_int.c

$(OBJ_D)\i2d_dh.obj: $(SRC_D)\crypto\asn1\i2d_dh.c
	$(CC) /Fo$(OBJ_D)\i2d_dh.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\i2d_dh.c

$(OBJ_D)\d2i_dh.obj: $(SRC_D)\crypto\asn1\d2i_dh.c
	$(CC) /Fo$(OBJ_D)\d2i_dh.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\d2i_dh.c

$(OBJ_D)\n_pkey.obj: $(SRC_D)\crypto\asn1\n_pkey.c
	$(CC) /Fo$(OBJ_D)\n_pkey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\n_pkey.c

$(OBJ_D)\a_hdr.obj: $(SRC_D)\crypto\asn1\a_hdr.c
	$(CC) /Fo$(OBJ_D)\a_hdr.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_hdr.c

$(OBJ_D)\x_pkey.obj: $(SRC_D)\crypto\asn1\x_pkey.c
	$(CC) /Fo$(OBJ_D)\x_pkey.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_pkey.c

$(OBJ_D)\a_bool.obj: $(SRC_D)\crypto\asn1\a_bool.c
	$(CC) /Fo$(OBJ_D)\a_bool.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\a_bool.c

$(OBJ_D)\x_exten.obj: $(SRC_D)\crypto\asn1\x_exten.c
	$(CC) /Fo$(OBJ_D)\x_exten.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\x_exten.c

$(OBJ_D)\asn1_par.obj: $(SRC_D)\crypto\asn1\asn1_par.c
	$(CC) /Fo$(OBJ_D)\asn1_par.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_par.c

$(OBJ_D)\asn1_lib.obj: $(SRC_D)\crypto\asn1\asn1_lib.c
	$(CC) /Fo$(OBJ_D)\asn1_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_lib.c

$(OBJ_D)\asn1_err.obj: $(SRC_D)\crypto\asn1\asn1_err.c
	$(CC) /Fo$(OBJ_D)\asn1_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\asn1\asn1_err.c

$(OBJ_D)\meth_lib.obj: $(SRC_D)\crypto\meth\meth_lib.c
	$(CC) /Fo$(OBJ_D)\meth_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\meth\meth_lib.c

$(OBJ_D)\x509meth.obj: $(SRC_D)\crypto\meth\x509meth.c
	$(CC) /Fo$(OBJ_D)\x509meth.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\meth\x509meth.c

$(OBJ_D)\by_file.obj: $(SRC_D)\crypto\meth\by_file.c
	$(CC) /Fo$(OBJ_D)\by_file.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\meth\by_file.c

$(OBJ_D)\by_dir.obj: $(SRC_D)\crypto\meth\by_dir.c
	$(CC) /Fo$(OBJ_D)\by_dir.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\meth\by_dir.c

$(OBJ_D)\meth_err.obj: $(SRC_D)\crypto\meth\meth_err.c
	$(CC) /Fo$(OBJ_D)\meth_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\meth\meth_err.c

$(OBJ_D)\conf.obj: $(SRC_D)\crypto\conf\conf.c
	$(CC) /Fo$(OBJ_D)\conf.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf.c

$(OBJ_D)\conf_err.obj: $(SRC_D)\crypto\conf\conf_err.c
	$(CC) /Fo$(OBJ_D)\conf_err.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\conf\conf_err.c

$(OBJ_D)\txt_db.obj: $(SRC_D)\crypto\txt_db\txt_db.c
	$(CC) /Fo$(OBJ_D)\txt_db.obj $(LIB_CFLAGS) -c $(SRC_D)\crypto\txt_db\txt_db.c

$(OBJ_D)\ssl_lib.obj: $(SRC_D)\ssl\ssl_lib.c
	$(CC) /Fo$(OBJ_D)\ssl_lib.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_lib.c

$(OBJ_D)\ssl_err2.obj: $(SRC_D)\ssl\ssl_err2.c
	$(CC) /Fo$(OBJ_D)\ssl_err2.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err2.c

$(OBJ_D)\ssl_trc.obj: $(SRC_D)\ssl\ssl_trc.c
	$(CC) /Fo$(OBJ_D)\ssl_trc.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_trc.c

$(OBJ_D)\ssl_cert.obj: $(SRC_D)\ssl\ssl_cert.c
	$(CC) /Fo$(OBJ_D)\ssl_cert.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_cert.c

$(OBJ_D)\ssl_sess.obj: $(SRC_D)\ssl\ssl_sess.c
	$(CC) /Fo$(OBJ_D)\ssl_sess.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_sess.c

$(OBJ_D)\ssl_srvr.obj: $(SRC_D)\ssl\ssl_srvr.c
	$(CC) /Fo$(OBJ_D)\ssl_srvr.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_srvr.c

$(OBJ_D)\ssl_clnt.obj: $(SRC_D)\ssl\ssl_clnt.c
	$(CC) /Fo$(OBJ_D)\ssl_clnt.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_clnt.c

$(OBJ_D)\ssl_pkt.obj: $(SRC_D)\ssl\ssl_pkt.c
	$(CC) /Fo$(OBJ_D)\ssl_pkt.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_pkt.c

$(OBJ_D)\ssl_auth.obj: $(SRC_D)\ssl\ssl_auth.c
	$(CC) /Fo$(OBJ_D)\ssl_auth.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_auth.c

$(OBJ_D)\ssl_stat.obj: $(SRC_D)\ssl\ssl_stat.c
	$(CC) /Fo$(OBJ_D)\ssl_stat.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_stat.c

$(OBJ_D)\ssl_asn1.obj: $(SRC_D)\ssl\ssl_asn1.c
	$(CC) /Fo$(OBJ_D)\ssl_asn1.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_asn1.c

$(OBJ_D)\ssl_txt.obj: $(SRC_D)\ssl\ssl_txt.c
	$(CC) /Fo$(OBJ_D)\ssl_txt.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_txt.c

$(OBJ_D)\ssl_rsa.obj: $(SRC_D)\ssl\ssl_rsa.c
	$(CC) /Fo$(OBJ_D)\ssl_rsa.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_rsa.c

$(OBJ_D)\ssl_null.obj: $(SRC_D)\ssl\ssl_null.c
	$(CC) /Fo$(OBJ_D)\ssl_null.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_null.c

$(OBJ_D)\ssl_des.obj: $(SRC_D)\ssl\ssl_des.c
	$(CC) /Fo$(OBJ_D)\ssl_des.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_des.c

$(OBJ_D)\ssl_idea.obj: $(SRC_D)\ssl\ssl_idea.c
	$(CC) /Fo$(OBJ_D)\ssl_idea.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_idea.c

$(OBJ_D)\ssl_rc4.obj: $(SRC_D)\ssl\ssl_rc4.c
	$(CC) /Fo$(OBJ_D)\ssl_rc4.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_rc4.c

$(OBJ_D)\ssl_rc2.obj: $(SRC_D)\ssl\ssl_rc2.c
	$(CC) /Fo$(OBJ_D)\ssl_rc2.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_rc2.c

$(OBJ_D)\bio_ssl.obj: $(SRC_D)\ssl\bio_ssl.c
	$(CC) /Fo$(OBJ_D)\bio_ssl.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\bio_ssl.c

$(OBJ_D)\ssl_md5.obj: $(SRC_D)\ssl\ssl_md5.c
	$(CC) /Fo$(OBJ_D)\ssl_md5.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_md5.c

$(OBJ_D)\ssl_sha.obj: $(SRC_D)\ssl\ssl_sha.c
	$(CC) /Fo$(OBJ_D)\ssl_sha.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_sha.c

$(OBJ_D)\ssl_err.obj: $(SRC_D)\ssl\ssl_err.c
	$(CC) /Fo$(OBJ_D)\ssl_err.obj $(LIB_CFLAGS) -c $(SRC_D)\ssl\ssl_err.c

$(OBJ_D)\rsaref.obj: $(SRC_D)\rsaref\rsaref.c
	$(CC) /Fo$(OBJ_D)\rsaref.obj $(LIB_CFLAGS) -c $(SRC_D)\rsaref\rsaref.c

$(OBJ_D)\rsar_err.obj: $(SRC_D)\rsaref\rsar_err.c
	$(CC) /Fo$(OBJ_D)\rsar_err.obj $(LIB_CFLAGS) -c $(SRC_D)\rsaref\rsar_err.c

$(TEST_D)\md2test.exe: $(OBJ_D)\md2test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\md2test.obj
  $(TEST_D)\md2test.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\md5test.exe: $(OBJ_D)\md5test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\md5test.obj
  $(TEST_D)\md5test.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\shatest.exe: $(OBJ_D)\shatest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\shatest.obj
  $(TEST_D)\shatest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\sha1test.exe: $(OBJ_D)\sha1test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\sha1test.obj
  $(TEST_D)\sha1test.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\destest.exe: $(OBJ_D)\destest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\destest.obj
  $(TEST_D)\destest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\rc4test.exe: $(OBJ_D)\rc4test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\rc4test.obj
  $(TEST_D)\rc4test.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\rc2test.exe: $(OBJ_D)\rc2test.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\rc2test.obj
  $(TEST_D)\rc2test.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\ideatest.exe: $(OBJ_D)\ideatest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\ideatest.obj
  $(TEST_D)\ideatest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\bntest.exe: $(OBJ_D)\bntest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\bntest.obj
  $(TEST_D)\bntest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\dhtest.exe: $(OBJ_D)\dhtest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\dhtest.obj
  $(TEST_D)\dhtest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\randtest.exe: $(OBJ_D)\randtest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\randtest.obj
  $(TEST_D)\randtest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(TEST_D)\ssltest.exe: $(OBJ_D)\ssltest.obj $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) $(OBJ_D)\ssltest.obj
  $(TEST_D)\ssltest.exe

  $(L_LIBS) $(EX_LIBS)

<<

$(O_SSL): $(SSLOBJ)
	$(RM) $(O_SSL)
	$(MKLIB) @<<
$(O_SSL)
y
+$(OBJ_D)\bio_ssl.obj &
+$(OBJ_D)\ssl_asn1.obj &
+$(OBJ_D)\ssl_auth.obj &
+$(OBJ_D)\ssl_cert.obj &
+$(OBJ_D)\ssl_clnt.obj &
+$(OBJ_D)\ssl_des.obj &
+$(OBJ_D)\ssl_err.obj &
+$(OBJ_D)\ssl_err2.obj &
+$(OBJ_D)\ssl_idea.obj &
+$(OBJ_D)\ssl_lib.obj &
+$(OBJ_D)\ssl_md5.obj &
+$(OBJ_D)\ssl_null.obj &
+$(OBJ_D)\ssl_pkt.obj &
+$(OBJ_D)\ssl_rc2.obj &
+$(OBJ_D)\ssl_rc4.obj &
+$(OBJ_D)\ssl_rsa.obj &
+$(OBJ_D)\ssl_sess.obj &
+$(OBJ_D)\ssl_sha.obj &
+$(OBJ_D)\ssl_srvr.obj &
+$(OBJ_D)\ssl_stat.obj &
+$(OBJ_D)\ssl_trc.obj &
+$(OBJ_D)\ssl_txt.obj &


<<

$(O_RSAGLUE): $(RSAGLUEOBJ)
	$(RM) $(O_RSAGLUE)
	$(MKLIB) @<<
$(O_RSAGLUE)
y
+$(OBJ_D)\rsar_err.obj &
+$(OBJ_D)\rsaref.obj &


<<

$(O_CRYPTO): $(CRYPTOOBJ)
	$(RM) $(O_CRYPTO)
	$(MKLIB) @<<
$(O_CRYPTO)
y
+$(BN_MULW_OBJ) &
+$(OBJ_D)\a_bitstr.obj &
+$(OBJ_D)\a_bool.obj &
+$(OBJ_D)\a_d2i_fp.obj &
+$(OBJ_D)\a_dup.obj &
+$(OBJ_D)\a_hdr.obj &
+$(OBJ_D)\a_i2d_fp.obj &
+$(OBJ_D)\a_int.obj &
+$(OBJ_D)\a_object.obj &
+$(OBJ_D)\a_octet.obj &
+$(OBJ_D)\a_print.obj &
+$(OBJ_D)\a_set.obj &
+$(OBJ_D)\a_sign.obj &
+$(OBJ_D)\a_type.obj &
+$(OBJ_D)\a_utctm.obj &
+$(OBJ_D)\a_verify.obj &
+$(OBJ_D)\asn1_err.obj &
+$(OBJ_D)\asn1_lib.obj &
+$(OBJ_D)\asn1_par.obj &
+$(OBJ_D)\bf_buff.obj &
+$(OBJ_D)\bio_cb.obj &
+$(OBJ_D)\bio_lib.obj &
+$(OBJ_D)\bio_md.obj &
+$(OBJ_D)\bn_add.obj &
+$(OBJ_D)\bn_div.obj &
+$(OBJ_D)\bn_err.obj &
+$(OBJ_D)\bn_exp.obj &
+$(OBJ_D)\bn_gcd.obj &
+$(OBJ_D)\bn_lib.obj &
+$(OBJ_D)\bn_mod.obj &
+$(OBJ_D)\bn_mont.obj &
+$(OBJ_D)\bn_mul.obj &
+$(OBJ_D)\bn_prime.obj &
+$(OBJ_D)\bn_print.obj &
+$(OBJ_D)\bn_rand.obj &
+$(OBJ_D)\bn_recp.obj &
+$(OBJ_D)\bn_shift.obj &
+$(OBJ_D)\bn_sqr.obj &
+$(OBJ_D)\bn_sub.obj &
+$(OBJ_D)\bn_word.obj &
+$(OBJ_D)\bss_fd.obj &
+$(OBJ_D)\bss_file.obj &
+$(OBJ_D)\bss_mem.obj &
+$(OBJ_D)\bss_null.obj &
+$(OBJ_D)\bss_sock.obj &
+$(OBJ_D)\buf_err.obj &
+$(OBJ_D)\buffer.obj &
+$(OBJ_D)\by_dir.obj &
+$(OBJ_D)\by_file.obj &
+$(OBJ_D)\cbc3_enc.obj &
+$(OBJ_D)\cbc_cksm.obj &
+$(OBJ_D)\cbc_enc.obj &
+$(OBJ_D)\cfb64ede.obj &
+$(OBJ_D)\cfb64enc.obj &
+$(OBJ_D)\cfb_enc.obj &
+$(OBJ_D)\conf.obj &
+$(OBJ_D)\conf_err.obj &
+$(OBJ_D)\cryptlib.obj &
+$(OBJ_D)\d2i_dh.obj &
+$(OBJ_D)\d2i_pr.obj &
+$(OBJ_D)\d2i_pu.obj &
+$(OBJ_D)\d2i_r_pr.obj &
+$(OBJ_D)\d2i_r_pu.obj &
+$(OBJ_D)\d2i_s_pr.obj &
+$(OBJ_D)\d2i_s_pu.obj &
+$(OBJ_D)\dh_check.obj &
+$(OBJ_D)\dh_err.obj &
+$(OBJ_D)\dh_gen.obj &
+$(OBJ_D)\dh_key.obj &
+$(OBJ_D)\dh_lib.obj &
+$(OBJ_D)\digest.obj &
+$(OBJ_D)\dsa_err.obj &
+$(OBJ_D)\dsa_lib.obj &
+$(OBJ_D)\dsa_sign.obj &
+$(OBJ_D)\dsa_vrf.obj &
+$(OBJ_D)\e_cbc_3d.obj &
+$(OBJ_D)\e_cbc_d.obj &
+$(OBJ_D)\e_cbc_i.obj &
+$(OBJ_D)\e_cbc_r2.obj &
+$(OBJ_D)\e_cfb_3d.obj &
+$(OBJ_D)\e_cfb_d.obj &
+$(OBJ_D)\e_cfb_i.obj &
+$(OBJ_D)\e_cfb_r2.obj &
+$(OBJ_D)\e_ecb_3d.obj &
+$(OBJ_D)\e_ecb_d.obj &
+$(OBJ_D)\e_ecb_i.obj &
+$(OBJ_D)\e_ecb_r2.obj &
+$(OBJ_D)\e_names.obj &
+$(OBJ_D)\e_ofb_3d.obj &
+$(OBJ_D)\e_ofb_d.obj &
+$(OBJ_D)\e_ofb_i.obj &
+$(OBJ_D)\e_ofb_r2.obj &
+$(OBJ_D)\e_rc4.obj &
+$(OBJ_D)\e_xcbc_d.obj &
+$(OBJ_D)\ecb3_enc.obj &
+$(OBJ_D)\ecb_enc.obj &
+$(OBJ_D)\ede_enc.obj &
+$(OBJ_D)\enc_read.obj &
+$(OBJ_D)\enc_writ.obj &
+$(OBJ_D)\encode.obj &
+$(OBJ_D)\err.obj &
+$(OBJ_D)\err_all.obj &
+$(OBJ_D)\evp_enc.obj &
+$(OBJ_D)\evp_err.obj &
+$(OBJ_D)\evp_key.obj &
+$(OBJ_D)\f_int.obj &
+$(OBJ_D)\fcrypt.obj &
+$(OBJ_D)\i2d_dh.obj &
+$(OBJ_D)\i2d_pr.obj &
+$(OBJ_D)\i2d_pu.obj &
+$(OBJ_D)\i2d_r_pr.obj &
+$(OBJ_D)\i2d_r_pu.obj &
+$(OBJ_D)\i_cbc.obj &
+$(OBJ_D)\i_cfb64.obj &
+$(OBJ_D)\i_ecb.obj &
+$(OBJ_D)\i_ofb64.obj &
+$(OBJ_D)\i_skey.obj &
+$(OBJ_D)\lh_stats.obj &
+$(OBJ_D)\lhash.obj &
+$(OBJ_D)\m_dss.obj &
+$(OBJ_D)\m_dss1.obj &
+$(OBJ_D)\m_md2.obj &
+$(OBJ_D)\m_md5.obj &
+$(OBJ_D)\m_names.obj &
+$(OBJ_D)\m_sha.obj &
+$(OBJ_D)\m_sha1.obj &
+$(OBJ_D)\md2_dgst.obj &
+$(OBJ_D)\md2_one.obj &
+$(OBJ_D)\md5_dgst.obj &
+$(OBJ_D)\md5_one.obj &
+$(OBJ_D)\md5_rand.obj &
+$(OBJ_D)\meth_err.obj &
+$(OBJ_D)\meth_lib.obj &
+$(OBJ_D)\n_pkey.obj &
+$(OBJ_D)\ncbc_enc.obj &
+$(OBJ_D)\obj_dat.obj &
+$(OBJ_D)\obj_err.obj &
+$(OBJ_D)\obj_lib.obj &
+$(OBJ_D)\ofb64ede.obj &
+$(OBJ_D)\ofb64enc.obj &
+$(OBJ_D)\ofb_enc.obj &
+$(OBJ_D)\p7_dgst.obj &
+$(OBJ_D)\p7_enc.obj &
+$(OBJ_D)\p7_enc_c.obj &
+$(OBJ_D)\p7_evp.obj &
+$(OBJ_D)\p7_i_s.obj &
+$(OBJ_D)\p7_lib.obj &
+$(OBJ_D)\p7_recip.obj &
+$(OBJ_D)\p7_s_e.obj &
+$(OBJ_D)\p7_signd.obj &
+$(OBJ_D)\p7_signi.obj &
+$(OBJ_D)\p_lib.obj &
+$(OBJ_D)\p_open.obj &
+$(OBJ_D)\p_seal.obj &
+$(OBJ_D)\p_sign.obj &
+$(OBJ_D)\p_verify.obj &
+$(OBJ_D)\pcbc_enc.obj &
+$(OBJ_D)\pem_err.obj &
+$(OBJ_D)\pem_info.obj &
+$(OBJ_D)\pem_lib.obj &
+$(OBJ_D)\pem_seal.obj &
+$(OBJ_D)\pem_sign.obj &
+$(OBJ_D)\qud_cksm.obj &
+$(OBJ_D)\rand_key.obj &
+$(OBJ_D)\randfile.obj &
+$(OBJ_D)\rc2_cbc.obj &
+$(OBJ_D)\rc2_ecb.obj &
+$(OBJ_D)\rc2_skey.obj &
+$(OBJ_D)\rc2cfb64.obj &
+$(OBJ_D)\rc2ofb64.obj &
+$(OBJ_D)\rc4_enc.obj &
+$(OBJ_D)\read_pwd.obj &
+$(OBJ_D)\rpc_enc.obj &
+$(OBJ_D)\rsa_enc.obj &
+$(OBJ_D)\rsa_err.obj &
+$(OBJ_D)\rsa_gen.obj &
+$(OBJ_D)\rsa_lib.obj &
+$(OBJ_D)\rsa_sign.obj &
+$(OBJ_D)\set_key.obj &
+$(OBJ_D)\sha1_one.obj &
+$(OBJ_D)\sha1dgst.obj &
+$(OBJ_D)\sha_dgst.obj &
+$(OBJ_D)\sha_one.obj &
+$(OBJ_D)\stack.obj &
+$(OBJ_D)\str2key.obj &
+$(OBJ_D)\supp.obj &
+$(OBJ_D)\t_pkey.obj &
+$(OBJ_D)\t_req.obj &
+$(OBJ_D)\t_x509.obj &
+$(OBJ_D)\txt_db.obj &
+$(OBJ_D)\x509_ath.obj &
+$(OBJ_D)\x509_cmp.obj &
+$(OBJ_D)\x509_crt.obj &
+$(OBJ_D)\x509_def.obj &
+$(OBJ_D)\x509_err.obj &
+$(OBJ_D)\x509_obj.obj &
+$(OBJ_D)\x509_r2x.obj &
+$(OBJ_D)\x509_req.obj &
+$(OBJ_D)\x509_vrf.obj &
+$(OBJ_D)\x509meth.obj &
+$(OBJ_D)\x_algor.obj &
+$(OBJ_D)\x_attrib.obj &
+$(OBJ_D)\x_cinf.obj &
+$(OBJ_D)\x_crl.obj &
+$(OBJ_D)\x_exten.obj &
+$(OBJ_D)\x_info.obj &
+$(OBJ_D)\x_name.obj &
+$(OBJ_D)\x_pkey.obj &
+$(OBJ_D)\x_pubkey.obj &
+$(OBJ_D)\x_req.obj &
+$(OBJ_D)\x_sig.obj &
+$(OBJ_D)\x_spki.obj &
+$(OBJ_D)\x_val.obj &
+$(OBJ_D)\x_x509.obj &
+$(OBJ_D)\xcbc_enc.obj &


<<

$(BIN_D)\$(E_EXE).exe: $(E_OBJ) $(LIBS_DEP)
  $(LINK) $(LFLAGS) @<<
  $(APP_EX_OBJ) +
  $(OBJ_D)\apps.obj +
  $(OBJ_D)\asn1pars.obj +
  $(OBJ_D)\ca.obj +
  $(OBJ_D)\crl.obj +
  $(OBJ_D)\crl2p7.obj +
  $(OBJ_D)\dgst.obj +
  $(OBJ_D)\dh.obj +
  $(OBJ_D)\enc.obj +
  $(OBJ_D)\errstr.obj +
  $(OBJ_D)\gendh.obj +
  $(OBJ_D)\genrsa.obj +
  $(OBJ_D)\hashdir.obj +
  $(OBJ_D)\pkcs7.obj +
  $(OBJ_D)\req.obj +
  $(OBJ_D)\rsa.obj +
  $(OBJ_D)\sess_id.obj +
  $(OBJ_D)\speed.obj +
  $(OBJ_D)\ssleay.obj +
  $(OBJ_D)\verify.obj +
  $(OBJ_D)\version.obj +
  $(OBJ_D)\x509.obj +

  $(BIN_D)\$(E_EXE).exe

  $(L_LIBS) $(EX_LIBS)

<<

