/* crypto/dsa/dsa.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */
/*
 * The DSS routines are based on patches supplied by
 * Steven Schoch <schoch@sheba.arc.nasa.gov>.  He basically did the
 * work and I have just tweaked them a little to fit into my
 * stylistic vision for SSLeay :-) */

#ifndef HEADER_DSA_H
#define HEADER_DSA_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "bn.h"

typedef struct dsa_st
	{
	/* This first variable is used to pick up errors where
	 * a DSA is passed instead of of a EVP_PKEY */
	int pad;
	int version;
	BIGNUM *x;
	BIGNUM *y;
	BIGNUM *p;
	BIGNUM *q;	/* == 20 */
	BIGNUM *g;
/*	BIGNUM *dmp1;
	BIGNUM *dmq1;
	BIGNUM *iqmp;*/
	int references;
	} DSA;

#ifndef NOPROTO
DSA *	DSA_new(void);
int	DSA_size(DSA *);
	/* DSA *	DSA_generate_key(int bits, void (*callback)()); */
	/* next 4 return -1 on error */
int	DSA_sign(int type,unsigned char *dgst,int dlen,
		unsigned char *sig, unsigned int *siglen, DSA *dsa);
int	DSA_verify(int type,unsigned char *dgst,int dgst_len,
		unsigned char *sigbuf, int siglen, DSA *dsa);
void	DSA_free (DSA *r);

void	ERR_load_DSA_strings(void );

DSA *	d2i_DSAPublicKey(DSA **a, unsigned char **pp, long length);
DSA *	d2i_DSAPrivateKey(DSA **a, unsigned char **pp, long length);
/* int	i2d_DSAPublicKey(DSA *a, unsigned char **pp); */
/* int 	i2d_DSAPrivateKey(DSA *a, unsigned char **pp); */

#ifdef HEADER_BUFFER_H
int DSA_print(BIO *bp, DSA *x, int off);
#else
int DSA_print(char *bp, DSA *x, int off);
#endif

#else

DSA *	DSA_new();
int	DSA_size();
	/* DSA *	DSA_generate_key(); */
	/* next 4 return -1 on error */
int	DSA_sign();
int	DSA_verify();
void	DSA_free();

void	ERR_load_DSA_strings();

DSA *	d2i_DSAPublicKey();
DSA *	d2i_DSAPrivateKey();
	/* int	i2d_DSAPublicKey(); */
	/* int 	i2d_DSAPrivateKey(); */
int	DSA_print();

#endif

/* BEGIN ERROR CODES */
/* Error codes for the DSA functions. */

/* Function codes. */
#define DSA_F_DSA_NEW					 100
#define DSA_F_DSA_PRINT					 101
#define DSA_F_DSA_SIGN					 102
#define DSA_F_DSA_VERIFY				 103

/* Reason codes. */
#define DSA_R_DATA_TO_LARGE_FOR_KEY_SIZE		 100

#ifdef  __cplusplus
}
#endif
#endif

