#!/usr/local/bin/perl
#
# A bit of an evil hack but it post processes the file ../MINFO which
# is generated by `make files` in the top directory.
# This script outputs one mega makefile that has no shell stuff or any
# funny stuff
#


$infile="MINFO";

%ops=(
	"VC-NT",   "Microsoft Visual C++ 4.[01] - Windows NT 3.51",
	"VC-W31-16",  "Microsoft Visual C++ 1.52 - Windows 3.1 - 286",
	"VC-W31-32",  "Microsoft Visual C++ 1.52 - Windows 3.1 - 386+",
	"VC-MSDOS","Microsoft Visual C++ 1.52 - MSDOS",
	"BC-NT",   "Borland C++ 4.5 - Windows NT  - PROBABLY NOT WORKING",
	"BC-W31",  "Borland C++ 4.5 - Windows 3.1 - PROBABLY NOT WORKING",
	"FreeBSD","FreeBSD distribution",
	"default","cc under unix",
	);

$type="";
foreach (@ARGV)
	{
	if (/^no-rc$/)		{ $no_rc2=$no_rc4=1; }
	elsif (/^no-rc2$/)	{ $no_rc2=1; }
	elsif (/^no-rc4$/)	{ $no_rc4=1; }
	elsif (/^no-idea$/)	{ $no_idea=1; }
	elsif (/^no-des$/)	{ $no_des=1; }
	elsif (/^no-md$/)	{ $no_md2=$no_md5=1; }
	elsif (/^no-md2$/)  	{ $no_md2=1; }
	elsif (/^no-md5$/)	{ $no_md5=1; }
	elsif (/^no-sock$/)	{ $no_sock=1; }
	elsif (/^no-asm$/)	{ $no_asm=1; }
	elsif (/^rsaref$/)	{ $rsaref=1; }
	elsif (/^gcc$/)		{ $gcc=1; }
	elsif (/^debug$/)	{ $debug=1; }
	elsif (/^shlib$/)	{ $shlib=1; }
	elsif (/^dll$/)		{ $shlib=1; }
	elsif (/^([^=]*)=(.*)$/){ $VARS{$1}=$2; }
	elsif (/^-[lL].*$/)	{ $l_flags.="$_ "; }
	elsif (/^-.*$/)		{ $c_flags.="$_ "; }
	else
		{
		if (!defined($ops{$_}))
			{
			print STDERR "unknown option - $_\n";
			print STDERR "usage: perl mk1mf.pl [system] [options]\n";
			print STDERR "\nwhere [system] can be one of the following\n";
			foreach $i (sort keys %ops)
				{ printf STDERR "\t%-10s\t%s\n",$i,$ops{$i}; }
			print STDERR "and [options] can be one of\n";
			print STDERR "\tno-rc no-rc2 no-rc4 no-idea no-des no-md no-md2 no-md5\n";
			print STDERR "\tno-sock no socket code.\n";
			print STDERR "\tno-asm  no assember code, just use the C files\n";
			print STDERR "\tdll     build shared libraries\n";
			print STDERR "\trsaref  build to require RSAref\n";
			print STDERR "\tgcc     build using gcc\n";
			print STDERR "TMP=tmpdir OUT=outdir SRC=srcdir\n";
			print STDERR "-Lex_lib_path -lex_lib - extra library flags\n";
			print STDERR "-ex_cc_flags - extra 'cc' flags, added for MS, replace for unix\n";
			exit(1);
			}
		$type=$_;
		}
	}

$cc=(defined($VARS{'CC'}))?$VARS{'CC'}:'cc';
$src_dir=(defined($VARS{'SRC'}))?$VARS{'SRC'}:'.';
$out_dir=(defined($VARS{'OUT'}))?$VARS{'OUT'}:'out';
$tmp_dir=(defined($VARS{'TMP'}))?$VARS{'TMP'}:'tmp';

$ssl="ssl";
$crypto="crypto";
$RSAglue="RSAglue";

push(@INC,"util/pl","pl");
if ($type eq "VC-MSDOS")
	{
	$asmbits=16;
	$msdos=1;
	require 'VC-16.pl';
	}
elsif ($type eq "VC-W31-16")
	{
	$asmbits=16;
	$msdos=1; $win16=1;
	require 'VC-16.pl';
	}
elsif ($type eq "VC-W31-32")
	{
	$asmbits=32;
	$msdos=1; $win16=1;
	require 'VC-16.pl';
	}
elsif ($type eq "VC-NT")
	{
	require 'VC-32.pl';
	}
elsif ($type eq "BC-NT")
	{
	$bc=1;
	require 'BC-32.pl';
	}
elsif ($type eq "BC-W31")
	{
	$bc=1;
	$msdos=1; $w16=1;
	require 'BC-16.pl';
	}
elsif ($type eq "BC-Q16")
	{
	$msdos=1; $w16=1; $shlib=0; $qw=1;
	require 'BC-16.pl';
	}
elsif ($type eq "FreeBSD")
	{
	$no_md2=1; $no_md5=1; $no_des=1;

	require 'unix.pl';
	$cflags='-DTERMIO -D_ASNI_SOURCE -O2 -fomit-frame-pointer';
	$ex_libs="-ldes -lmd";
	}
else
	{
	require "unix.pl";

	$unix=1;
	if ($gcc)
		{
		$cc="gcc";
		$cflags='-O3 -fomit-frame-pointer';
		}
	$cflags.=' -DTERMIO';
	}

$cflags.=" -DNO_IDEA" if $no_idea;
$cflags.=" -DNO_RC2"  if $no_rc2;
$cflags.=" -DNO_RC4"  if $no_rc4;
$cflags.=" -DNO_MD2"  if $no_md2;
$cflags.=" -DNO_MD5"  if $no_md5;
$cflags.=" -DNO_DES"  if $no_des;
$cflags.=" -DNO_SOCK" if $no_sock;
$cflags.=" -DRSAref"  if $rsaref ne "";

if ($unix)
	{ $cflags="$c_flags" if ($c_flags ne ""); }
else	{ $cflags="$c_flags$cflags" if ($c_flags ne ""); }

$ex_libs="$l_flags$ex_libs" if ($l_flags ne "");

if ($msdos)
	{
	$banner ="\t\@echo Make sure you have run 'perl Configure $type' in the\n";
	$banner.="\t\@echo top level directory, if you don't have perl, you will\n";
	$banner.="\t\@echo need to probably edit crypto/bn/bn.h, check the\n";
	$banner.="\t\@echo documentation for details.\n";
	}

$defs= <<"EOF";
# This makefile has been automatically generated from the SSLeay distribution.
# This single makefile will build the complete SSLeay distribution and
# by default leave the 'intertesting' output files in .${o}out and the stuff
# that needs deleting in .${o}tmp.
# The file was generated by running 'make makefile.one', which
# does a 'make files', which writes all the environment variables from all
# the makefiles to the file call MINFO.  This file is used by
# util${o}mk1mf.pl to generate makefile.one.
# The 'makefile per directory' system suites me when developing this
# library and also so I can 'distribute' indervidual library sections.
# The one monster makefile better suits building in non-unix
# environments.

# Set your compiler options
CC=${cc}
CFLAG=$cflags
APP_CFLAG=$app_cflag
LIB_CFLAG=$lib_cflag
APP_EX_OBJ=$app_ex_obj
SHLIB_EX_OBJ=$shlib_ex_obj
EX_LIBS=$ex_libs

# The SSLeay directory
SRC_D=$src_dir

LINK=$link
LFLAGS=$lflags

BN_MULW_OBJ=$bn_mulw_obj
BN_MULW_SRC=$bn_mulw_src

# The output directory for everything intersting
OUT_D=$out_dir
# The output directory for all the temporary muck
TMP_D=$tmp_dir

CP=$cp
RM=$rm
RANLIB=\$(SRC_D)$o$ranlib
MKDIR=mkdir
MKLIB=$mklib
MLFLAGS=$mlflags
ASM=$asm

######################################################
# You should not need to touch anything below this point
######################################################

E_EXE=ssleay
SSL=$ssl
CRYPTO=$crypto
RSAGLUE=$RSAglue

O_SSL=     \$(LIB_D)$o$plib\$(SSL)$shlibp
O_CRYPTO=  \$(LIB_D)$o$plib\$(CRYPTO)$shlibp
O_RSAGLUE= \$(LIB_D)$o$plib\$(RSAGLUE)$libp
L_SSL=     \$(LIB_D)$o$plib\$(SSL)$libp
L_CRYPTO=  \$(LIB_D)$o$plib\$(CRYPTO)$libp

L_LIBS= \$(L_SSL) \$(L_CRYPTO)
#L_LIBS= \$(O_SSL) \$(O_RSAGLUE) -lrsaref \$(O_CRYPTO)

# BIN_D  - Binary output directory
# TEST_D - Binary test file output directory
# LIB_D  - library output directory
# INC_D  - include directory
BIN_D=\$(OUT_D)
TEST_D=\$(OUT_D)
LIB_D=\$(OUT_D)
INC_D=\$(OUT_D)

# INCL_D - local library directory
# OBJ_D  - temp object file directory
OBJ_D=\$(TMP_D)
INCL_D=\$(TMP_D)

######################################################
# Don't touch anything below this point
######################################################

INC=-DFLAT_INC -I\$(INC_D) -I\$(INCL_D)
APP_CFLAGS=\$(INC) \$(CFLAG) \$(APP_CFLAG)
LIB_CFLAGS=\$(INC) \$(CFLAG) \$(LIB_CFLAG)
LIBS_DEP=\$(O_CRYPTO) \$(O_RSAGLUE) \$(O_SSL)

#############################################
EOF

$rules=<<"EOF";
all: banner \$(OUT_D) \$(TMP_D) headers lib exe

banner:
$banner

\$(OUT_D):
	mkdir \$(OUT_D)

\$(TMP_D):
	mkdir \$(TMP_D)

headers: \$(HEADER) \$(EXHEADER)

lib: \$(LIBS_DEP)

exe: \$(T_EXE) \$(BIN_D)$o\$(E_EXE)$exep

clean:
	\$(RM) \$(TMP_D)$o*.*

vclean:
	\$(RM) \$(TMP_D)$o*.*
	\$(RM) \$(OUT_D)$o*.*

EOF

#############################################
# We parse in input file and 'store' info for later printing.
open(IN,"<$infile") || die "unable to open $infile:$!\n";
$_=<IN>;
for (;;)
	{
	chop;

	($key,$val)=/^([^=]+)=(.*)/;
	if ($key eq "RELATIVE_DIRECTORY")
		{
		if ($lib ne "")
			{
			$uc=$lib;
			$uc =~ s/^lib(.*)\.a/$1/;
			$uc =~ tr/a-z/A-Z/;
			$lib_nam{$uc}=$uc;
			$lib_obj{$uc}.=$libobj." ";
			}
		last if ($val eq "FINISHED");
		$lib="";
		$libobj="";
		$dir=$val;
		}

	if ($key eq "TEST")
		{ $test.=&var_add($dir,$val); }

	if (($key eq "PROGS") || ($key eq "E_OBJ"))
		{ $e_exe.=&var_add($dir,$val); }

	if ($key eq "LIB")
		{
		$lib=$val;
		$lib =~ s/^.*\/([^\/]+)$/$1/;
		}

	if ($key eq "EXHEADER")
		{ $exheader.=&var_add($dir,$val); }

	if ($key eq "HEADER")
		{ $header.=&var_add($dir,$val); }

	if ($key eq "LIBOBJ")
		{ $libobj=&var_add($dir,$val); }

	if (!($_=<IN>))
		{ $_="RELATIVE_DIRECTORY=FINISHED\n"; }
	}
close(IN);

# Strip of trailing ' '
foreach (keys %lib_obj) { $lib_obj{$_}=&clean_up_ws($lib_obj{$_}); }
$test=&clean_up_ws($test);
$e_exe=&clean_up_ws($e_exe);
$exheader=&clean_up_ws($exheader);
$header=&clean_up_ws($header);

# First we strip the exheaders from the headers list
foreach (split(/\s+/,$exheader)){ $h{$_}=1; }
foreach (split(/\s+/,$header))	{ $h.=$_." " unless $h{$_}; }
chop($h); $header=$h;

$defs.=&do_defs("HEADER",$header,"\$(INCL_D)",".h");
$rules.=&do_copy_rule("\$(INCL_D)",$header,".h");

$defs.=&do_defs("EXHEADER",$exheader,"\$(INC_D)",".h");
$rules.=&do_copy_rule("\$(INC_D)",$exheader,".h");

$defs.=&do_defs("T_OBJ",$test,"\$(OBJ_D)",$obj);
$rules.=&do_compile_rule("\$(OBJ_D)",$test,"\$(APP_CFLAGS)");

$defs.=&do_defs("E_OBJ",$e_exe,"\$(OBJ_D)",$obj);
$rules.=&do_compile_rule("\$(OBJ_D)",$e_exe,'-DMONOLITH $(APP_CFLAGS)');

foreach (values %lib_nam)
	{
	$lib_obj=$lib_obj{$_};
	if (($bn_mulw_obj ne "") && ($_ eq "CRYPTO"))
		{
		$lib_obj =~ s/\S*bn_mulw\S*/\$(BN_MULW_OBJ)/;
		$rules.=&do_asm_rule("\$(BN_MULW_OBJ)","\$(BN_MULW_SRC)")
		}
	$defs.=&do_defs(${_}."OBJ",$lib_obj,"\$(OBJ_D)",$obj);
	$rules.=&do_compile_rule("\$(OBJ_D)",$lib_obj{$_},"\$(LIB_CFLAGS)");
	}

$defs.=&do_defs("T_EXE",$test,"\$(TEST_D)",$exep);
foreach (split(/\s+/,$test))
	{
	$t=&bname($_);
	$tt="\$(OBJ_D)${o}$t${obj}";
	$rules.=&do_link_rule("\$(TEST_D)$o$t$exep",$tt,"\$(LIBS_DEP)","\$(L_LIBS) \$(EX_LIBS)");
	}

$rules.=&do_lib_rule("\$(O_SSL)","ssl",$shlib);
$rules.=&do_lib_rule("\$(O_RSAGLUE)","rsaglue",0);
$rules.=&do_lib_rule("\$(O_CRYPTO)","crypto",$shlib);

$rules.=&do_link_rule("\$(BIN_D)$o\$(E_EXE)$exep","\$(E_OBJ)","\$(LIBS_DEP)","\$(L_LIBS) \$(EX_LIBS)");

print $defs;
print "###################################################################\n";
print $rules;

###############################################
# strip off any trailing .[och] and append the relative directory
# also remembering to do nothing if we are in one of the dropped
# directories
sub var_add
	{
	local($dir,$val)=@_;
	local(@a,$_,$ret);

	return("") if $no_idea && $dir =~ /\/idea/;
	return("") if $no_rc2  && $dir =~ /\/rc2/;
	return("") if $no_rc4  && $dir =~ /\/rc4/;
	return("") if $no_des  && $dir =~ /\/des/;
	$val =~ s/^\s*(.*)\s*$/$1/;
	@a=split(/\s+/,$val);
	grep(s/\.[och]$//,@a);
	@a=grep(!/md2_dgst/,@a) if $no_md2;
	@a=grep(!/md5_dgst/,@a) if $no_md5;
	grep($_="$dir/$_",@a);
	@a=grep(!/(^|\/)s_/,@a) if $no_sock;
	@a=grep(!/(^|\/)bio_sock/,@a) if $no_sock;
	$ret=join(' ',@a)." ";
	return($ret);
	}

# change things so that each 'token' is only seperated by one space
sub clean_up_ws
	{
	local($w)=@_;

	$w =~ s/^\s*(.*)\s*$/$1/;
	$w =~ s/\s+/ /g;
	return($w);
	}

sub do_defs
	{
	local($var,$files,$location,$postfix)=@_;
	local($_,$ret);
	local(*OUT,$tmp,$t);

	$files =~ s/\//$o/g if $o ne '/';
	$ret="$var="; 
	$n=1;
	$Vars{$var}.="";
	foreach (split(/ /,$files))
		{
		$_=&bname($_) unless /^\$/;
		if ($n++ == 2)
			{
			$n=0;
			$ret.="\\\n\t";
			}
		if ($_ =~ /BN_MULW/)
			{ $t="$_ "; }
		else	{ $t="$location${o}$_$postfix "; }

		$Vars{$var}.="$t ";
		$ret.=$t;
		}
	chop($ret);
	$ret.="\n\n";
	return($ret);
	}

# return the name with the leading path removed
sub bname
	{
	local($ret)=@_;
	$ret =~ s/^.*[\\\/]([^\\\/]+)$/$1/;
	return($ret);
	}

# do a rule for each file that says 'copy' to new direcory on change
sub do_copy_rule
	{
	local($to,$files,$p)=@_;
	local($ret,$_,$n);
	
	$files =~ s/\//$o/g if $o ne '/';
	foreach (split(/\s+/,$files))
		{
		$n=&bname($_);
		$ret.="$to${o}$n$p: \$(SRC_D)$o$_$p\n\t\$(CP) \$(SRC_D)$o$_$p $to${o}$n$p\n\n";
		}
	return($ret);
	}

##############################################################
# do a rule for each file that says 'compile' to new direcory
# compile the files in '$files' into $to
sub do_compile_rule
	{
	local($to,$files,$ex)=@_;
	local($ret,$_,$n);
	
	$files =~ s/\//$o/g if $o ne '/';
	foreach (split(/\s+/,$files))
		{
		$n=&bname($_);
		$ret.=&cc_compile_target("$to${o}$n$obj","${_}.c",$ex)
		}
	return($ret);
	}

##############################################################
# do a rule for each file that says 'compile' to new direcory
sub cc_compile_target
	{
	local($target,$source,$ex_flags)=@_;
	local($ret);
	
	$ex_flags.=' -DCFLAGS="\"$(CC) $(CFLAG)\""' if ($source =~ /cryptlib/);
	$target =~ s/\//$o/g if $o ne "/";
	$source =~ s/\//$o/g if $o ne "/";
	$ret ="$target: \$(SRC_D)$o$source\n\t";
	$ret.="\$(CC) ${ofile}$target $ex_flags -c \$(SRC_D)$o$source\n\n";
	return($ret);
	}

##############################################################
sub do_asm_rule
	{
	local($target,$src)=@_;

	$target =~ s/\//$o/g if $o ne "/";
	$src =~ s/\//$o/g if $o ne "/";
	$ret.="$target: $src\n";
	$ret.="\t\$(ASM) $afile$target \$(SRC_D)$o$src\n\n";
	}

sub do_shlib_rule
	{
	local($n,$def)=@_;
	local($ret,$nn);
	local($t);

	($nn=$n) =~ tr/a-z/A-Z/;
	$ret.="$n.dll: \$(${nn}OBJ)\n";
	if ($vc && $w32)
		{
		$ret.="\t\$(MKSHLIB) $efile$n.dll $def @<<\n  \$(${nn}OBJ_F)\n<<\n";
		}
	$ret.="\n";
	return($ret);
	}

