#!/usr/local/bin/perl
#
# A bit of an evil hack but it post processes the file ../MINFO which
# is generated by `make files` in the top directory.
# This script outputs one mega magefile that has no shell stuff or any
# funny make stuff
#

%ops=(	"gcc","gcc under unix",
	"VC32","Microsoft Visual C++ 4.[01] - Windows NT 3.51",
	"BC32","Borland C++ 4.5 - Windows NT 3.51",
	"default","cc under unix",
	);

if ($#ARGV >= 0)
	{
	if (!defined($ops{$ARGV[0]}))
		{
		print STDERR "usage: perl mk1mf.pl [system]\n";
		print STDERR "where [system] can be one of the following\n\n";
		foreach $i (sort keys %ops)
			{ printf STDERR "%-7s\t%s\n",$i,$ops{$i}; }
		exit(1);
		}
	}

if ($ARGV[0] eq "gcc")	{ $gcc=1; }
if ($ARGV[0] eq "VC32") { $ms=1; $vc=1; $b32=1; }
if ($ARGV[0] eq "BC32") { $ms=1; $bc=1; $b32=1; }

$cflags='-DTERMIO ';
if ($gcc)
	{
	$cc='gcc';
	$cflags.='-O3 -fomit-frame-pointer';
	}
else
	{
	$cc='cc';
	$cflags.='-O';
	}
$o='/';
$mklib='ar r';
$ranlib='util/ranlib.sh';
$obj='.o';
$plib='lib';
$libp=".a";
$exep='';
$ofile='-o ';	# Keep the space 
$efile='-o ';	# Keep the space 
$cp='/bin/cp';

if ($ms)
	{
	$ranlib='';
	$cp='copy';
	$o='\\';
	$obj='.obj';
	$plib="";
	$libp=".lib";
	$exep='.exe';
	if ($vc)
		{
		$cc='cl';
		$ofile="/Fo";
		$efile="/Fe";
		$cflags='/Ox /nologo';
		}
	elsif ($bc)
		{
		$cc=($b32)?'bcc32':'bcc';
		$ofile="-o";
		$efile="-e";
		$cflags='-O';
		}
	$cflags.=" -DWIN32" if $b32;
	$cflags.=" -DMSDOS";
	}


$defs= <<"EOF";
# This makefile has been automatically generated from the SSLeay distribution.
# This single makefile will build the complete SSLeay distribution and
# by default leave the 'intertesting' output files in .${o}out and the stuff
# that needs deleting in .${o}tmp.
# The file was generated by running 'make makefile.one', which
# does a 'make files', which writes all the environment variables from all
# the makefiles to the file call MINFO.  This file is used by
# util${o}mk1mf.pl to generate makefile.one.
# The 'makefile per directory' system suites me when developing this
# library and also so I can 'distribute' indervidual library sections.
# The one monster makefile better suits building in non-unix
# environments.

# Set your compiler options
CC=${cc}
CFLAG=$cflags

# The output directory for everything intersting
OUT=out
# The output directory for all the temporary muck
TMP=tmp

CP=$cp
RANLIB=$ranlib
TOUCH=touch
MKDIR=mkdir


######################################################
# You should not need to touch anything below this point
######################################################

E_EXE=ssleay
L_LIBS= \$(O_SSL) \$(O_CRYPTO)
#L_LIBS= \$(O_SSL) \$(O_RSAGLUE) \$(O_CRYPTO) -lrsaref

SSL=ssl
CRYPTO=crypto
RSAGLUE=RSAglue

# BIN_D  - Binary output directory
# TEST_D - Binary test file output directory
# LIB_D  - library output directory
# INC_D  - include directory
BIN_D=\$(OUT)
TEST_D=\$(OUT)
LIB_D=\$(OUT)
INC_D=\$(OUT)

# INCL_D - local library directory
# OBJ_D  - temp object file directory
OBJ_D=\$(TMP)
INCL_D=\$(TMP)

######################################################
# Don't touch anything below this point
######################################################

N_SSL=${plib}\$(SSL)$libp
N_CRYPTO=${plib}\$(CRYPTO)$libp
N_RSAGLUE=${plib}\$(RSAGLUE)$libp

O_SSL=\$(LIB_D)${o}\$(N_SSL)
O_CRYPTO=\$(LIB_D)${o}\$(N_CRYPTO)
O_RSAGLUE=\$(LIB_D)${o}\$(N_RSAGLUE)

INC=-DFLAT_INC -I\$(INC_D) -I\$(INCL_D)
CFLAGS=\$(INC) \$(CFLAG)
LIBS_DEP=\$(OBJ_D)${o}\$(CRYPTO).t \$(OBJ_D)${o}\$(RSAGLUE).t \$(OBJ_D)${o}\$(SSL).t

#############################################
EOF

$rules=<<"EOF";
all: headers lib exe

headers: \$(HEADER) \$(EXHEADER)

lib: \$(LIBS_DEP)

exe: \$(T_EXE) \$(BIN_D)${o}\$(E_EXE)$exep

EOF

#############################################
# We parse in input file and 'store' info for later printing.
$_=<STDIN>;
for (;;)
	{
	chop;

	($key,$val)=/^([^=]+)=(.*)/;
	if ($key eq "RELATIVE_DIRECTORY")
		{
		if ($lib ne "")
			{
			$uc=$lib;
			$uc =~ s/^lib(.*)\.a/$1/;
			$uc =~ tr/a-z/A-Z/;
			$lib_nam{$uc}=$uc;
			$lib_obj{$uc}.=$libobj." ";
			}
		last if ($val eq "FINISHED");
		$lib="";
		$libobj="";
		$dir=$val;
		}

	if ($key eq "TEST")
		{ $test.=&var_add($dir,$val); }

	if (($key eq "PROGS") || ($key eq "E_OBJ"))
		{ $e_exe.=&var_add($dir,$val); }

	if ($key eq "LIB")
		{
		$lib=$val;
		$lib =~ s/^.*\/([^\/]+)$/$1/;
		}

	if ($key eq "EXHEADER")
		{ $exheader.=&var_add($dir,$val); }

	if ($key eq "HEADER")
		{ $header.=&var_add($dir,$val); }

	if ($key eq "LIBOBJ")
		{ $libobj=&var_add($dir,$val); }

	if (!($_=<STDIN>))
		{ $_="RELATIVE_DIRECTORY=FINISHED\n"; }
	}

# Strip of trailing ' '
foreach (keys %lib_obj) { $lib_obj{$_}=&clean_up_ws($lib_obj{$_}); }
$test=&clean_up_ws($test);
$e_exe=&clean_up_ws($e_exe);
$exheader=&clean_up_ws($exheader);
$header=&clean_up_ws($header);

# First we strip the exheaders from the headers list
foreach (split(/\s+/,$exheader)){ $h{$_}=1; }
foreach (split(/\s+/,$header))	{ $h.=$_." " unless $h{$_}; }
chop($h); $header=$h;

$defs.=&do_defs("HEADER",$header,"\$(INCL_D)",".h");
$rules.=&do_copy_rule("\$(INCL_D)",$header,".h");

$defs.=&do_defs("EXHEADER",$exheader,"\$(INC_D)",".h");
$rules.=&do_copy_rule("\$(INC_D)",$exheader,".h");

$defs.=&do_defs("T_OBJ",$test,"\$(OBJ_D)",$obj);
$rules.=&do_compile_rule("\$(OBJ_D)",$test,".c",$obj,"");

$defs.=&do_defs("E_OBJ",$e_exe,"\$(OBJ_D)",$obj);
$rules.=&do_compile_rule("\$(OBJ_D)",$e_exe,".c",$obj,"-DMONOLITH ");

$rules.=&do_lib_rule("SSL");
$rules.=&do_lib_rule("RSAGLUE");
$rules.=&do_lib_rule("CRYPTO");

foreach (values %lib_nam)
	{
	$defs.=&do_defs(${_}."OBJ",$lib_obj{$_},"\$(OBJ_D)",$obj);
	$rules.=&do_compile_rule("\$(OBJ_D)",$lib_obj{$_},".c",$obj,"");
	}

$defs.=&do_defs("T_EXE",$test,"\$(TEST_D)",$exep);
foreach (split(/\s+/,$test))
	{
	$t=&bname($_);
	$rules.=&do_link_rule("\$(TEST_D)",$_,"\$(OBJ_D)${o}$t${obj}",$exep);
	}

$rules.=&do_link_rule("\$(BIN_D)","\$(E_EXE)","\$(E_OBJ)",$exep);

print $defs;
print "###################################################################\n";
print $rules;

###############################################
# strip off any trailing .[och] and append the relative directory
sub var_add
	{
	local($dir,$val)=@_;
	local(@a,$_,$ret);

	$val =~ s/^\s*(.*)\s*$/$1/;
	@a=split(/\s+/,$val);
	grep(s/\.[och]$//,@a);
	grep($_="$dir/$_",@a);
	$ret=join(' ',@a)." ";
	return($ret);
	}

# change things so that each 'token' is only seperated by one sparc
sub clean_up_ws
	{
	local($w)=@_;

	$w =~ s/^\s*(.*)\s*$/$1/;
	$w =~ s/\s+/ /g;
	return($w);
	}

sub do_defs
	{
	local($var,$files,$location,$postfix)=@_;
	local($_,$ret);

	$files =~ s/\//$o/g if $o ne '/';
	$ret="$var="; 
	$n=1;
	foreach (split(/ /,$files))
		{
		$_=&bname($_);
		if ($n++ == 2)
			{
			$n=0;
			$ret.="\\\n\t";
			}
		$ret.="$location${o}$_$postfix ";
		}
	chop($ret);
	$ret.="\n\n";
	return($ret);
	}

# return the name with the leading path removed
sub bname
	{
	local($ret)=@_;
	$ret =~ s/^.*[\\\/]([^\\\/]+)$/$1/;
	return($ret);
	}

# do a rule for each file that says 'copy' to new direcory on change
sub do_copy_rule
	{
	local($to,$files,$p)=@_;
	local($ret,$_,$n);
	
	$files =~ s/\//$o/g if $o ne '/';
	foreach (split(/\s+/,$files))
		{
		$n=&bname($_);
		$ret.="$to${o}$n$p: $_$p\n\t\$(CP) $_$p $to${o}$n$p\n\n";
		}
	return($ret);
	}

# do a rule for each file that says 'compile' to new direcory
sub do_compile_rule
	{
	local($to,$files,$in,$out,$ex)=@_;
	local($ret,$_,$n);
	
	$files =~ s/\//$o/g if $o ne '/';
	foreach (split(/\s+/,$files))
		{
		$n=&bname($_);
		$ret.="$to${o}$n$out: $_$in\n\t";
		$ret.="\$(CC) ${ofile}$to${o}$n$out $ex\$(CFLAGS) -c $_$in\n\n";
		}
	return($ret);
	}


#{ $rules.=&do_link_rule("\$(TEST_D)",$_,$_,$obj,"\$(EXE)"); }
# do a rule for each file that says 'compile' to new direcory
sub do_link_rule
	{
	local($to,$n,$file,$outp)=@_;
	local($ret,$_);
	
	$file =~ s/\//$o/g if $o ne '/';
	$n=&bname($n);
	$ret.="$to${o}$n$outp: $file \$(LIBS_DEP)\n\t";
	$ret.="\$(CC) \$(CFLAGS) ${efile}$to${o}$n$outp \$(LFLAGS) $file \$(L_LIBS)\n\n";
	return($ret);
	}

sub do_lib_rule
	{
	local($n)=@_;
	local($ret);

#	$ret ="\$(O_$n): \$(OBJ_D)${o}\$($n).t\n\n";
	$ret.="\$(OBJ_D)${o}\$($n).t: \$(${n}OBJ)\n";
	$ret.="\t${mklib} \$(O_$n) \$(${n}OBJ)\n";
	$ret.="\t\$(RANLIB) \$(O_$n)\n" if ($ranlib ne "");
	$ret.="\t\$(TOUCH) \$(OBJ_D)${o}\$($n).t\n\n";
	}

