/* lib/ssl/ssl.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#ifndef HEADER_SSL_H 
#define HEADER_SSL_H 

/* Protocol Version Codes */
#define SSL_CLIENT_VERSION	0x0002
#define SSL_SERVER_VERSION	0x0002

/* SSLeay version number for ASN.1 encoding of the session information */
#define SSL_SESSION_ASN1_VERSION 0x0000

/* Protocol Message Codes */
#define SSL_MT_ERROR			0
#define SSL_MT_CLIENT_HELLO		1
#define SSL_MT_CLIENT_MASTER_KEY	2
#define SSL_MT_CLIENT_FINISHED		3
#define SSL_MT_SERVER_HELLO		4
#define SSL_MT_SERVER_VERIFY		5
#define SSL_MT_SERVER_FINISHED		6
#define SSL_MT_REQUEST_CERTIFICATE	7
#define SSL_MT_CLIENT_CERTIFICATE	8

/* Error Message Codes */
#define SSL_PE_NO_CIPHER		0x0001
#define SSL_PE_NO_CERTIFICATE		0x0002
#define SSL_PE_BAD_CERTIFICATE		0x0004
#define SSL_PE_UNSUPPORTED_CERTIFICATE_TYPE 0x0006

/* Cipher Kind Values */
#define SSL_CK_NULL_WITH_MD5			0x00,0x00,0x00 /* v3 */
#define SSL_CK_RC4_128_WITH_MD5			0x01,0x00,0x80
#define SSL_CK_RC4_128_EXPORT40_WITH_MD5	0x02,0x00,0x80
#define SSL_CK_RC2_128_CBC_WITH_MD5		0x03,0x00,0x80
#define SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5	0x04,0x00,0x80
#define SSL_CK_IDEA_128_CBC_WITH_MD5		0x05,0x00,0x80
#define SSL_CK_DES_64_CBC_WITH_MD5		0x06,0x00,0x40
#define SSL_CK_DES_64_CBC_WITH_SHA		0x06,0x01,0x40 /* v3 */
#define SSL_CK_DES_192_EDE3_CBC_WITH_MD5	0x07,0x00,0xc0
#define SSL_CK_DES_192_EDE3_CBC_WITH_SHA	0x07,0x01,0xc0 /* v3 */

#define SSL_CK_DES_64_CFB64_WITH_MD5_1		0xff,0x08,0x00 /* SSLeay */
#define SSL_CK_NULL				0xff,0x08,0x10 /* SSLeay */

/* text strings for the ciphers */
#define SSL_TXT_NULL_WITH_MD5			"NULL-MD5"
#define SSL_TXT_RC4_128_WITH_MD5		"RC4-MD5"
#define SSL_TXT_RC4_128_EXPORT40_WITH_MD5	"EXP-RC4-MD5"
#define SSL_TXT_RC2_128_CBC_WITH_MD5		"RC2-CBC-MD5"
#define SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5	"EXP-RC2-CBC-MD5"
#define SSL_TXT_IDEA_128_CBC_WITH_MD5		"IDEA-CBC-MD5"
#define SSL_TXT_DES_64_CBC_WITH_MD5		"DES-CBC-MD5"
#define SSL_TXT_DES_64_CBC_WITH_SHA		"DES-CBC-SHA"
#define SSL_TXT_DES_192_EDE3_CBC_WITH_MD5	"DES-CBC3-MD5"
#define SSL_TXT_DES_192_EDE3_CBC_WITH_SHA	"DES-CBC3-SHA"

#define SSL_TXT_DES_64_CFB64_WITH_MD5_1		"DES-CFB-M1"
#define SSL_TXT_NULL				"NULL"

/* Certificate Type Codes */
#define SSL_CT_X509_CERTIFICATE			0x01

/* Authentication Type Code */
#define SSL_AT_MD5_WITH_RSA_ENCRYPTION		0x01

/* Upper/Lower Bounds */
#define SSL_MAX_MASTER_KEY_LENGTH_IN_BITS	256
#define SSL_MAX_SSL_SESSION_ID_LENGTH_IN_BYTES	16
#define SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES	64
#define SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER	32767 
#define SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER	16383 /**/

#ifndef HEADER_X509_H
#include "x509.h"
#endif

#ifndef HEADER_SSL_LOCL_H
#define  SSL_SESSION	char
#define  CERT		char
#endif

#ifdef HEADER_X509_H
#define SSL_FILETYPE_PEM	X509_FILETYPE_PEM
#define SSL_FILETYPE_ASN1	X509_FILETYPE_ASN1
#else
#define SSL_FILETYPE_PEM	1
#define SSL_FILETYPE_ASN1	2
#endif

typedef struct ssl_ctx_st
	{
	int num_cipher_list;
	char **cipher_list;

#ifdef HEADER_X509_H
	CERTIFICATE_CTX *cert;
#else
	char *cert;
#endif
#ifdef HEADER_LHASH_H
	LHASH *sessions;	/* a set of SSL_SESSION's */
#else
	char *sessions;
#endif

	long sess_connect;	/* SSL new (expensive) connection */
	long sess_connect_good;	/* SSL new (expensive) connection */
	long sess_accept;	/* SSL connection failues */
	long sess_accept_good;	/* SSL connection failues */
	long sess_miss;		/* session lookup misses  */
	long sess_timeout;	/* session reuse attempt on timeouted session */
	long sess_hit;		/* session reuse actually done */

	int references;

	/* used to do 'reverse' ssl */
	int reverse;

	/* used by client (for 'reverse' ssl) */
	char *cipher;
	unsigned int challenge_length;
	unsigned char *challenge;
	unsigned int master_key_length;
	unsigned char *master_key;
	unsigned int key_arg_length;
	unsigned char *key_arg;
	/* used by server (for 'reverse' ssl) */
	unsigned int conn_id_length;
	unsigned char *conn_id;
	} SSL_CTX;

#define SSL_CTX_sessions(ctx)		((ctx)->sessions)
/* You will need to include lhash.h to access the following #define */
#define SSL_CTX_sess_number(ctx)	((ctx)->sessions->num_items)
#define SSL_CTX_sess_connect(ctx)	((ctx)->sess_connect)
#define SSL_CTX_sess_connect_good(ctx)	((ctx)->sess_connect_good)
#define SSL_CTX_sess_accept(ctx)	((ctx)->sess_accept)
#define SSL_CTX_sess_accept_good(ctx)	((ctx)->sess_accept_good)
#define SSL_CTX_sess_hits(ctx)		((ctx)->sess_hit)
#define SSL_CTX_sess_misses(ctx)	((ctx)->sess_miss)
#define SSL_CTX_sess_timeouts(ctx)	((ctx)->sess_timeout)

#define SSL_NOTHING	1
#define SSL_WRITING	2
#define SSL_READING	3

/* These will only be used when doing non-blocking IO */
#define SSL_want(s)		((s)->rwstate)
#define SSL_want_nothing(s)	((s)->rwstate == SSL_NOTHING)
#define SSL_want_read(s)	((s)->rwstate == SSL_READING)
#define SSL_want_write(s)	((s)->rwstate == SSL_WRITING)

typedef struct ssl_st
	{
	/* There are 2 fd's even though they are normally both the
	 * same.  This is so data can be read and written to a file,
	 * don't ask, it's a special case hack */
	int rfd; /* used by SSL_read */
	int wfd; /* used by SSL_write */
	int version;	/* procol version */

	/* This holds a variable that indicates what we were doing
	 * when a 0 or -1 is returned.  This is needed for
	 * non-blocking IO so we know what request needs re-doing when
	 * in SSL_accept or SSL_sessionect */
	int rwstate;

	int state;	/* where we are */
	unsigned int state_conn_id_length;	/* tmp */
	unsigned int state_cert_type;		/* tmp */
	unsigned int state_cert_length;		/* tmp */
	unsigned int state_csl; 		/* tmp */

	unsigned int state_clear; 		/* tmp */
	unsigned int state_enc; 		/* tmp */

	unsigned char *state_ccl;		/* tmp */

	unsigned int state_cipher_spec_length;
	unsigned int state_session_id_length;

	unsigned int state_clen;
	unsigned int state_rlen;

	int rstate;	/* where we are when reading */

	unsigned char *init_buf;/* buffer used during init */
	int init_num;	/* amount read/written */
	int init_off;	/* amount read/written */

	int read_ahead;
	int escape;
	int three_byte_header;
	int send;		/* direction of packet */
	int clear_text;		/* clear text */
	int hit;		/* reusing a previous session */

	/* non-blocking io info, used to make sure the same args were passwd */
	unsigned int wnum;	/* number of bytes sent so far */
	int wpend_tot;
	char *wpend_buf;

	int wpend_off;		/* offset to data to write */
	int wpend_len;  	/* number of bytes passwd to write */
	int wpend_ret;  	/* number of bytes to return to caller */

	int rpend_off;		/* offset to read position */
	int rpend_len;		/* number of bytes to read */

	/* buffer raw data */
	int rbuf_left;
	int rbuf_offs;
	unsigned char *rbuf;
	unsigned char *wbuf;

	/* used internally by ssl_read to talk to read_n */
	unsigned char *packet;
	unsigned int packet_length;

	/* set by read_n */
	unsigned int length;
	unsigned int padding;
	unsigned int ract_data_length; /* Set when things are encrypted. */
	unsigned int wact_data_length; /* Set when things are decrypted. */
	unsigned char *ract_data;
	unsigned char *wact_data;
	unsigned char *mac_data;
	unsigned char *pad_data;

	/* crypto */
	int num_cipher_list;
	char **cipher_list;	/* char ** is malloced and the rest is
				 * on malloced block pointed to by
				 * cipher_list[0] */
	char *crypt_state;	/* cryptographic state */
	unsigned char *read_key;
	unsigned char *write_key;

	/* session info */

	CERT *cert;
	SSL_SESSION *session;

	unsigned int challenge_length;
	unsigned char *challenge;
	unsigned int conn_id_length;
	unsigned char *conn_id;
	unsigned int key_material_length;
	unsigned char *key_material;

	/* packet specs */
	/* send is true for send; false for recieve */

	unsigned char *write_ptr;	/* used to point to the start due to
					 * 2/3 byte header. */

	unsigned long read_sequence;
	unsigned long write_sequence;

	/* special stuff */
	int trust_level;	/* not used yet */
	int peer_status;	/* 0, not set, 1 in ->perr, 2 in
				 * ->session->cert->x509 */
#ifdef HEADER_X509_H
	X509 *peer;
#else
	char *peer;		/* actually a X509 * */
#endif
	int verify_mode;	/* 0 don't care about verify failure.
				 * 1 fail if verify fails */
	int (*verify_callback)(); /* fail if callback returns 0 */

	SSL_CTX *ctx;
	/* set this flag to 1 and a sleep(1) is put into all SSL_read()
	 * and SSL_write() calls, good for nbio debuging :-) */
	int debug;	
	} SSL;

/* The following are the possible values for ssl->state are are
 * used to indicate where we are upto in the SSL conection establishment.
 * The macros that follow are about the only things you should need to use
 * and even then, only when using non-blocking IO.
 * It can also be useful to work out where you were when the connection
 * failed */
/* Is the SSL_connection established? */
#define SSL_is_established(a)		((a)->state == ST_OK)

#define SSL_state(a)			((a)->state)
#define SSL_ST_INIT(a)			((a)&ST_INIT)
#define ST_INIT				0x0100
#define ST_BEFORE			0x01
#define ST_START_ENCRYPTION		(0x02|ST_INIT)
#define ST_OK				0x03

/* client */
#define ST_SEND_CLIENT_HELLO_A		(0x10|ST_INIT)
#define ST_SEND_CLIENT_HELLO_B		(0x11|ST_INIT)
#define ST_GET_SERVER_HELLO_A		(0x12|ST_INIT)
#define ST_GET_SERVER_HELLO_B		(0x13|ST_INIT)
#define ST_SEND_CLIENT_MASTER_KEY_A	(0x14|ST_INIT)
#define ST_SEND_CLIENT_MASTER_KEY_B	(0x15|ST_INIT)
#define ST_SEND_CLIENT_FINISHED_A	(0x18|ST_INIT)
#define ST_SEND_CLIENT_FINISHED_B	(0x19|ST_INIT)
#define ST_SEND_CLIENT_CERTIFICATE_A	(0x1A|ST_INIT)
#define ST_SEND_CLIENT_CERTIFICATE_B	(0x1B|ST_INIT)
#define ST_SEND_CLIENT_CERTIFICATE_C	(0x1C|ST_INIT)
#define ST_SEND_CLIENT_CERTIFICATE_D	(0x1D|ST_INIT)
#define ST_GET_SERVER_VERIFY_A		(0x1E|ST_INIT)
#define ST_GET_SERVER_VERIFY_B		(0x1F|ST_INIT)
#define ST_GET_SERVER_FINISHED_A	(0x20|ST_INIT)
#define ST_GET_SERVER_FINISHED_B	(0x21|ST_INIT)
/* server */
#define ST_GET_CLIENT_HELLO_A		(0x40|ST_INIT)
#define ST_GET_CLIENT_HELLO_B		(0x41|ST_INIT)
#define ST_SEND_SERVER_HELLO_A		(0x42|ST_INIT)
#define ST_SEND_SERVER_HELLO_B		(0x43|ST_INIT)
#define ST_GET_CLIENT_MASTER_KEY_A	(0x44|ST_INIT)
#define ST_GET_CLIENT_MASTER_KEY_B	(0x45|ST_INIT)
#define ST_SEND_SERVER_VERIFY_A		(0x46|ST_INIT)
#define ST_SEND_SERVER_VERIFY_B		(0x47|ST_INIT)
#define ST_GET_CLIENT_FINISHED_A	(0x48|ST_INIT)
#define ST_GET_CLIENT_FINISHED_B	(0x49|ST_INIT)
#define ST_SEND_SERVER_FINISHED_A	(0x4A|ST_INIT)
#define ST_SEND_SERVER_FINISHED_B	(0x4B|ST_INIT)
#define ST_SEND_REQUEST_CERTIFICATE_A	(0x4C|ST_INIT)
#define ST_SEND_REQUEST_CERTIFICATE_B	(0x4D|ST_INIT)
#define ST_SEND_REQUEST_CERTIFICATE_C	(0x4E|ST_INIT)
#define ST_SEND_REQUEST_CERTIFICATE_D	(0x4F|ST_INIT)

/* The following 2 states are kept in ssl->rstate when reads fail,
 * you should not need these */
#define ST_READ_HEADER			0x80
#define ST_READ_BODY			0x81

#define SSL_VERIFY_NONE			0x00
#define SSL_VERIFY_PEER			0x01
#define SSL_VERIFY_FAIL_IF_NO_PEER_CERT	0x02

#define SSL_RWERR_BAD_WRITE_RETRY	(-2)
#define SSL_RWERR_BAD_MAC_DECODE	(-3)
#define SSL_RWERR_INTERNAL_ERROR	(-4) /* should not get this one */


/* for backward compatablity with SSLeay 0.5.1, I would like
 * to remove this macro in the future */
#define SSL_copy_session_id(a,b) \
		SSL_set_session(a,(SSL_get_session(b))

#define SSL_set_default_verify_paths(ctx) \
		X509_set_default_verify_paths((ctx)->cert)
#define SSL_load_verify_locations(ctx,CAfile,CApath) \
		X509_load_verify_locations((ctx)->cert,(CAfile),(CApath))

#define SSL_get_session(s)	((s)->session)
#define SSL_get_SSL_CTX(s)	((s)->ctx)

/* this is for backward compatablility */
#define SSL_get_pref_cipher(s,n)	SSL_get_cipher_list(s,n);
#define SSL_set_pref_cipher(c,n)	SSL_set_cipher_list(c,n);

#ifndef NOPROTO
int	SSL_CTX_set_cipher_list(SSL_CTX *,char *str);
SSL_CTX *SSL_CTX_new(void );
void	SSL_CTX_free(SSL_CTX *);
int	SSL_accept(SSL *s);
void	SSL_clear(SSL *s);
int	SSL_connect(SSL *s);
void	SSL_debug(char *file);
void	SSL_flush_sessions(SSL_CTX *ctx,long tm);
void	SSL_free(SSL *s);
char *	SSL_get_cipher(SSL *s);
int	SSL_get_fd(SSL *s);
char *	SSL_get_cipher_list(SSL *s, int n);
char *	SSL_get_shared_ciphers(SSL *s, char *buf, int len);
int	SSL_get_read_ahead(SSL * s);
int	SSL_is_init_finished(SSL *s);
SSL *	SSL_new(SSL_CTX *);
int	SSL_pending(SSL *s);
int	SSL_read(SSL *s, char *buf, unsigned int len);
void	SSL_set_fd(SSL *s, int fd);
int	SSL_set_cipher_list(SSL *s, char *str);
void	SSL_set_read_ahead(SSL * s, int yes);
void	SSL_set_verify(SSL *s, int mode, int (*callback) ());
int	SSL_use_RSAPrivateKey(SSL *ssl, RSA *rsa);
int	SSL_use_RSAPrivateKey_ASN1(SSL *ssl, unsigned char *d, long len);
int	SSL_use_RSAPrivateKey_file(SSL *ssl, char *file, int type);
int	SSL_use_certificate(SSL *ssl, X509 *x);
int	SSL_use_certificate_ASN1(SSL *ssl, int len, unsigned char *d);
int	SSL_use_certificate_file(SSL *ssl, char *file, int type);
int	SSL_write(SSL *s, const char *buf, unsigned int len);
void	ERR_load_SSL_strings(void );
void	SSL_load_error_strings(void );
char * 	ssl_state_string(SSL *s);
char * 	ssl_rstate_string(SSL *s);
long	SSL_get_time(SSL_SESSION *s);
long	SSL_set_time(SSL_SESSION *s, long t);
long	SSL_get_timeout(SSL_SESSION *s);
long	SSL_set_timeout(SSL_SESSION *s, long t);

SSL_SESSION *SSL_SESSION_new();
void	SSL_SESSION_print(FILE *fp,SSL_SESSION *ses);
void	SSL_SESSION_free(SSL_SESSION *ses);
int	i2d_SSL_SESSION(SSL_SESSION *in,unsigned char **pp);
int	SSL_set_session(SSL *to, SSL_SESSION *session);
void	SSL_add_session(SSL_CTX *s, SSL_SESSION *c);
void	SSL_remove_session(SSL_CTX *,SSL_SESSION *c);
SSL_SESSION *d2i_SSL_SESSION(SSL_SESSION **a,unsigned char **pp,long length);

#ifdef HEADER_X509_H
X509 *	SSL_get_peer_certificate(SSL *s);
#else
char *	SSL_get_peer_certificate(SSL *s);
#endif

#else

int	SSL_CTX_set_cipher_list();
SSL_CTX *SSL_CTX_new();
void	SSL_CTX_free();
int	SSL_accept();
void	SSL_clear();
int	SSL_connect();
void	SSL_debug();
void	SSL_flush_sessions();
void	SSL_free();
char *	SSL_get_cipher();
int	SSL_get_fd();
char *	SSL_get_cipher_list();
int	SSL_get_read_ahead();
long	SSL_get_time();
long	SSL_get_timeout();
int	SSL_is_init_finished();
SSL *	SSL_new();
int	SSL_pending();
int	SSL_read();
void	SSL_set_fd();
int	SSL_set_cipher_list();
char *	SSL_get_shared_ciphers();
void	SSL_set_read_ahead();
int	SSL_set_timeout();
void	SSL_set_verify();
int	SSL_use_RSAPrivateKey();
int	SSL_use_RSAPrivateKey_ASN1();
int	SSL_use_RSAPrivateKey_file();
int	SSL_use_certificate();
int	SSL_use_certificate_ASN1();
int	SSL_use_certificate_file();
int	SSL_write();
void	ERR_load_SSL_strings();
void	SSL_load_error_strings();
char * 	ssl_state_string();
char * 	ssl_rstate_string();

long	SSL_get_time();
long	SSL_set_time();
long	SSL_get_timeout();
long	SSL_set_timeout();

void	SSL_SESSION_free();
int	i2d_SSL_SESSION();
int	SSL_set_session();
void	SSL_add_session();
void	SSL_remove_session();
SSL_SESSION *SSL_SESSION_new();
void	SSL_SESSION_print();
SSL_SESSION *d2i_SSL_SESSION();

#ifdef HEADER_X509_H
X509 *	SSL_get_peer_certificate();
#else
char *	SSL_get_peer_certificate();
#endif
#endif

/* tjh added these two dudes to enable external control
 * of debug and trace logging
 */
extern FILE *SSL_ERR;
extern FILE *SSL_LOG;

/* BEGIN ERROR CODES */
/* Error codes for the SSL functions. */

/* Function codes. */
#define SSL_F_CLIENT_CERTIFICATE			 100
#define SSL_F_CLIENT_HELLO				 101
#define SSL_F_CLIENT_MASTER_KEY				 102
#define SSL_F_D2I_SSL_SESSION				 103
#define SSL_F_GET_CLIENT_FINISHED			 104
#define SSL_F_GET_CLIENT_HELLO				 105
#define SSL_F_GET_CLIENT_MASTER_KEY			 106
#define SSL_F_GET_NEW_SSL_SESSION			 107
#define SSL_F_GET_SERVER_FINISHED			 108
#define SSL_F_GET_SERVER_HELLO				 109
#define SSL_F_GET_SERVER_VERIFY				 110
#define SSL_F_I2D_SSL_SESSION				 111
#define SSL_F_REQUEST_CERTIFICATE			 112
#define SSL_F_SERVER_HELLO				 113
#define SSL_F_SSL_ACCEPT				 114
#define SSL_F_SSL_CERT_NEW				 115
#define SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT		 116
#define SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT		 117
#define SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT		 118
#define SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT		 119
#define SSL_F_SSL_CONNECT				 120
#define SSL_F_SSL_ENC_DES_CBC_INIT			 121
#define SSL_F_SSL_ENC_DES_EDE3_CBC_INIT			 122
#define SSL_F_SSL_ENC_IDEA_CBC_INIT			 123
#define SSL_F_SSL_ENC_NULL_INIT				 124
#define SSL_F_SSL_ENC_RC2_CBC_INIT			 125
#define SSL_F_SSL_ENC_RC4_INIT				 126
#define SSL_F_SSL_NEW					 127
#define SSL_F_SSL_READ					 128
#define SSL_F_SSL_SESSION_NEW				 129
#define SSL_F_SSL_SET_CERTIFICATE			 130
#define SSL_F_SSL_USE_CERTIFICATE_ASN1			 131
#define SSL_F_SSL_USE_CERTIFICATE_FILE			 132
#define SSL_F_SSL_USE_RSAPRIVATEKEY			 133
#define SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1		 134
#define SSL_F_SSL_USE_RSAPRIVATEKEY_FILE		 135
#define SSL_F_SSL_WRITE					 136

/* Reason codes. */
#define SSL_R_BAD_AUTHENTICATION_TYPE			 100
#define SSL_R_BAD_CHECKSUM				 101
#define SSL_R_BAD_MAC_DECODE				 102
#define SSL_R_BAD_RESPONSE_ARGUMENT			 103
#define SSL_R_BAD_SSL_FILETYPE				 104
#define SSL_R_BAD_SSL_SESSION_ID_LENGTH			 105
#define SSL_R_BAD_STATE					 106
#define SSL_R_BAD_WRITE_RETRY				 107
#define SSL_R_CHALLENGE_IS_DIFFERENT			 108
#define SSL_R_CIPHER_CODE_TOO_LONG			 109
#define SSL_R_CIPHER_TABLE_SRC_ERROR			 110
#define SSL_R_CONECTION_ID_IS_DIFFERENT			 111
#define SSL_R_INVALID_CHALLENGE_LENGTH			 112
#define SSL_R_NO_CERTIFICATE_SET			 113
#define SSL_R_NO_CERTIFICATE_SPECIFIED			 114
#define SSL_R_NO_CIPHER_LIST				 115
#define SSL_R_NO_CIPHER_MATCH				 116
#define SSL_R_NO_CIPHER_WE_TRUST			 117
#define SSL_R_NO_PRIVATEKEY				 118
#define SSL_R_NO_PUBLICKEY				 119
#define SSL_R_NULL_SSL_CTX				 120
#define SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE		 121
#define SSL_R_PEER_ERROR				 122
#define SSL_R_PEER_ERROR_CERTIFICATE			 123
#define SSL_R_PEER_ERROR_NO_CIPHER			 124
#define SSL_R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE	 125
#define SSL_R_PERR_ERROR_NO_CERTIFICATE			 126
#define SSL_R_PUBLIC_KEY_ENCRYPT_ERROR			 127
#define SSL_R_READ_WRONG_PACKET_TYPE			 128
#define SSL_R_REVERSE_KEY_ARG_LENGTH_IS_WRONG		 129
#define SSL_R_REVERSE_MASTER_KEY_LENGTH_IS_WRONG	 130
#define SSL_R_REVERSE_SSL_SESSION_ID_LENGTH_IS_WRONG	 131
#define SSL_R_SHORT_READ				 132
#define SSL_R_SSL_SESSION_ID_IS_DIFFERENT		 133
#define SSL_R_UNKNOWN_REMOTE_ERROR_TYPE			 134
#define SSL_R_UNKNOWN_STATE				 135
#define SSL_R_UNSUPORTED_CIPHER				 136

#endif
