/* lib/asn1/net_hdr.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include "crypto.h"
#include "asn1_mac.h"
#include "asn1.h"

/*
 * ASN1err(ASN1_F_D2I_ASN1_HEADER,ASN1_R_LENGTH_MISMATCH);
 * ASN1err(ASN1_F_I2D_ASN1_HEADER,ASN1_R_BAD_GET_OBJECT);
 * ASN1err(ASN1_F_I2D_ASN1_HEADER,ASN1_R_BAD_GET_OBJECT);
 * ASN1err(ASN1_F_ASN1_HEADER_NEW,ASN1_R_BAD_GET_OBJECT);
 */

int i2d_ASN1_HEADER(a,pp)
ASN1_HEADER *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->header,	i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_len(a->data,		a->meth->i2d);

	M_ASN1_I2D_seq_total();

	M_ASN1_I2D_put(a->header,	i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_put(a->data,		a->meth->i2d);

	M_ASN1_I2D_finish();
	}

ASN1_HEADER *d2i_ASN1_HEADER(a,pp,length)
ASN1_HEADER **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,ASN1_HEADER *,ASN1_HEADER_new);

	M_ASN1_D2I_Init();
        M_ASN1_D2I_start_sequence();
        M_ASN1_D2I_get(ret->header,d2i_ASN1_OCTET_STRING);
	if (ret->meth != NULL)
		{
		M_ASN1_D2I_get(ret->data,ret->meth->d2i);
		}
	else
		{
		if (a != NULL) (*a)=ret;
		return(ret);
		}
        M_ASN1_D2I_Finish(a,ASN1_HEADER_free,ASN1_F_D2I_ASN1_HEADER);
	}

ASN1_HEADER *ASN1_HEADER_new()
	{
	ASN1_HEADER *ret=NULL;

	M_ASN1_New_Malloc(ret,ASN1_HEADER);
	M_ASN1_New(ret->header,ASN1_OCTET_STRING_new);
	ret->meth=NULL;
	ret->data=NULL;
	return(ret);
        M_ASN1_New_Error(ASN1_F_ASN1_HEADER_NEW);
	}

void ASN1_HEADER_free(a)
ASN1_HEADER *a;
	{
	if (a == NULL) return;
	ASN1_OCTET_STRING_free(a->header);
	if (a->meth != NULL)
		a->meth->free(a->data);
	free(a);
	}
