#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include "s_disp.h"
#include "apps.h"

#define PROG	s_mult_main

typedef struct buf_st
	{
	int buffer_size;
        int buffer_num_written;
        int buffer_num;
        char *buffer;
	} BUF_STUFF;

static int read_bytes(EIO_HANDLE *dh);
static int write_bytes(EIO_HANDLE *dh);
static int body();

static  void usage()
	{
	fprintf(stderr,"usage: s_mult [args ...]\n");
	fprintf(stderr,"\n");
	fpritnf(stderr," -port arg	-port to connect to (default is %d\n",PORT);
#ifdef FIONBIO
	fprintf(stderr," -nbio         - Run with non-blocking IO\n");
#endif
	}

static int nbio;

int MAIN(argc, argv)
int argc;
char *argv[];
	{
	int port;
	int ret=1;
	BUF_STUFF b;
	EIO_CTX *ctx;
	EIO_HANDLE *dhr,*dhw;

	port=PORT;
	nbio=0;

	argc--;
	argv++;
	while (argc >= 1)
		{
		if	(strcmp(*argv,"-port) == 0)
			{
			if (--argc < 1) goto bad;
			port=atoi(*(++argv));
			if (port == 0) goto bad;
			}
#ifdef FIONBIO
                else if (strcmp(*argv,"-nbio") == 0)
                        { nbio=1; }
#endif
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		usage();
		goto end;
		}

	ret=body(port);
end:
	EXIT(0);
	}

static int body(port)
int port;
	{
	int asock;

	if (!init_server(&asock,port))
		{
		return(0);
		}

	b.buffer_num_written=0;
	b.buffer_num=0;
	b.buffer_size=102400;
	b.buffer=(char *)malloc(102400);

	ctx=EIO_CTX_new();

	dhr=EIO_HANDLE_new();
	dhw=EIO_HANDLE_new();
	dhr->data=(char *)&b;
	dhw->data=(char *)&b;

	EIO_set_handle(dhr,fileno(stdin));
	EIO_set_handle(dhw,fileno(stdout));
	EIO_set_callback(dhr,(int (*)())read_bytes);
	EIO_set_callback(dhw,(int (*)())write_bytes);
	dhw->peer=dhr;
	dhr->peer=dhw;

	EIO_add(ctx,dhr);
	EIO_add(ctx,dhw);

	EIO_set_state(dhr,EIO_EVENT_READ);

	EIO_loop(ctx);

	}

int read_bytes(dh)
EIO_HANDLE *dh;
	{
	int i;
	BUF_STUFF *b;

	b=(BUF_STUFF *)dh->data;
	i=read(dh->fd,b->buffer,b->buffer_size);
fprintf(stderr,"READ %d\n",i);
	EIO_set_state(dh,EIO_EVENT_NOTHING);
	b->buffer_num=i;
	b->buffer_num_written=0;
	if (i > 0)
		EIO_set_state(dh->peer,EIO_EVENT_WRITE);
	return(1);
	}

int write_bytes(dh)
EIO_HANDLE *dh;
	{
	int i,j;
	BUF_STUFF *b;

	b=(BUF_STUFF *)dh->data;
	j=b->buffer_num_written;
	i=write(dh->fd,&(b->buffer[j]),b->buffer_num-j);
fprintf(stderr,"WRTIE %d\n",i);
	if (i <= 0)
		EIO_set_state(dh,EIO_EVENT_NOTHING);
	else
		{
		j+=i;
		if (j >= b->buffer_num)
			{
			EIO_set_state(dh,EIO_EVENT_NOTHING);
			EIO_set_state(dh->peer,EIO_EVENT_READ);
			}
		else
			{
			/* keep on writing */
			b->buffer_num_written=j;
			}
		}
	return(1);
	}
