#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <signal.h>

#include "rsa.h"
#include "x509.h"
#include "pem.h"
#include "ssl.h"
#include "s_net.h"
#include "s_apps.h"
#include "s_eio.h"
#include "apps.h"

#define PROG	s_mult_main

typedef struct buf_st
	{
	char *data; /* extra data */
	int buffer_size;
        int buffer_num_written;
        int buffer_num;
        char *buffer;
	} BUF_STUFF;

static int do_accept_handler(EIO_HANDLE *dh);
static int do_stdin(EIO_HANDLE *dh);
static int body();
static int do_normal_fd(EIO_HANDLE *dh,int type);
static int do_ssl_fd(EIO_HANDLE *dh,int type);
BUF_STUFF *BUF_STUFF_new();

static void usage()
	{
	fprintf(stderr,"usage: s_mult [args ...]\n");
	fprintf(stderr,"\n");
	fprintf(stderr," -port arg	-port to connect to (default is %d\n",PORT);
	fprintf(stderr," -echo          - reflect back what we are sent\n");
	fprintf(stderr," -bsize arg     - buffer size\n");
	fprintf(stderr," -ssl           - accept SSL connection\n");
	fprintf(stderr," -v             - Verbose mode\n");
	fprintf(stderr," -pause         - Have a sleep after each read/write,\n");
	fprintf(stderr,"                  good for testing non-blocking IO\n");
#ifdef FIONBIO
	fprintf(stderr," -nbio          - Run with non-blocking IO\n");
#endif
	}

static int echo=0;
static int nbio=0;
static int bsize=1024*10;
static int Pause=0;
static int verbose=0;
static int ssl=0;
static SSL_CTX *ctx=NULL;
static char *key_file="./server.pem";
static char *cert_file="./server.pem";
static RSA *key=NULL;
static X509 *cert=NULL;

int MAIN(argc, argv)
int argc;
char *argv[];
	{
	int port,badop=0;
	int ret=1;

	/* For when the other end goes berko */
	signal(SIGPIPE,SIG_IGN);

	port=PORT;
	nbio=0;

	argc--;
	argv++;
	while (argc >= 1)
		{
		if	(strcmp(*argv,"-port") == 0)
			{
			if (--argc < 1) goto bad;
			port=atoi(*(++argv));
			if (port == 0) goto bad;
			}
		else if (strcmp(*argv,"-bsize") == 0)
			{
			if (--argc < 1) goto bad;
			bsize=atoi(*(++argv));
			if (bsize == 0) goto bad;
			}
                else if (strcmp(*argv,"-echo") == 0)
                        { echo=1; }
                else if (strcmp(*argv,"-v") == 0)
                        { verbose=1; }
                else if (strcmp(*argv,"-pause") == 0)
                        { Pause=1; }
                else if (strcmp(*argv,"-ssl") == 0)
                        { ssl=1; }
#ifdef FIONBIO
                else if (strcmp(*argv,"-nbio") == 0)
                        { nbio=1; }
#endif
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		usage();
		goto end;
		}

	if (ssl)
		{
		if ((ctx=SSL_CTX_new()) == NULL)
			{
			goto end;
			}
		}
	ret=body(port);
end:
	EXIT(0);
	}

static int body(port)
int port;
	{
	int ret;
	int asock;
	EIO_CTX *dctx;
	EIO_HANDLE *ah;
	FILE *in;

	if (!init_server(&asock,port))
		return(0);

	dctx=EIO_CTX_new();

	if ((in=fopen(key_file,"r")) == NULL) goto err;
	if ((key=PEM_read_RSAPrivateKey(in,NULL,NULL)) == NULL) goto err;
	fclose(in);

	if ((in=fopen(cert_file,"r")) == NULL) goto err;
	if ((cert=PEM_read_X509(in,NULL,NULL)) == NULL) goto err;
	fclose(in);

	/* Setup an accept socket */
	ah=EIO_HANDLE_new();
	EIO_set_handle(ah,asock);
	EIO_set_callback(ah,(int (*)())do_accept_handler);
	EIO_add(dctx,ah);
	EIO_set_state(ah,EIO_EVENT_READ);

	/* Lets also read from stdin */
	ah=EIO_HANDLE_new();
	EIO_set_handle(ah,fileno(stdin));
	EIO_set_callback(ah,(int (*)())do_stdin);
	EIO_add(dctx,ah);
	EIO_set_state(ah,EIO_EVENT_READ);

	ret=EIO_loop(dctx);
err:
	SHUTDOWN(asock);
	return(ret);
	}

static int do_accept_handler(dh)
EIO_HANDLE *dh;
	{
	int asock,sock;

	asock=dh->fd;

	if (verbose) printf("ACCEPT\n");
	if (!do_accept(dh->fd,&sock,NULL))
		{
		fprintf(stderr,"accept failed - shuting down accept socket\n");
		SHUTDOWN(dh->fd);
		EIO_set_state(dh,EIO_EVENT_NOTHING);
		}
	else
		{
		EIO_HANDLE *hr,*hw;
		BUF_STUFF *b;
		static FILE *out=NULL;

		if ((out == NULL) && (!echo))
			out=fopen("/dev/null","w");

#ifdef FIONBIO
		if (nbio)
			{
			int i=1;
			ioctl(sock,FIONBIO,&i);
			}
#endif
		b=BUF_STUFF_new();
		hr=EIO_HANDLE_new();
		hr->data=(char *)b;
		EIO_set_handle(hr,sock);
		if (ssl)
			{
			SSL *s;

			s=(SSL *)SSL_new(ctx);
			if (Pause) s->debug=1;
			SSL_use_certificate(s,cert);
			SSL_use_RSAPrivateKey(s,key);
			SSL_set_fd(s,sock);
			/* put the SSL data in the shared struct */
			b->data=(char *)s;
			EIO_set_callback(hr,(int (*)())do_ssl_fd);
			}
		else
			EIO_set_callback(hr,(int (*)())do_normal_fd);
		EIO_set_state(hr,EIO_EVENT_READ);
		EIO_add(dh->ctx,hr);
		hr->peer=hr;
		if (!echo)
			{
			hw=EIO_HANDLE_new();
			EIO_set_handle(hw,fileno(out));
			/* EIO_set_handle(hw,dup(fileno(stdout)));*/
			EIO_set_callback(hw,(int (*)())do_normal_fd);
			hw->data=(char *)b;
			hr->peer=hw;
			hw->peer=hr;
			EIO_set_state(hw,EIO_EVENT_NOTHING);
			EIO_add(dh->ctx,hw);
			}
		}
	return(1);
	}

static int do_normal_fd(dh,type)
EIO_HANDLE *dh;
int type;
	{
	int i,j,ret=1;
	BUF_STUFF *b;

	b=(BUF_STUFF *)dh->data;

	if (type == EIO_EVENT_READ)
		{
		i=read(dh->fd,b->buffer,b->buffer_size);
		if (verbose)
			printf("READ (%3d) %4d -> %4d\n",dh->fd,b->buffer_size,i);
		if (i <= 0)
			{
			EIO_set_state(dh,EIO_EVENT_NOTHING);
			fprintf(stderr,"fd=%d ret=%d\n",dh->fd,i);
			}
		else
			{
			b->buffer_num=i;
			b->buffer_num_written=0;
			EIO_set_state(dh->peer,EIO_EVENT_WRITE);
			}
		if (dh != dh->peer)
			EIO_set_state(dh,EIO_EVENT_NOTHING);
		}
	else if (type == EIO_EVENT_WRITE)
		{
		j=b->buffer_num_written;
		i=write(dh->fd,&(b->buffer[j]),b->buffer_num-j);
		if (verbose)
			printf("WRITE(%3d) %4d -> %4d\n",dh->fd,b->buffer_num-j,i);
		if (i <= 0)
			{
			EIO_set_state(dh,EIO_EVENT_NOTHING);
			}
		else
			{
			j+=i;
			if (j >= b->buffer_num)
				{
				if (dh->peer != dh)
					EIO_set_state(dh,EIO_EVENT_NOTHING);
				EIO_set_state(dh->peer,EIO_EVENT_READ);
				}
			else
				{ /* keep on writing */
				b->buffer_num_written=j;
				}
			}
		}
	return(ret);
	}

static int do_ssl_fd(dh,type)
EIO_HANDLE *dh;
int type;
	{
	int i,j,ret=1;
	BUF_STUFF *b;
	SSL *s;

	b=(BUF_STUFF *)dh->data;
	s=(SSL *)b->data;

	/* If the connection is not established, we need to call
	 * SSL_accept */
	if (!SSL_is_established(s))
		{
		if (verbose)
			fprintf(stderr,"SSL_accept\n");
		i=SSL_accept(s);
		if (i <= 0)
			{
			if (verbose)
				fprintf(stderr,"SSL_accept(%3X:%s) -> %d\n",
					SSL_state(s),ssl_state_string(s),i);
			if (should_retry(i))
				{
				/* We would have blocked in SSL_accept()
				 * so we need to 'redo' SSL_accept()
				 * when more of the correct operations
				 * can be done on the socket. */
				if (SSL_want_read(s))
					{
					if (verbose)
						fprintf(stderr,"re-read\n");
					if (type != EIO_EVENT_READ)
						{
						fprintf(stderr,"bad\n");
						abort();
						}
					EIO_set_state(dh,EIO_EVENT_READ);
					}
				else
					{
					if (verbose)
						fprintf(stderr,"re-write\n");
					if (type != EIO_EVENT_WRITE)
						{
						fprintf(stderr,"bad2\n");
						abort();
						}
					EIO_set_state(dh,EIO_EVENT_WRITE);
					}
				}
			else /* Error in SSL_accept */
				{
				if (verbose)
					printf("SSL_accept() failure\n");
				/* we shut things down */
				EIO_set_state(dh,EIO_EVENT_NOTHING);
				}
			goto end;
			}
		else
			{
			/* Finished setup */
			if (verbose)
				fprintf(stderr,"SSL_accept finished\n");
			EIO_set_state(dh,EIO_EVENT_READ);
			}
		goto end;
		}

	if (type == EIO_EVENT_READ)
		{
		i=SSL_read(s,b->buffer,b->buffer_size);
		if (verbose)
			printf("SSL READ (%3d) %4d -> %4d\n",dh->fd,b->buffer_size,i);
		if (i <= 0)
			{
			if (!should_retry(i))
				{
				EIO_set_state(dh,EIO_EVENT_NOTHING);
				fprintf(stderr,"fd=%d ret=%d\n",dh->fd,i);
				}
			if (verbose) fprintf(stderr,"retry\n");
			}
		else
			{
			b->buffer_num=i;
			b->buffer_num_written=0;
			if (echo)
				EIO_set_state(dh->peer,EIO_EVENT_WRITE);
			}
		if ((dh != dh->peer) && (echo))
			EIO_set_state(dh,EIO_EVENT_NOTHING);
		}
	/* The following will not get run if echo mode is not on */
	else if (type == EIO_EVENT_WRITE)
		{
		j=b->buffer_num_written;
		i=SSL_write(s,&(b->buffer[j]),b->buffer_num-j);
		if (verbose)
			printf("SSL WRITE(%3d) %4d -> %4d\n",dh->fd,b->buffer_num-j,i);
		if (i <= 0)
			{
			if (!should_retry(i))
				{
				EIO_set_state(dh,EIO_EVENT_NOTHING);
				fprintf(stderr,"fd=%d ret=%d\n",dh->fd,i);
				}
			if (verbose) fprintf(stderr,"retry\n");
			}
		else
			{
			j+=i;
			if (j >= b->buffer_num)
				{
				if (dh->peer != dh)
					EIO_set_state(dh,EIO_EVENT_NOTHING);
				EIO_set_state(dh->peer,EIO_EVENT_READ);
				}
			else
				{ /* keep on writing */
				b->buffer_num_written=j;
				}
			}
		}
end:
	return(ret);
	}

static int do_stdin(dh)
EIO_HANDLE *dh;
	{
	int i;
	char buf[1024];

	i=read(dh->fd,buf,1024);
	if (buf[0] == 'Q') return(0);
	write(fileno(stderr),"echo ",5);
	write(fileno(stderr),buf,i);
	return(1);
	}


BUF_STUFF *BUF_STUFF_new()
	{
	BUF_STUFF *ret;

	ret=(BUF_STUFF *)malloc(sizeof(BUF_STUFF));
	ret->buffer=(char *)malloc(bsize);
	ret->buffer_size=bsize;
	ret->buffer_num_written=0;
	ret->buffer_num=0;
	return(ret);
	}
