#define EIO_EVENT_NOTHING	0x00
#define EIO_EVENT_READ		0x01
#define EIO_EVENT_WRITE	0x02
#define EIO_EVENT_EXCEPTION	0x04
#define EIO_EVENT_MASK		0x07

typedef struct eio_ctx_st
	{
	int max_fd;
	fd_set read;
	fd_set write;
	fd_set exception;

	int num_handlers;
	struct eio_handle_st **handlers;
	/* if debug & 1, a sleep(1) is done each time around the select loop */
	int debug;
	} EIO_CTX;

/* These are registered for action, callback(fd,arg) */
typedef struct eio_handle_st
	{
	EIO_CTX *ctx;
	int state;
	int fd;
	int (*callback)(); /* ret 1 to keep in list, 0 to remove */

	/* The following are for use by the handlers. */
	struct eio_handle_st *peer;
	char *data;
	} EIO_HANDLE;

int EIO_add(EIO_CTX *ctx, EIO_HANDLE *hdl);
void EIO_set_callback(EIO_HANDLE *hdr, int (*callback)());
int EIO_set_handle(EIO_HANDLE *hdr, int fd);
int EIO_get_state(EIO_HANDLE *hdl);
void EIO_set_state(EIO_HANDLE *dhl, int state);

EIO_HANDLE *EIO_HANDLE_new();
void EIO_HANDLE_free(EIO_HANDLE *a);
EIO_CTX *EIO_CTX_new();

int EIO_loop(EIO_CTX *ctx);

