/* apps/s_eio.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include "s_net.h"
#include "s_eio.h"

int EIO_add(ctx,hdl)
EIO_CTX *ctx;
EIO_HANDLE *hdl;
	{
	EIO_HANDLE **hp;
	int i,j;

	if (hdl->fd+1 >= ctx->num_handlers) /* bump up table */
		{
		i=hdl->fd+1+10; /* allocate extra space */
		hp=ctx->handlers;
		if (hp == NULL)
			{
			hp=(EIO_HANDLE **)malloc(i*sizeof(EIO_HANDLE *));
			}
		else
			{
			hp=(EIO_HANDLE **)realloc(hp,i*sizeof(EIO_HANDLE *));
			if (hp == NULL) return(0);
			}
		for (j=ctx->num_handlers; j<i; j++)
			hp[j]=NULL;
		ctx->num_handlers=i;
		ctx->handlers=hp;
		}
	hp=ctx->handlers;
	if (hp[hdl->fd] != NULL)
		return(0);
	else
		hp[hdl->fd]=hdl;

	hdl->ctx=ctx;
	i=hdl->state;
	hdl->state=EIO_EVENT_NOTHING;
	EIO_set_state(hdl,i);
	return(1);
	}

void EIO_set_callback(hdl,callback)
EIO_HANDLE *hdl;
int (*callback)();
	{
	hdl->callback=callback;
	}


int EIO_set_handle(hdl,fd)
EIO_HANDLE *hdl;
int fd;
	{
	if (hdl->ctx != NULL)
		{
		/* we need to 'remove' then 'add' */
		return(0);
		}
	hdl->fd=fd;
	return(1);
	}

int EIO_get_state(hdl)
EIO_HANDLE *hdl;
	{
	return(hdl->state);
	}

void EIO_set_state(hdl,state)
EIO_HANDLE *hdl;
int state;
	{
	int ch,i;
	EIO_CTX *ctx;
	EIO_HANDLE **h;
	
	ch=hdl->state ^ state;	/* Gives the ones that have changed */
	hdl->state=state;

	ctx=hdl->ctx;
	if (ctx == NULL) return;

	if (ch == 0) return;
	if (ch & EIO_EVENT_READ)
		{
		if (state & EIO_EVENT_READ)
			{ FD_SET(  hdl->fd,&(ctx->read)); }
		else	{ FD_CLR(hdl->fd,&(ctx->read)); }
		}
	if (ch & EIO_EVENT_WRITE)
		{
		if (state & EIO_EVENT_WRITE)
			{ FD_SET(  hdl->fd,&(ctx->write)); }
		else	{ FD_CLR(hdl->fd,&(ctx->write)); }
		}
	if (ch & EIO_EVENT_EXCEPTION)
		{
		if (state & EIO_EVENT_EXCEPTION)
			{ FD_SET(  hdl->fd,&(ctx->exception)); }
		else	{ FD_CLR(hdl->fd,&(ctx->exception)); }
		}

	if (ctx == NULL) return;

	/* We now adjust the ctx fd list to modify the
	 * 'top' fd we listen to if required */
	i=ctx->max_fd;
	/* Check if we lost the top fd so scale things back */
	if ((state == 0) && (hdl->fd+1 == i))
		{
		i--;
		h=ctx->handlers;
		for (;;)
			{
			if (i == 0) break;
			if ((h[i-1] != NULL) && (
				!FD_ISSET(i-1,&(ctx->read)) &&
				!FD_ISSET(i-1,&(ctx->write)) &&
				!FD_ISSET(i-1,&(ctx->exception))))
				i--;
			else
				break;
			}
		ctx->max_fd=i;
		}
	else if ((state != 0) && (hdl->fd >= ctx->max_fd))
		{
		ctx->max_fd=hdl->fd+1;
		}
	}


EIO_HANDLE *EIO_HANDLE_new()
	{
	EIO_HANDLE *ret;

	ret=(EIO_HANDLE *)malloc(sizeof(EIO_HANDLE));
	ret->ctx=NULL;
	ret->fd=0;
	ret->state=0;
	ret->callback=NULL;
	ret->peer=NULL;
	ret->data=NULL;
	return(ret);
	}

void EIO_HANDLE_free(a)
EIO_HANDLE *a;
	{
	free((char *)a);
	}

EIO_CTX *EIO_CTX_new()
	{
	EIO_CTX *ret;

	ret=(EIO_CTX *)malloc(sizeof(EIO_CTX));
	ret->max_fd=0;
	FD_ZERO(&(ret->read));
	FD_ZERO(&(ret->write));
	FD_ZERO(&(ret->exception));
	ret->num_handlers=0;
	ret->handlers=NULL;
	return(ret);
	}

int EIO_loop(ctx)
EIO_CTX *ctx;
	{
	int n,i,ret;
	fd_set read_fds;
	fd_set write_fds;
	fd_set exception_fds;
	EIO_HANDLE *hp;

	for (;;)
		{
		if (ctx->max_fd <= 0) 
			{
			ret=1;
			break;
			}
		memcpy((char *)&read_fds,(char *)&(ctx->read),
			sizeof(read_fds));
		memcpy((char *)&write_fds,(char *)&(ctx->write),
			sizeof(write_fds));
		memcpy((char *)&exception_fds,(char *)&(ctx->exception),
			sizeof(exception_fds));
		if (ctx->debug & 0x01) sleep(1);
		n=select(ctx->max_fd,&read_fds,&write_fds,&exception_fds,NULL);
		if (n <= 0)
			{
			/* error callback */
			}
		if (n >= ctx->num_handlers)
			{
			fprintf(stderr,"FATAL ERROR, this should not happen\n");
			abort();
			}
		for (i=0; i<ctx->max_fd; i++)
			{
			hp=ctx->handlers[i];
			if (hp == NULL) continue;
			if ((hp->state & EIO_EVENT_MASK) &&
				(hp->callback != NULL))
				{
				if ((hp->state & EIO_EVENT_READ) &&
					FD_ISSET(i,&read_fds))
					{
					ret=hp->callback(hp,EIO_EVENT_READ);
					if (ret <= 0) goto out;
					n--;
					}
				if ((hp->state & EIO_EVENT_WRITE) &&
					FD_ISSET(i,&write_fds))
					{
					ret=hp->callback(hp,EIO_EVENT_WRITE);
					if (ret <= 0) goto out;
					n--;
					}
				if ((hp->state & EIO_EVENT_EXCEPTION) &&
					FD_ISSET(i,&exception_fds))
					{
					ret=hp->callback(hp,EIO_EVENT_EXCEPTION);
					if (ret <= 0) goto out;
					n--;
					}
				}
			if (n == 0) break;
			}
		}
out:
	return(ret);
	}
