#!/usr/local/bin/perl

$mkprog='mklinks';
$rmprog='rmlinks';

print "#ifndef NOPROTO\n";
foreach (@ARGV)
	{ printf "extern int %s_main(int argc,char *argv[]);\n",$_; }
print "#else\n";
foreach (@ARGV)
	{ printf "extern int %s_main();\n",$_; }
print "#endif\n";


print <<'EOF';

#define FUNC_TYPE_GENERAL	1
#define FUNC_TYPE_MD		2
#define FUNC_TYPE_CIPHER	3

typedef struct {
	int type;
	char *name;
	int (*func)();
	} FUNCTION;

FUNCTION functions[] = {
EOF

foreach (@ARGV)
	{
	push(@files,$_);
	printf "\t{FUNC_TYPE_GENERAL,\"%s\",%s_main},\n",$_,$_;
	}

foreach ("md2","md5","sha","sha1")
	{
	push(@files,$_);
	printf "\t{FUNC_TYPE_MD,\"%s\",dgst_main},\n",$_;
	}

foreach (
	"des", "des3", "idea", "rc4", "rc2",
	"des-ecb", "des-ede",    "des-ede3",
	"des-cbc", "des-ede-cbc","des-ede3-cbc",
	"des-cfb", "des-ede-cfb","des-ede3-cfb",
	"des-ofb", "des-ede-ofb","des-ede3-ofb",
	"idea-cbc","idea-ecb",   "idea-cfb",  "idea-ofb",
	"rc2-cbc", "rc2-ecb",     "rc2-cfb",  "rc2-ofb")
	{
	push(@files,$_);
	printf "\t{FUNC_TYPE_CIPHER,\"%s\",enc_main},\n",$_;
	}

print "\t{0,NULL,NULL}\n\t};\n";

open(OUT,">$mkprog") || die "unable to open '$prog':$!\n";
print OUT "#!/bin/sh\nfor i in ";
foreach (@files)
	{ print OUT $_." "; }
print OUT <<'EOF';

do
echo making symlink for $i
/bin/rm -f $i
ln -s ssleay $i
done
EOF
close(OUT);
chmod(0755,$mkprog);

open(OUT,">$rmprog") || die "unable to open '$prog':$!\n";
print OUT "#!/bin/sh\nfor i in ";
foreach (@files)
	{ print OUT $_." "; }
print OUT <<'EOF';

do
echo removing $i
/bin/rm -f $i
done
EOF
close(OUT);
chmod(0755,$rmprog);
