/* ssl_rsa.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "der.h"
#include "x509.h"
#include "pem.h"
#include "ssl_locl.h"
#include "ssl_rsa.h"

int ssl_rsa_public_encrypt(c, len, from, to)
CERT *c;
int len;
unsigned char *from;
unsigned char *to;
	{
	RSA *rsa;
	int i;

	if ((c == NULL) || (c->publickey == NULL))
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT,SSL_R_NO_PUBLICKEY);
		return(-1);
		}
	rsa=c->publickey;
	/* we have the public key */
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PUBLIC RSA INPUT %d %d\n",len,to);
	for (j=0; j<len; j++) SSL_TRACE(SSL_ERR,"%02X ",from[j]);
	SSL_TRACE(SSL_ERR,"\n");
	for (j=0; j<64; j++) SSL_TRACE(SSL_ERR,"%02X ",to[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	i=RSA_public_encrypt(len,from,to,rsa);
	if (i < 0)
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT,ERR_R_RSA_LIB);
		}
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PUBLIC RSA OUTPUT %d %08x\n",i,to);
	for (j=0; j<i; j++) SSL_TRACE(SSL_ERR,"%02X ",to[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	return(i);
	}

int ssl_rsa_private_encrypt(c, len, from, to)
CERT *c;
int len;
unsigned char *from;
unsigned char *to;
	{
	RSA *rsa;
	int i;

	if ((c == NULL) || (c->privatekey == NULL))
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT,SSL_R_NO_PRIVATEKEY);
		return(-1);
		}
	rsa=c->privatekey;
	/* we have the private key */
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PRIVATE RSA INPUT %d %d\n",len,to);
	for (j=0; j<len; j++) SSL_TRACE(SSL_ERR,"%02X ",from[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	i=RSA_private_encrypt(len,from,to,rsa);
	if (i < 0)
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT,ERR_R_RSA_LIB);
		}
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PRIVATE RSA OUTPUT %d %d\n",i,to);
	for (j=0; j<i; j++) SSL_TRACE(SSL_ERR,"%02X ",to[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	return(i);
	}

int ssl_rsa_private_decrypt(c, len, from, to)
CERT *c;
int len;
unsigned char *from;
unsigned char *to;
	{
	RSA *rsa;
	int i;

	if ((c == NULL) || (c->privatekey == NULL))
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT,SSL_R_NO_PRIVATEKEY);
		return(-1);
		}
	rsa=c->privatekey;

	/* we have the public key */
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PRIVATE RSA INPUT %d\n",len);
	for (j=0; j<len; j++) SSL_TRACE(SSL_ERR,"%02X ",from[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	i=RSA_private_decrypt(len,from,to,rsa);
	if (i < 0)
		SSLerr(SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT,ERR_R_RSA_LIB);
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PRIVATE RSA OUTPUT %d\n",i);
	for (j=0; j<i; j++) SSL_TRACE(SSL_ERR,"%02X ",to[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	return(i);
	}

int SSL_use_certificate(ssl, x)
SSL *ssl;
X509 *x;
	{
	CERT *c;

	if (ssl->cert == NULL)
		{
		c=ssl_cert_new();
		if (c == NULL) return(0);
		ssl->cert=c;
		}
	c=ssl->cert;

	if (!ssl_set_cert_type(c,SSL_CT_X509_CERTIFICATE)) return(0);
	c->x509=x;
	c->publickey=ssl_rsa_extract_public_key(x);
	if (c->publickey == NULL) return(0);
	return(1);
	}

int SSL_use_certificate_file(ssl, file, type)
SSL *ssl;
char *file;
int type;
	{
	int i,j;
	FILE *in;
	X509 *x;

	in=fopen(file,"r");
	if (in == NULL)
		{
		SYSerr(ERR_F_FOPEN,errno);
		SSLerr(SSL_F_SSL_USE_CERTIFICATE,ERR_R_SYS_LIB);
		return(0);
		}
	/* check we can decode it */
	x=(X509 *)X509_new();
	if (x == NULL)
		{
		SSLerr(SSL_F_SSL_USE_CERTIFICATE,ERR_R_X509_LIB);
		fclose(in);
		return(0);
		}
	if (type == X509_FILETYPE_DER)
		{
		j=ERR_R_DER_LIB;
		i=D2i_X509_fp(in,x);
		}
	else if (type == X509_FILETYPE_TEXT)
		{
		j=ERR_R_DER_LIB;
		i=f2i_X509(in,x);
		}
	else if (type == X509_FILETYPE_PEM)
		{
		j=ERR_R_PEM_LIB;
		i=PEM_read_X509(in,x);
		}
	else
		{
		SSLerr(SSL_F_SSL_USE_CERTIFICATE,SSL_R_BAD_X509_FILETYPE);
		fclose(in);
		return(0);
		}
	fclose(in);

	if (!i)
		{
		SSLerr(SSL_F_SSL_USE_CERTIFICATE,j);
		return(0);
		}

	return(SSL_use_certificate(ssl,x));
	}

int SSL_use_certificate_DER(ssl, len, d)
SSL *ssl;
int len;
unsigned char *d;
	{
	int i;
	X509 *x;

	x=(X509 *)X509_new();
	if (x == NULL)
		{
		SSLerr(SSL_F_SSL_USE_CERTIFICATE_DER,ERR_R_X509_LIB);
		return(0);
		}
	i=D2i_X509(x,len,d);
	if (!i)
		{
		SSLerr(SSL_F_SSL_USE_CERTIFICATE_DER,ERR_R_DER_LIB);
		return(0);
		}

	return(SSL_use_certificate(ssl,x));
	}

int SSL_use_RSAPrivateKey(ssl, rsa)
SSL *ssl;
RSA *rsa;
	{
	CERT *c;

	if (ssl->cert == NULL)
		{
		c=ssl_cert_new();
		if (c == NULL)
			{
			SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY,
				ERR_R_MALLOC_FAILURE);
			return(0);
			}
		ssl->cert=c;
		}
	c=ssl->cert;

	if (!ssl_set_cert_type(c,SSL_CT_X509_CERTIFICATE)) return(0);
	c->privatekey=rsa;
	return(1);
	}

int SSL_use_RSAPrivateKey_file(ssl, file, type)
SSL *ssl;
char *file;
int type;
	{
	int i,j;
	FILE *in;
	RSA *rsa;

	in=fopen(file,"r");
	if (in == NULL)
		{
		SYSerr(ERR_F_FOPEN,errno);
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_FILE,ERR_R_SYS_LIB);
		return(0);
		}
	rsa=RSA_new();
	if (rsa == NULL)
		{
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_FILE,ERR_R_RSA_LIB);
		fclose(in);
		return(0);
		}
	if	(type == X509_FILETYPE_DER)
		{
		j=ERR_R_DER_LIB;
		i=D2i_RSAPrivateKey_fp(in,rsa);
		}
	else if (type == X509_FILETYPE_TEXT)
		{
		j=ERR_R_DER_LIB;
		i=f2i_RSAPrivateKey(in,rsa);
		}
	else if (type == X509_FILETYPE_PEM)
		{
		j=ERR_R_PEM_LIB;
		i=PEM_read_RSA(in,rsa);
		}
	else
		{
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_FILE,
			SSL_R_BAD_X509_FILETYPE);
		fclose(in);
		return(0);
		}
	fclose(in);
	if (!i)
		{
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_FILE,j);
		return(0);
		}

	return(SSL_use_RSAPrivateKey(ssl,rsa));
	}

int SSL_use_RSAPrivateKey_DER(ssl,len,d)
SSL *ssl;
int len;
unsigned char *d;
	{
	unsigned char *p;
	int i;
	RSA *rsa;

	rsa=RSA_new();
	if (rsa == NULL)
		{
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_DER,ERR_R_RSA_LIB);
		return(0);
		}
	p=d;
	i=D2i_RSAPrivateKey(rsa,&p);
	if (!i)
		{
		SSLerr(SSL_F_SSL_USE_RSAPRIVATEKEY_DER,ERR_R_DER_LIB);
		return(0);
		}

	return(SSL_use_RSAPrivateKey(ssl,rsa));
	}

int ssl_rsa_public_decrypt(c, len, from, to)
CERT *c;
int len;
unsigned char *from;
unsigned char *to;
	{
	RSA *rsa;
	int i;

	if ((c == NULL) || (c->publickey == NULL))
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT,SSL_R_NO_PUBLICKEY);
		return(-1);
		}
	rsa=c->publickey;
	/* we have the public key */
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PUBLIC RSA INPUT %d\n",len);
	for (j=0; j<len; j++) SSL_TRACE(SSL_ERR,"%02X ",from[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif RSA_DEBUG
	i=RSA_public_decrypt(len,from,to,rsa);
	if (i < 0)
		{
		SSLerr(SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT,ERR_R_RSA_LIB);
		}
#ifdef RSA_DEBUG
	SSL_TRACE(SSL_ERR,"PUBLIC RSA OUTPUT %d\n",i);
	for (j=0; j<i; j++) SSL_TRACE(SSL_ERR,"%02X ",to[j]);
	SSL_TRACE(SSL_ERR,"\n");
#endif RSA_DEBUG
	return(i);
	}

RSA *ssl_rsa_extract_public_key(x)
X509 *x;
	{
	RSA *rsa;
	unsigned char *p;

	rsa=RSA_new();
	if (rsa == NULL)
		{
		SSLerr(SSL_F_SSL_EXTRACT_PUBLIC_KEY,ERR_R_RSA_LIB);
		return(NULL);
		}
	p=x->cert_info->key->public_key->data;
	if (!D2i_RSAPublicKey(rsa,&p))
		{
		SSLerr(SSL_F_SSL_EXTRACT_PUBLIC_KEY,ERR_R_DER_LIB);
		RSA_free(rsa);
		return(NULL);
		}
	return(rsa);
	}

