/* ssl_md5.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md5.h"
#include "ssl_locl.h"
#include "ssl_md5.h"

void ssl_compute_md5_mac(s, md)
SSL *s;
unsigned char *md;
	{
	MD5_CTX c;
	unsigned char sequence[4],*p,*sec;
	unsigned long seq,len;

	if (s->send)
		{
		seq=s->write_sequence;
		sec=s->write_key;
		len=s->wact_data_length;
		}
	else
		{
		seq=s->read_sequence;
		sec=s->read_key;
		len=s->ract_data_length;
		}
	p= &(sequence[0]);
	l2n(seq,p);
#ifdef MAC_DEBUG
	SSL_TRACE(SSL_ERR,"MAC generation send=%d\n",s->send);
	ssl_print_bytes(SSL_ERR,s->conn->cipher->key_size,sec);
	SSL_TRACE(SSL_ERR,"\n");
	ssl_print_bytes(SSL_ERR,len,s->act_data);
	SSL_TRACE(SSL_ERR,"\n");
	ssl_print_bytes(SSL_ERR,4,sequence);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	MD5Init(&c);
	MD5Update(&c,sec,s->conn->cipher->key_size);
	MD5Update(&c,s->act_data,len); 
	/* the above line also does the pad data */
	MD5Update(&c,sequence,4); 
	MD5Final(md,&c);
	}

void ssl_compute_md5_mac_1(s, md)
SSL *s;
unsigned char *md;
	{
	MD5_CTX c;
	unsigned char sequence[4],*p,*sec,b[MD5_DIGEST_LENGTH];
	unsigned long seq,len;

	if (s->send)
		{
		seq=s->write_sequence;
		sec=s->write_key;
		len=s->wact_data_length;
		}
	else
		{
		seq=s->read_sequence;
		sec=s->read_key;
		len=s->ract_data_length;
		}
	p= &(sequence[0]);
	l2n(seq,p);
#ifdef MAC_DEBUG
	SSL_TRACE(SSL_ERR,"MAC generation send=%d\n",s->send);
	ssl_print_bytes(SSL_ERR,s->conn->cipher->key_size,sec);
	SSL_TRACE(SSL_ERR,"\n");
	ssl_print_bytes(SSL_ERR,len,s->act_data);
	SSL_TRACE(SSL_ERR,"\n");
	ssl_print_bytes(SSL_ERR,4,sequence);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	MD5Init(&c);
	MD5Update(&c,sec,s->conn->cipher->key_size);
	MD5Update(&c,s->act_data,len); 
	/* the above line also does the pad data */
	MD5Update(&c,sequence,4); 
	MD5Final(b,&c);
	md[0]=b[0];
	}
