/* ssl_locl.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_SSL_LOCL_H
#define HEADER_SSL_LOCL_H
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include "x509.h"

#if !defined(_LIBC) || defined(NOCONST)
#define const
#endif

#define c2l(c,l)	(l = ((unsigned long)(*((c)++)))     , \
			 l|=(((unsigned long)(*((c)++)))<< 8), \
			 l|=(((unsigned long)(*((c)++)))<<16), \
			 l|=(((unsigned long)(*((c)++)))<<24))

/* NOTE - c is not incremented as per c2l */
#define c2ln(c,l1,l2,n)	{ \
			c+=n; \
			l1=l2=0; \
			switch (n) { \
			case 8: l2 =((unsigned long)(*(--(c))))<<24; \
			case 7: l2|=((unsigned long)(*(--(c))))<<16; \
			case 6: l2|=((unsigned long)(*(--(c))))<< 8; \
			case 5: l2|=((unsigned long)(*(--(c))));     \
			case 4: l1 =((unsigned long)(*(--(c))))<<24; \
			case 3: l1|=((unsigned long)(*(--(c))))<<16; \
			case 2: l1|=((unsigned long)(*(--(c))))<< 8; \
			case 1: l1|=((unsigned long)(*(--(c))));     \
				} \
			}

#define l2c(l,c)	(*((c)++)=(unsigned char)(((l)    )&0xff), \
			 *((c)++)=(unsigned char)(((l)>> 8)&0xff), \
			 *((c)++)=(unsigned char)(((l)>>16)&0xff), \
			 *((c)++)=(unsigned char)(((l)>>24)&0xff))

#define n2l(c,l)	(l =((unsigned long)(*((c)++)))<<24, \
			 l|=((unsigned long)(*((c)++)))<<16, \
			 l|=((unsigned long)(*((c)++)))<< 8, \
			 l|=((unsigned long)(*((c)++))))

#define l2n(l,c)	(*((c)++)=(unsigned char)(((l)>>24)&0xff), \
			 *((c)++)=(unsigned char)(((l)>>16)&0xff), \
			 *((c)++)=(unsigned char)(((l)>> 8)&0xff), \
			 *((c)++)=(unsigned char)(((l)    )&0xff))

/* NOTE - c is not incremented as per l2c */
#define l2cn(l1,l2,c,n)	{ \
			c+=n; \
			switch (n) { \
			case 8: *(--(c))=(unsigned char)(((l2)>>24)&0xff); \
			case 7: *(--(c))=(unsigned char)(((l2)>>16)&0xff); \
			case 6: *(--(c))=(unsigned char)(((l2)>> 8)&0xff); \
			case 5: *(--(c))=(unsigned char)(((l2)    )&0xff); \
			case 4: *(--(c))=(unsigned char)(((l1)>>24)&0xff); \
			case 3: *(--(c))=(unsigned char)(((l1)>>16)&0xff); \
			case 2: *(--(c))=(unsigned char)(((l1)>> 8)&0xff); \
			case 1: *(--(c))=(unsigned char)(((l1)    )&0xff); \
				} \
			}

#define n2s(c,s)	(s =((unsigned int)(*((c)++)))<< 8, \
			 s|=((unsigned int)(*((c)++))))
#define s2n(s,c)	(*((c)++)=(unsigned char)(((s)>> 8)&0xff), \
			 *((c)++)=(unsigned char)(((s)    )&0xff))

/* LOCAL STUFF */
#define SSL_DECRYPT	0
#define SSL_ENCRYPT	1

#define TWO_BYTE_BIT	0x80
#define SEC_ESC_BIT	0x40
#define TWO_BYTE_MASK	0x7fff
#define THREE_BYTE_MASK	0x3fff

#define INC32(a)	((a)=((a)+1)&0xffffffff)
#define DEC32(a)	((a)=((a)-1)&0xffffffff)
#define MAX_MAC_SIZE	16

#define CHALLENGE_LENGTH	16
#define CONNECTION_ID_LENGTH	16
#define SESSION_ID_LENGTH	16
#define MAX_CERT_CHALLENGE_LENGTH	32
#define MIN_CERT_CHALLENGE_LENGTH	16

/* used in SSL->peer_status */
#define SSL_PEER_NOT_SET	0
#define SSL_PEER_IN_SSL		1
#define SSL_PEER_IN_CERT	2

#define NUM_CIPHERS	(9+1)
typedef struct cipher_st
	{
	int valid;
	char *name;
	int (*crypt_init)();
	void (*crypt)();
	void (*hash)();
	unsigned int key_size;
	unsigned int mac_size;
	unsigned int block_size;
	unsigned int key_arg_size;

	unsigned char num;
	unsigned char noidea;
	unsigned char keybits;
	unsigned char enc_bits;
	} CIPHER;

typedef struct ssl_conn_st
	{
	CIPHER *ciphers[NUM_CIPHERS+1];
	CIPHER *cipher;
	unsigned int key_arg_length;
	unsigned char *key_arg;
	unsigned int master_key_length;
	unsigned char *master_key;
	unsigned int key_material_length;
	unsigned char *key_material;
	/* session_id - valid? */
	unsigned int session_id_length;
	unsigned char *session_id;

	struct cert_st *cert;

	unsigned int references;
	unsigned long timeout;
	unsigned long time;
	} CONN;

/*
#define CERT_INVALID		0
#define CERT_PUBLIC_KEY		1
#define CERT_PRIVATE_KEY	2
*/
typedef struct cert_st
	{
	int cert_type;
	int (*public_encrypt)();
	int (*public_decrypt)();
	int (*private_encrypt)();
	int (*private_decrypt)();
	X509 *x509;
	RSA *publickey; /* when extracted */
	RSA *privatekey;
	int references;
	} CERT;

extern CIPHER ssl_ciphers[];

/*#define MAC_DEBUG	*/

/*#define ERR_DEBUG	*/
/*#define ABORT_DEBUG	*/
/*#define PKT_DEBUG 1   */
/*#define DES_DEBUG	*/
/*#define DES_OFB_DEBUG	*/
/*#define SSL_DEBUG	*/
/*#define RSA_DEBUG	*/ 
/*#define IDEA_DEBUG	*/ 

#include "ssl.h"
#include "ssl_err.h"

/* this is for debug and tracing stuff */
#include "ssl_trc.h"

/* these are now externally visible ... in ssl.h 
extern FILE *SSL_LOG;
extern FILE *SSL_ERR;
*/

#ifdef PKT_DEBUG
void ssl_debug();
#endif

#ifdef PROTO
CERT *ssl_cert_new(void);
void ssl_clear(SSL *s);
void ssl_conn_free(CONN *c);
void ssl_cert_free(CERT *c);
void ssl_return_error(SSL *s);
RSA *ssl_rsa_extract_public_key(X509 *x);
int ssl_set_certificate(SSL *s, int type, int len, unsigned char *data);
int ssl_set_cert_type(CERT *c, int type);
int ssl_new_conn(SSL *s, int session);
int ssl_get_prev_conn(SSL *s, int len, unsigned char *session);
void ssl_add_hash_conn(CONN *c);
int ssl_rsa_public_decrypt(CERT *c, int len, unsigned char *from, unsigned char *to);
void ssl_print_bytes(FILE *f, int n, char *b);
#else
CERT *ssl_cert_new();
void ssl_clear();
void ssl_conn_free();
void ssl_cert_free();
RSA *ssl_rsa_extract_public_key();
int ssl_set_certificate();
int ssl_set_cert_type();
int ssl_new_conn();
int ssl_get_prev_conn();
void ssl_add_hash_conn();
void ssl_return_error();
int ssl_rsa_public_decrypt();
void ssl_print_bytes();
#endif

#endif

extern int errno;
