/* ssl_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "ssl_err.h"
#include "ssl.h"

static ERR_STRING_DATA SSL_str_functs[]=
	{
{ERR_PACK(0,SSL_F_SSL_NEW,0),			"SSL_NEW"},
{ERR_PACK(0,SSL_F_SSL_CERT_NEW,0),		"SSL_CERT_NEW"},
{ERR_PACK(0,SSL_F_GET_SERVER_HELLO,0),		"GET_SERVER_HELLO"},
{ERR_PACK(0,SSL_F_CLIENT_HELLO,0),		"CLIENT_HELLO"},
{ERR_PACK(0,SSL_F_CLIENT_MASTER_KEY,0),		"CLIENT_MASTER_KEY"},
{ERR_PACK(0,SSL_F_CLIENT_CERTIFICATE,0),	"CLIENT_CERTIFICATE"},
{ERR_PACK(0,SSL_F_GET_SERVER_VERIFY,0),		"GET_SERVER_VERIFY"},
{ERR_PACK(0,SSL_F_GET_SERVER_FINISHED,0),	"GET_SERVER_FINISHED"},
{ERR_PACK(0,SSL_F_GET_NEW_CONN,0),		"GET_NEW_CONN"},
{ERR_PACK(0,SSL_F_SSL_ENC_DES_CBC_INIT,0),	"SSL_ENC_DES_CBC_INIT"},
{ERR_PACK(0,SSL_F_SSL_ENC_DES_EDE3_CBC_INIT,0),	"SSL_ENC_DES_EDE3_CBC_INIT"},
{ERR_PACK(0,SSL_F_SSL_ENC_DES_CFB_INIT,0),	"SSL_ENC_DES_CFB_INIT"},
{ERR_PACK(0,SSL_F_SSL_ENC_NULL_INIT,0),		"SSL_ENC_NULL_INIT"},
{ERR_PACK(0,SSL_F_SSL_ENC_RC4_INIT,0),		"SSL_ENC_RC4_INIT"},
{ERR_PACK(0,SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT,0),"SSL_CERT_RSA_PUBLIC_ENCRYPT"},
{ERR_PACK(0,SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT,0),"SSL_CERT_RSA_PRIVATE_ENCRYPT"},
{ERR_PACK(0,SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT,0),"SSL_CERT_RSA_PUBLIC_DECRYPT"},
{ERR_PACK(0,SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT,0),"SSL_CERT_RSA_PRIVATE_DECRYPT"},
{ERR_PACK(0,SSL_F_SSL_USE_CERTIFICATE,0),	"SSL_USE_CERTIFICATE"},
{ERR_PACK(0,SSL_F_SSL_USE_CERTIFICATE_DER,0),	"SSL_USE_CERTIFICATE_DER"},
{ERR_PACK(0,SSL_F_SSL_USE_RSAPRIVATEKEY,0),	"SSL_USE_RSAPRIVATEKEY"},
{ERR_PACK(0,SSL_F_SSL_USE_RSAPRIVATEKEY_DER,0),	"SSL_USE_RSAPRIVATEKEY_DER"},
{ERR_PACK(0,SSL_F_SSL_EXTRACT_PUBLIC_KEY,0),	"SSL_EXTRACT_PUBLIC_KEY"},
{ERR_PACK(0,SSL_F_SSL_SET_CERTIFICATE,0),	"SSL_SET_CERTIFICATE"},
{ERR_PACK(0,SSL_F_GET_CLIENT_MASTER_KEY,0),	"GET_CLIENT_MASTER_KEY"},
{ERR_PACK(0,SSL_F_GET_CLIENT_HELLO,0),		"GET_CLIENT_HELLO"},
{ERR_PACK(0,SSL_F_SERVER_HELLO,0),		"SERVER_HELLO"},
{ERR_PACK(0,SSL_F_GET_CLIENT_FINISHED,0),	"GET_CLIENT_FINISHED"},
{ERR_PACK(0,SSL_F_REQUEST_CERTIFICATE,0),	"REQUEST_CERTIFICATE"},
{ERR_PACK(0,SSL_F_SSL_ENC_IDEA_CBC_INIT,0),	"SSL_ENC_IDEA_CBC_INIT"},
{ERR_PACK(0,SSL_F_SSL_USE_RSAPRIVATEKEY_FILE,0),"SSL_USE_RSAPRIVATEKEY_FILE"},
{ERR_PACK(0,SSL_F_SSL_WRITE,0),			"SSL_WRITE"},
{ERR_PACK(0,SSL_F_DECODE_RECORD,0),		"DECODE_RECORD"},
{0,NULL},
	};

static ERR_STRING_DATA SSL_str_reasons[]=
	{
{SSL_R_SHORT_READ				,"SHORT_READ"},
{SSL_R_PEER_ERROR				,"PEER_ERROR"},
{SSL_R_READ_WRONG_PACKET_TYPE			,"READ_WRONG_PACKET_TYPE"},
{SSL_R_NO_CIPHER_LIST				,"NO_CIPHER_LIST"},
{SSL_R_NO_CIPHER_MATCH				,"NO_CIPHER_MATCH"},
{SSL_R_PUBLIC_KEY_ENCRYPT_ERROR			,"PUBLIC_KEY_ENCRYPT_ERROR"},
{SSL_R_CHALLENGE_IS_DIFFERENT			,"CHALLENGE_IS_DIFFERENT"},
{SSL_R_SESSION_ID_IS_DIFFERENT			,"SESSION_ID_IS_DIFFERENT"},
{SSL_R_BAD_MAC_DECODE				,"BAD_MAC_DECODE"},
{SSL_R_NO_PUBLICKEY				,"NO_PUBLICKEY"},
{SSL_R_NO_PRIVATEKEY				,"NO_PRIVATEKEY"},
{SSL_R_BAD_X509_FILETYPE			,"BAD_X509_FILETYPE"},
{SSL_R_BAD_SESSION_ID_LENGTH			,"BAD_SESSION_ID_LENGTH"},
{SSL_R_NO_CERTIFICATE_SPECIFIED			,"NO_CERTIFICATE_SPECIFIED"},
{SSL_R_CONNECTION_ID_IS_DIFFERENT		,"CONNECTION_ID_IS_DIFFERENT"},
{SSL_R_PEER_DID_NOT_RETURN_A_CERT		,"PEER_DID_NOT_RETURN_A_CERT"},
{SSL_R_BAD_CHECKSUM				,"BAD_CHECKSUM"},
{SSL_R_BAD_CHECKSUM_DECODE			,"BAD_CHECKSUM_DECODE"},
{SSL_R_BAD_WRITE_RETRY				,"BAD_WRITE_RETRY"},
{SSL_R_CIPHER_TABLE_SRC_ERROR			,"CIPHER_TABLE_SRC_ERROR"},
{0,NULL},
	};

void ERR_load_SSL_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(ERR_LIB_SSL,SSL_str_functs);
		ERR_load_strings(ERR_LIB_SSL,SSL_str_reasons);
		init=0;
		}
	}

void SSL_load_error_strings()
	{
	ERR_load_crypto_strings();
	ERR_load_SSL_strings();
	}

