/* ssl_des.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include "des.h"

typedef struct des_cbc_state_st
	{
	Key_schedule read_ks;
	Key_schedule write_ks;
	C_Block read_iv;
	C_Block write_iv;
	} DES_CBC_STATE;

typedef struct des_ede3_cbc_state_st
	{
	Key_schedule read_ks0;
	Key_schedule read_ks1;
	Key_schedule read_ks2;
	Key_schedule write_ks0;
	Key_schedule write_ks1;
	Key_schedule write_ks2;
	C_Block read_iv;
	C_Block write_iv;
	} DES_EDE3_CBC_STATE;

typedef struct des_cfb_state_st
	{
	int readn;
	int writen;
	Key_schedule read_ks;
	Key_schedule write_ks;
	C_Block read_iv;
	C_Block write_iv;
	} DES_CFB_STATE;

#ifdef PROTO
int ssl_enc_des_cbc_init(SSL *s, int client);
void ssl_enc_des_cbc(SSL *s);
int ssl_enc_des_ede3_cbc_init(SSL *s, int client);
void ssl_enc_des_ede3_cbc(SSL *s);
int ssl_enc_des_cfb_init(SSL *s, int client);
void ssl_enc_des_cfb(SSL *s);
#else
int ssl_enc_des_cbc_init();
void ssl_enc_des_cbc();
int ssl_enc_des_ede3_cbc_init();
void ssl_enc_des_ede3_cbc();
int ssl_enc_des_cfb_init();
void ssl_enc_des_cfb();
#endif
