/* ssl_conn.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md5.h"
#include "lhash.h"
#include "ssl_locl.h"

static LHASH *connections=NULL;
#ifdef PROTO
static unsigned long conn_hash(CONN *a);
static int conn_cmp(CONN *a, CONN *b);
static int conn_init(void);
#else
static unsigned long conn_hash();
static int conn_cmp();
static int conn_init();
#endif

int ssl_new_conn(s, session)
SSL *s;
int session;
	{
	CONN *con,*r;
	int i;

	conn_init();
	/* leave old connection hanging around */
	/* if (s->conn != NULL) ssl_conn_free(s->conn); */

	con=(CONN *)malloc(sizeof(CONN));
	if (con == NULL)
		{
		SSLerr(SSL_F_GET_NEW_CONN,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	for (i=0; i<NUM_CIPHERS+1; i++) con->ciphers[i]=NULL;
	con->cipher=NULL;
	con->key_arg_length=0;
	con->key_arg=NULL;
	con->master_key_length=0;
	con->master_key=NULL;
	con->key_material_length=0;
	con->key_material=NULL;

	if (session)
		{
		con->session_id_length=SESSION_ID_LENGTH;
		con->session_id=(unsigned char *)malloc(SESSION_ID_LENGTH);
		if (con->session_id == NULL)
			{
			SSLerr(SSL_F_GET_NEW_CONN,ERR_R_MALLOC_FAILURE);
			return(0);
			}

		for (;;)
			{
			MD5_rand(SESSION_ID_LENGTH,con->session_id);
			r=(CONN *)lh_retrieve(connections,(char *)con);
			if (r == NULL) break;
			/* else - woops a session_id match */
			}
		}
	else
		{
		con->session_id_length=0;
		con->session_id=NULL;
		}

	con->cert=NULL;
	con->references=1;
	con->timeout=100;
	con->time=time(NULL);
	s->conn=con;
	return(1);
	}

static int conn_init()
	{
	if (connections != NULL) return(1);
	connections=lh_new(conn_hash,conn_cmp);
	return(connections != NULL);
	}

static unsigned long conn_hash(a)
CONN *a;
	{
	unsigned long l;

	l=	a->session_id[0]    |(a->session_id[1]<<8)|
		a->session_id[1]<<16|(a->session_id[2]<<24);
	return(l);
	}

static int conn_cmp(a, b)
CONN *a;
CONN *b;
	{
	int i;

	i=a->session_id_length - b->session_id_length;
	if (i == 0)
		return(memcmp(a->session_id,b->session_id,
			a->session_id_length));
	else	return(1);
	}

int ssl_get_prev_conn(s, len, session)
SSL *s;
int len;
unsigned char *session;
	{
	CONN *ret,data;

	conn_init();
	data.session_id_length=len;
	data.session_id=session;
	if ((ret=(CONN *)lh_retrieve(connections,(char *)&data)) == NULL)
		return(0);
#ifdef SSL_DEBUG
	SSL_TRACE(SSL_ERR,"GOT ONE\n");
#endif
	if (ret->time+ret->timeout < time(NULL)) /* timeout */
		{
#ifdef SSL_DEBUG
		SSL_TRACE(SSL_ERR,"TIMEOUT ON SESSION\n");
#endif
		ssl_conn_free(ret);
		return(0);
		}

	/* ret->time=time(NULL); */ /* rezero timeout? */
	ret->references++;
	/* again, just leave the connection */
	/* if (s->conn != NULL) ssl_conn_free(s->conn); */
	s->conn=ret;
	return(1);
	}

void ssl_add_hash_conn(c)
CONN *c;
	{
	conn_init();
	lh_insert(connections,(char *)c);
	}

void ssl_conn_free(c)
CONN *c;
	{
	CONN *r;

	if (--c->references > 0) return;

	if (c->session_id != NULL)
		{
		r=(CONN *)lh_delete(connections,(char *)c);
		if (r == NULL)
			{
#ifdef SSL_DEBUG
			SSL_TRACE(SSL_ERR,"freeing a conn that is not hashed\n");
#endif
			return;
			}
		}
	if (c->key_arg != NULL)		free(c->key_arg);
	if (c->master_key != NULL)	free(c->master_key);
	if (c->key_material != NULL)	free(c->key_material);
	if (c->cert != NULL)		ssl_cert_free(c->cert);
	free(c);
	}
