/* ssl_cert.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "ssl_locl.h"
#include "ssl_rsa.h"

CERT *ssl_cert_new()
	{
	CERT *ret;

	ret=(CERT *)malloc(sizeof(CERT));
	if (ret == NULL)
		{
		SSLerr(SSL_F_SSL_CERT_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->cert_type=0;
	ret->public_encrypt=NULL;
	ret->public_decrypt=NULL;
	ret->private_encrypt=NULL;
	ret->private_decrypt=NULL;
	ret->x509=NULL;
	ret->publickey=NULL;
	ret->privatekey=NULL;
	ret->references=1;
	return(ret);
	}

void ssl_cert_free(c)
CERT *c;
	{
	if (--c->references) return;
	if (c->x509 != NULL) X509_free(c->x509);
	if (c->privatekey != NULL) RSA_free(c->privatekey);
	free(c);
	}

/* loads in the certificate from the server */
int ssl_set_certificate(s, type, len, data)
SSL *s;
int type;
int len;
unsigned char *data;
	{
	CERT *c;
	int i;
	X509 *x509; /* will don't want to include the headers */
	
	x509=X509_new_D2i_X509(len,data);
	if (x509 == NULL)
		{
		SSLerr(SSL_F_SSL_SET_CERTIFICATE,ERR_R_X509_LIB);
		return(0);
		}

	i=X509_verify(x509,s->verify_callback);
	if ((s->verify_mode & SSL_VERIFY_PEER) && (!i))
		{
		SSLerr(SSL_F_SSL_SET_CERTIFICATE,ERR_R_X509_LIB);
		return(0);
		}

	/* cert for ssl */
	c=ssl_cert_new();
	if (c == NULL) return(-1);

	/* cert for session */
	if (s->conn->cert) ssl_cert_free(s->conn->cert);
	s->conn->cert=c;
	c->references++;

	c->cert_type=type;
	c->x509=x509;
	c->publickey=(RSA *)ssl_rsa_extract_public_key(x509);
	if (c->publickey == NULL) return(0);
	if (!ssl_set_cert_type(c,SSL_CT_X509_CERTIFICATE)) return(0);
	return(1);
	}

int ssl_set_cert_type(c, type)
CERT *c;
int type;
	{
	c->cert_type=type;
	c->public_encrypt=ssl_rsa_public_encrypt;
	c->public_decrypt=ssl_rsa_private_decrypt;
	c->private_encrypt=ssl_rsa_private_encrypt;
	c->private_decrypt=ssl_rsa_private_decrypt;
	return(1);
	}
