/* tst_srvr.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/time.h> /* Needed under linux for FD_XXX */
#include <netinet/in.h>
#include "net.h"
#include "x509.h"
#include "pem.h"
#include "err.h"
#include "ssl.h"
#include "ssl_apps.h"

#ifdef PROTO
static int body(char *hostname, int s);
static void close_accept_socket(void );
#else
static int body();
static void close_accept_socket();
#endif

#define BUFSIZZ	10*1024
static int accept_socket=-1;

#define TEST_CERT	"server.PEM"

int verify=SSL_VERIFY_NONE;
int verify_depth=0;
int verify_error=VERIFY_OK;
char *cert_file=TEST_CERT,*key_file=NULL;

#ifdef PROTO 
static void usage(void);
#else
static void usage();
#endif

static void usage()
	{
	fprintf(stderr,"usage: server args\n");
	fprintf(stderr,"\n");
	fprintf(stderr," -port arg     - port to connect to (default is %d\n",PORT);
	fprintf(stderr," -verify arg   - turn on peer certificate verification\n");
	fprintf(stderr," -Verify arg   - turn on peer certificate verification, must have a cert.\n");
	fprintf(stderr," -cert arg     - certificate file to use, PEM format assumed\n");
	fprintf(stderr,"                 (default is %s)\n",TEST_CERT);
	fprintf(stderr," -key arg      - RSA file to use, PEM format assumed, in cert file if\n");
	fprintf(stderr,"                 not specified (default is %s)\n",TEST_CERT);
	fprintf(stderr," -CApath arg   - PEM format directory of CA's\n");
	fprintf(stderr," -CAfile arg   - PEM format file of CA's\n");
	}

int main(argc, argv)
int argc;
char *argv[];
	{
	int port=PORT;
	char *CApath=NULL,*CAfile=NULL;
	int badop=0;

	argc--;
	argv++;

	while (argc >= 1)
		{
		if	(strcmp(*argv,"-port") == 0)
			{
			if (argc-- < 1) goto bad;
			port=atoi(*(++argv));
			if (port == 0) goto bad;
			}
		else if	(strcmp(*argv,"-verify") == 0)
			{
			verify=SSL_VERIFY_PEER;
			if (argc-- < 1) goto bad;
			verify_depth=atoi(*(++argv));
			fprintf(stderr,"verify depth is %d\n",verify_depth);
			}
		else if	(strcmp(*argv,"-Verify") == 0)
			{
			verify=SSL_VERIFY_PEER|SSL_VERIFY_FAIL_IF_NO_PEER_CERT;
			if (argc-- < 1) goto bad;
			verify_depth=atoi(*(++argv));
			fprintf(stderr,"verify depth is %d, must return a certificate\n",verify_depth);
			}
		else if	(strcmp(*argv,"-cert") == 0)
			{
			if (argc-- < 1) goto bad;
			cert_file= *(++argv);
			}
		else if	(strcmp(*argv,"-key") == 0)
			{
			if (argc-- < 1) goto bad;
			key_file= *(++argv);
			}
		else if	(strcmp(*argv,"-CApath") == 0)
			{
			if (argc-- < 1) goto bad;
			CApath= *(++argv);
			}
		else if	(strcmp(*argv,"-CAfile") == 0)
			{
			if (argc-- < 1) goto bad;
			CAfile= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		usage();
		exit(1);
		}

	SSL_load_error_strings();

	SSL_debug("server.log");
	if ((!X509_load_verify_locations(CAfile,CApath)) ||
		(!X509_set_default_verify_paths()))
		{
		fprintf(stderr,"X509_load_verify_locations\n");
		ERR_print_error_stack(stderr);
		exit(1);
		}

	fprintf(stderr,"ACCEPT\n");
	do_server(port,NULL,body);
	return(0);
	}

static int body(hostname, s)
char *hostname;
int s;
	{
	unsigned char buf[BUFSIZZ];
	fd_set readfds;
	int width;
	int i;
	SSL *con;
	X509 *peer;
	char *str;

	fprintf(stderr,"CONNECTED\n");
	con=(SSL *)SSL_new();
	SSL_set_fd(con,s);
	SSL_set_verify(con,verify,verify_callback);
	set_cert_stuff(con,cert_file,key_file);
	SSL_set_verify(con,verify,verify_callback);

	if (!SSL_accept(con))
		{
		fprintf(stderr,"ERROR\n");
		if (verify_error != VERIFY_OK)
			{
			fprintf(stderr,"verify error:%s\n",
				X509_verify_error_string(verify_error));
			}
		else
			{
			ERR_print_error_stack(stderr);
			}
		SSL_free(con);
		close(s);
		return(0);
		}
	peer=SSL_get_peer_certificate(con);
	if (peer != NULL)
		{
		printf("Client certificate\n");
		PEM_write_X509(stdout,peer);
		str=X509_oneline_X509_NAME(X509_get_subject_name(peer));
		printf("subject=%s\n",str);
		free(str);
		str=X509_oneline_X509_NAME(X509_get_issuer_name(peer));
		printf("issuer=%s\n",str);
		free(str);
		X509_free(peer);
		}
	printf("CIPHER is %s\n",SSL_get_cipher(con));

	width=s+1;
	for (;;)
		{
		FD_ZERO(&readfds);
		FD_SET(fileno(stdin),&readfds);
		FD_SET(s,&readfds);
		select(width,&readfds,NULL,NULL,NULL);
		if (FD_ISSET(fileno(stdin),&readfds))
			{
			i=read(fileno(stdin),buf,BUFSIZZ);
			if ((i <= 0) || (buf[0] == 'Q'))
				{
				fprintf(stderr,"DONE\n");
				close(s);
				close_accept_socket();
				exit(0);
				}
			SSL_write(con,(char *)buf,(unsigned int)i);
			}
		if (FD_ISSET(s,&readfds))
			{
			i=SSL_read(con,(char *)buf,BUFSIZZ);
			if (i<=0)
				{
				fprintf(stderr,"DONE\n");
				break;
				}
			write(fileno(stdout),buf,(unsigned int)i);
			}
		}
	SSL_free(con);
	fprintf(stderr,"CONNECTION CLOSED\nACCEPT\n");
	return(0);
	}

static void close_accept_socket()
	{
	if (accept_socket >= 0)
		shutdown(accept_socket,2);
	}
