/* tst_clnt.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/time.h> /* Needed under linux for FD_XXX */
#include <netinet/in.h>
#include "net.h"
/*#include "x509.h"*/
/*#include "ssl.h"*/
#include "x509.h"
#include "pem.h"
#include "ssl_locl.h"
#include "ssl_apps.h"

/*#define SSL_HOST_NAME	"www.netscape.com" */
/*#define SSL_HOST_NAME	"193.118.187.102" */
#define SSL_HOST_NAME	"localhost"

/*#define TEST_CERT "client.PEM" */ /* no default cert. */

#define BUFSIZZ	40*1024

int verify_depth=0;
int verify_error=VERIFY_OK;

#ifdef PROTO
static void usage(void);
#else
static void usage();
#endif

static void usage()
	{
	fprintf(stderr,"usage: client args\n");
	fprintf(stderr,"\n");
	fprintf(stderr," -host arg     - host or IP to connect to (default is %s)\n",SSL_HOST_NAME);
	fprintf(stderr," -port arg     - port to connect to (default is %d\n",PORT);
	fprintf(stderr," -verify arg   - turn on peer certificate verification\n");
	fprintf(stderr," -cert arg     - certificate file to use, PEM format assumed\n");
	fprintf(stderr," -key arg      - RSA file to use, PEM format assumed, in cert file if\n");
	fprintf(stderr,"                 not specified but cert fill is.\n");
	fprintf(stderr," -CApath arg   - PEM format directory of CA's\n");
	fprintf(stderr," -CAfile arg   - PEM format file of CA's\n");
	fprintf(stderr," -reconnect     - Drop and re-make the connection with the same Session-ID\n");
	fprintf(stderr," -cipher       - prefered cipher to use, ':' seperated list of the following\n");
	fprintf(stderr,"                 RC4-MD5 EXP-RC4-MD5 CBC-DES-MD5 CBC3-DES-MD5 CBC-IDEA-MD5\n");
	fprintf(stderr,"                 CFB-DES-NULL\n");
	}

int main(argc, argv)
int argc;
char **argv;
	{
	SSL *con,*con2;
	int s,i,width;
	char buf[BUFSIZZ];
	fd_set readfds;
	int port=PORT;
	char *host=SSL_HOST_NAME;
	char *cert_file=NULL,*key_file=NULL;
	char *CApath=NULL,*CAfile=NULL,*cipher=NULL;
	int reconnect=0,badop=0,verify=SSL_VERIFY_NONE;
	X509 *peer;

	argc--;
	argv++;
	while (argc >= 1)
		{
		if	(strcmp(*argv,"-host") == 0)
			{
			if (argc-- < 1) goto bad;
			host= *(++argv);
			}
		else if	(strcmp(*argv,"-port") == 0)
			{
			if (argc-- < 1) goto bad;
			port=atoi(*(++argv));
			if (port == 0) goto bad;
			}
		else if	(strcmp(*argv,"-verify") == 0)
			{
			verify=SSL_VERIFY_PEER;
			if (argc-- < 1) goto bad;
			verify_depth=atoi(*(++argv));
			fprintf(stderr,"verify depth is %d\n",verify_depth);
			}
		else if	(strcmp(*argv,"-cert") == 0)
			{
			if (argc-- < 1) goto bad;
			cert_file= *(++argv);
			}
		else if	(strcmp(*argv,"-key") == 0)
			{
			if (argc-- < 1) goto bad;
			key_file= *(++argv);
			}
		else if	(strcmp(*argv,"-reconnect") == 0)
			{
			reconnect=1;
			}
		else if	(strcmp(*argv,"-CApath") == 0)
			{
			if (argc-- < 1) goto bad;
			CApath= *(++argv);
			}
		else if	(strcmp(*argv,"-CAfile") == 0)
			{
			if (argc-- < 1) goto bad;
			CAfile= *(++argv);
			}
		else if	(strcmp(*argv,"-cipher") == 0)
			{
			if (argc-- < 1) goto bad;
			cipher= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		usage();
		exit(1);
		}

	SSL_load_error_strings();

	if ((!X509_load_verify_locations(CAfile,CApath)) ||
		(!X509_set_default_verify_paths()))
		{
		fprintf(stderr,"error seting default verify locations\n");
		ERR_print_error_stack(stderr);
		exit(1);
		}

	if (init_client(&s,host,port) == 0)
		{ perror("conecting"); exit(1); }
	fprintf(stderr,"CONNECTED\n");

	con=(SSL *)SSL_new();
	SSL_set_fd(con,s);
	SSL_set_verify(con,verify,verify_callback);

	if (cipher == NULL)
		SSL_set_pref_cipher(con,getenv("SSL_CIPHER"));
	else
		SSL_set_pref_cipher(con,cipher);

	set_cert_stuff(con,cert_file,key_file);

	if (!SSL_connect(con))
		{
		fprintf(stderr,"ERROR\n");
		if (verify_error != VERIFY_OK)
			{
			fprintf(stderr,"verify error:%s\n",
				X509_verify_error_string(verify_error));
			}
		else
			{
			ERR_print_error_stack(stderr);
			}
		close(s);
		exit(1);
		}

	if (reconnect)
		{
		SSL_write(con,"bye\n",4);
		close(s); 

		if (init_client(&s,host,port) == 0)
			{ perror("conecting"); exit(1); }

		fprintf(stderr,"drop the connection and reconnect with the same session id\n");
		/* test a second connection */
		/* NOTE: It is a new SSL structure so we need to set the
		 * certificate and private key for this SSL structure */
		con2=SSL_new();
		SSL_set_fd(con2,s);
		SSL_copy_session_id(con2,con);
		set_cert_stuff(con2,cert_file,key_file);

		if (!SSL_connect(con2))
			{
			fprintf(stderr,"SSL error\n");
			if (verify_error != VERIFY_OK)
				{
				fprintf(stderr,"\tpeer cert verify failure\n");
				fprintf(stderr,"\t%s\n",
					X509_verify_error_string(verify_error));
				}
			else
				{
				ERR_print_error_stack(stderr);
				}
			SSL_free(con2);
			close(s);
			exit(1);
			}
		SSL_free(con);
		con=con2;
		}
	width=s+1;

	peer=SSL_get_peer_certificate(con);
	if (peer != NULL)
		{
		char *str;

		printf("Server certificate\n");
		PEM_write_X509(stdout,peer);
		str=X509_oneline_X509_NAME(X509_get_subject_name(peer));
		printf("subject=%s\n",str);
		free(str);
		str=X509_oneline_X509_NAME(X509_get_issuer_name(peer));
		printf("issuer=%s\n",str);
		free(str);
		X509_free(peer);
		}

	/* THE FOLLOWING IS EVIL CODE THAT SHOULD NOT BE USED
	 * but as author I reserve the right to do until I put a
	 * nicer interface in the library - eay :-). */
	{
	CIPHER **c;
	int i=0;

	c= &(con->conn->ciphers[0]);
	printf("Ciphers common between both SSL endpoints:\n");
	while (c[i] != NULL)
		{
		printf("%-12s%s",c[i]->name,((i+1) % 3)?" ":"\n");
		i++;
		}
	if ((i) % 3) printf("\n");
	}

	printf("Cipher is %s\n",SSL_get_cipher(con));

	for (;;)
		{
		FD_ZERO(&readfds);
		FD_SET(fileno(stdin),&readfds);
		FD_SET(s,&readfds);
		select(width,&readfds,NULL,NULL,NULL);
		if (FD_ISSET(fileno(stdin),&readfds))
			{
			i=read(fileno(stdin),buf,BUFSIZZ);
			if ((i <= 0) || (buf[0] == 'Q'))
				{
				fprintf(stderr,"DONE\n");
				close(s);
				exit(0);
				}
			SSL_write(con,buf,(unsigned int)i);
			}
		if (FD_ISSET(s,&readfds))
			{
			i=SSL_read(con,buf,BUFSIZZ);
			if (i<=0)
				{
				fprintf(stderr,"DONE\n");
				break;
				}
			write(fileno(stdout),buf,(unsigned int)i);
			}
		}
	return(0);
	}


