/* x509_sign.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "crypto.h"
#include "der.h"
#include "bn.h"
#include "x509.h"
#include "x509_obj.h"
#include "buffer.h"
#include "pem.h"

int X509_sign(x, rsa, type)
X509 *x;
RSA *rsa;
int type;
	{
	unsigned char *p,*buf_in,*buf_out;
	int inl,outl;
	PEM_CTX ctx;

	inl=i2D_X509_CINF(x->cert_info,NULL);
	buf_in=malloc((unsigned int)inl);
	outl=RSA_size(rsa);
	buf_out=malloc((unsigned int)outl);
	if ((buf_in == NULL) || (buf_out == NULL))
		{ X509err(X509_F_X509_SIGN,ERR_R_MALLOC_FAILURE); return(0); }
	p=buf_in;
	i2D_X509_CINF(x->cert_info,&p);
	if (	(!PEM_SignInit(&ctx,type)) ||
		(!PEM_SignUpdate(&ctx,(unsigned char *)buf_in,inl)) ||
		(!PEM_SignFinal(&ctx,(unsigned char *)buf_out,
			(unsigned int *)&outl,rsa)))
		{ X509err(X509_F_X509_SIGN,ERR_R_PEM_LIB); return(0); }

	x->sig_alg->parameters->length=0;
	DER_OBJECT_free(x->sig_alg->algorithm);
	x->sig_alg->algorithm=X509_dup_DER_OBJECT(X509_nid2obj(type));
	if (x->sig_alg->algorithm == NULL) return(0);
		
	if (x->signature->data != NULL) free(x->signature->data);
	x->signature->data=buf_out;
	x->signature->length=outl;
	memset(buf_in,0,(unsigned int)inl);
	return(outl);
	}
