/* x509_req.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>

#include "crypto.h"
#include "bn.h"
#include "der.h"
#include "x509.h"
#include "x509_obj.h"
#include "buffer.h"
#include "pem.h"

X509_REQ *X509_X509_TO_req(x,rsa)
X509 *x;
RSA *rsa;
	{
	X509_REQ *ret;
	X509_REQ_INFO *ri;
	int i;
	unsigned char *s,*p;

	ret=X509_REQ_new();

	ri=ret->req_info;

	ri->version->length=1;
	ri->version->data=(unsigned char *)malloc(1);
	if (ri->version->data == NULL) goto err;
	ri->version->data[0]=0; /* version == 0 */

	ri->subject=X509_NAME_dup(x->cert_info->subject);
	if (ri->subject == NULL) return(0);

	DER_OBJECT_free(ri->pubkey->algor->algorithm);
	ri->pubkey->algor->algorithm=
		X509_dup_DER_OBJECT(X509_nid2obj(NID_rsaEncryption));
	if (ri->pubkey->algor->algorithm == NULL) return(0);

	i=i2D_RSAPublicKey(rsa,NULL);
	s=(unsigned char *)malloc((unsigned int)i+1);
	if (s == NULL) goto err;
	p=s;
	i2D_RSAPublicKey(rsa,&p);
	ri->pubkey->public_key->length=i;
	ri->pubkey->public_key->data=s;

	if (!X509_REQ_sign(ret,rsa,PEM_MD_MD5_RSA)) return(0);
	return(ret);
err:
	X509err(X509_F_X509_X509_TO_REQ,ERR_R_MALLOC_FAILURE);
	return(0);
	}

int X509_REQ_sign(x, rsa, type)
X509_REQ *x;
RSA *rsa;
int type;
	{
	PEM_CTX ctx;
	unsigned char *p,*buf_in,*buf_out;
	int inl,outl;

	inl=i2D_X509_REQ_INFO(x->req_info,NULL);
	buf_in=malloc((unsigned int)inl);
	outl=RSA_size(rsa);
	buf_out=malloc((unsigned int)outl);
	if ((buf_in == NULL) || (buf_out == NULL))
		{
		X509err(X509_F_X509_REQ_SIGN,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	p=buf_in;
	i2D_X509_REQ_INFO(x->req_info,&p);
	if (	(!PEM_SignInit(&ctx,type)) ||
		(!PEM_SignUpdate(&ctx,(unsigned char *)buf_in,inl)) ||
		(!PEM_SignFinal(&ctx,(unsigned char *)buf_out,
		(unsigned int *)&outl,rsa)))
		{
		X509err(X509_F_X509_REQ_SIGN,ERR_R_PEM_LIB);
		free(buf_out);
		return(0);
		}

	x->sig_alg->parameters->length=0;
	DER_OBJECT_free(x->sig_alg->algorithm);
	x->sig_alg->algorithm=X509_dup_DER_OBJECT(X509_nid2obj(type));
	if (x->sig_alg->algorithm == NULL) return(0);
		
	if (x->signature->data != NULL) free(x->signature->data);
	x->signature->data=buf_out;
	x->signature->length=outl;
	memset(buf_in,0,(unsigned int)inl);
	return(outl);
	}

void X509_REQ_print(fp,x)
FILE *fp;
X509_REQ *x;
	{
	unsigned long l;
	int i,n;
	char *s,*p;
	X509_REQ_INFO *ri;
	RSA *rsa;

	ri=x->req_info;
	Fprintf(fp,"Certificate Request:\n");
	Fprintf(fp,"%4sData:\n","");
	for (l=i=0; i<ri->version->length; i++)
		{ l<<=8; l+=ri->version->data[i]; }
	Fprintf(fp,"%8sVersion: %ld (0x%lx)\n","",l,l);
	Fprintf(fp,"%8sSubject: ","");
	p=s=X509_oneline_X509_NAME(ri->subject);
	s++; /* skip the first slash */
	for (; *s; s++)
		{
		if (*s == '/')
			{
			Fputc(',',fp);
			Fputc(' ',fp);
			}
		else
			Fputc(*s,fp);
		}
	Fputc('\n',fp);
	free(p);
	Fprintf(fp,"%8sSubject Public Key Info:\n","");
	i=X509_obj2nid(ri->pubkey->algor->algorithm);
	Fprintf(fp,"%12sPublic Key Algorithm: %s\n","",X509_nid2ln(i));
	Fprintf(fp,"%12sPublic Key:\n","");
	Fprintf(fp,"%16sModulus:","");

	rsa=RSA_new();
	s=(char *)ri->pubkey->public_key->data;
	D2i_RSAPublicKey(rsa,(unsigned char **)&s);
	i=RSA_size(rsa);
	s=(char *)malloc((unsigned int)i+10);
	n=bn_bn2bin(rsa->n,(unsigned char *)s);
	
	for (i=0; i<n; i++)
		{
		if ((i%15) == 0) Fprintf(fp,"\n%20s","");
		Fprintf(fp,"%02x%s",(unsigned char)s[i],((i+1) == n)?"":":");
		}
	Fputc('\n',fp);
	l=rsa->e->d[0];
	Fprintf(fp,"%16sExponent: %ld (0x%lx)\n","",l,l);
	RSA_free(rsa);

	Fprintf(fp,"%8sAttributes:\n","");
	Fprintf(fp,"%12sa0:00\n","");

	i=X509_obj2nid(x->sig_alg->algorithm);
	Fprintf(fp,"%4sSignature Algorithm: %s","",X509_nid2ln(i));

	for (i=0; i<n; i++)
		{
		if ((i%18) == 0) Fprintf(fp,"\n%8s","");
		Fprintf(fp,"%02x%s",(unsigned char)s[i],((i+1) == n)?"":":");
		}
	Fputc('\n',fp);
	}
