/* x509_lib.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "x509.h"

char *X509_version="\0X509 part of SSLeay v 0.4.4 17/07/95";

int DER_OBJECT_eq(a, b)
DER_OBJECT *a;
DER_OBJECT *b;
	{
	int i;

	if (a->num != b->num) return(0);
	for (i=a->num-1; i>=0; i--)
		if (a->values[i] != a->values[i]) return(0);
	a->nid=0;
	return(1);
	}

DER_BIT_STRING *DER_BIT_STRING_new()
	{
	DER_BIT_STRING *ret;

	ret=(DER_BIT_STRING *)malloc(sizeof(DER_BIT_STRING));
	if (ret == NULL)
		{
		DERerr(DER_F_DER_BIT_STRING_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->length=0;
	ret->data=NULL;
	return(ret);
	}

DER_OBJECT *DER_OBJECT_new()
	{
	DER_OBJECT *ret;

	ret=(DER_OBJECT *)malloc(sizeof(DER_OBJECT));
	if (ret == NULL)
		{
		DERerr(DER_F_DER_OBJECT_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->num=0;
	ret->values=NULL;
	ret->nid=0;
	ret->sn=NULL;
	ret->ln=NULL;
	return(ret);
	}

X509_ALGOR *X509_ALGOR_new()
	{
	X509_ALGOR *ret;

	ret=(X509_ALGOR *)malloc(sizeof(X509_ALGOR));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_ALGOR_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->algorithm=DER_OBJECT_new()) == NULL) return(NULL);
	if ((ret->parameters=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_NAME *X509_NAME_new()
	{
	X509_NAME *ret;

	ret=(X509_NAME *)malloc(sizeof(X509_NAME));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_NAME_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->num=0;
	ret->values=NULL;
	ret->types=NULL;
	ret->objects=NULL;
	return(ret);
	}

X509_VAL *X509_VAL_new()
	{
	X509_VAL *ret;

	ret=(X509_VAL *)malloc(sizeof(X509_VAL));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_VAL_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->notBefore=NULL;
	ret->notAfter=NULL;
	return(ret);
	}

X509_PUBKEY *X509_PUBKEY_new()
	{
	X509_PUBKEY *ret;

	ret=(X509_PUBKEY *)malloc(sizeof(X509_PUBKEY));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_PUBKEY_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->algor=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->public_key=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_SIG *X509_SIG_new()
	{
	X509_SIG *ret;

	ret=(X509_SIG *)malloc(sizeof(X509_SIG));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_SIG_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->algor=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->digest=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_CINF *X509_CINF_new()
	{
	X509_CINF *ret;

	ret=(X509_CINF *)malloc(sizeof(X509_CINF));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_CINF_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
/*	ret->version=0;*/
	if ((ret->serialNumber=DER_BIT_STRING_new()) == NULL) return(NULL);
	if ((ret->signature=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->issuer=X509_NAME_new()) == NULL) return(NULL);
	if ((ret->validity=X509_VAL_new()) == NULL) return(NULL);
	if ((ret->subject=X509_NAME_new()) == NULL) return(NULL);
	if ((ret->key=X509_PUBKEY_new()) == NULL) return(NULL);
	return(ret);
	}

X509_REVOKED *X509_REVOKED_new()
	{
	X509_REVOKED *ret;

	ret=(X509_REVOKED *)malloc(sizeof(X509_REVOKED));
	if (ret == NULL)
		{
		DERerr(X509_F_X509_REVOKED_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->serialNumber=DER_BIT_STRING_new()) == NULL) return(NULL);
	ret->revocationDate=NULL;
	return(ret);
	}

X509_CRL_INFO *X509_CRL_INFO_new()
	{
	X509_CRL_INFO *ret;

	ret=(X509_CRL_INFO *)malloc(sizeof(X509_CRL_INFO));
	if (ret == NULL)
		{
		X509err(X509_F_X509_CRL_INFO_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}

	if ((ret->sig_alg=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->issuer=X509_NAME_new()) == NULL) return(NULL);
	ret->lastUpdate=NULL;
	ret->nextUpdate=NULL;
	ret->num=0;
	ret->revoked=NULL;
	return(ret);
	}

X509_CRL *X509_CRL_new()
	{
	X509_CRL *ret;

	ret=(X509_CRL *)malloc(sizeof(X509_CRL));
	if (ret == NULL)
		{
		X509err(X509_F_X509_CRL_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}

	if ((ret->crl=X509_CRL_INFO_new()) == NULL) return(NULL);
	if ((ret->sig_alg=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->signature=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509 *X509_new()
	{
	X509 *ret;

	ret=(X509 *)malloc(sizeof(X509));
	if (ret == NULL)
		{ X509err(X509_F_X509_NEW,ERR_R_MALLOC_FAILURE); return(NULL); }

	if ((ret->cert_info=X509_CINF_new()) == NULL) return(NULL);
	if ((ret->sig_alg=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->signature=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_REQ_INFO *X509_REQ_INFO_new()
	{
	X509_REQ_INFO *ret;

	ret=(X509_REQ_INFO *)malloc(sizeof(X509_REQ_INFO));
	if (ret == NULL)
		{ 
		X509err(X509_F_X509_REQ_INFO,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->version=DER_BIT_STRING_new()) == NULL) return(NULL);
	if ((ret->subject=X509_NAME_new()) == NULL) return(NULL);
	if ((ret->pubkey=X509_PUBKEY_new()) == NULL) return(NULL);
	return(ret);
	}

X509_REQ *X509_REQ_new()
	{
	X509_REQ *ret;

	ret=(X509_REQ *)malloc(sizeof(X509_REQ));
	if (ret == NULL)
		{ 
		X509err(X509_F_X509_REQ,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if ((ret->req_info=X509_REQ_INFO_new()) == NULL) return(NULL);
	if ((ret->sig_alg=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->signature=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

void DER_BIT_STRING_free(a)
DER_BIT_STRING *a;
	{
	if (a->data != NULL) free(a->data);
	free(a);
	}

void DER_OBJECT_free(a)
DER_OBJECT *a;
	{
	if (a->values != NULL) free(a->values);
	free(a);
	}

void X509_ALGOR_free(a)
X509_ALGOR *a;
	{
	DER_OBJECT_free(a->algorithm);
	DER_BIT_STRING_free(a->parameters);
	free(a);
	}

void X509_NAME_free(a)
X509_NAME *a;
	{
	int i;

	for (i=0; i<a->num; i++)
		{
		if (a->objects[i] != NULL) DER_OBJECT_free(a->objects[i]);
		if (a->values[i] != NULL) DER_BIT_STRING_free(a->values[i]);
		}
	if (a->objects != NULL) free(a->objects);
	if (a->types != NULL) free(a->types);
	if (a->values != NULL) free(a->values);
	free(a);
	}

void X509_VAL_free(a)
X509_VAL *a;
	{
	if (a->notBefore != NULL) free(a->notBefore);
	if (a->notAfter != NULL) free(a->notAfter);
	free(a);
	}

void X509_PUBKEY_free(a)
X509_PUBKEY *a;
	{
	X509_ALGOR_free(a->algor);
	if (a->public_key != NULL) DER_BIT_STRING_free(a->public_key);
	free(a);
	}

void X509_SIG_free(a)
X509_SIG *a;
	{
	X509_ALGOR_free(a->algor);
	if (a->digest != NULL) DER_BIT_STRING_free(a->digest);
	free(a);
	}

void X509_CINF_free(a)
X509_CINF *a;
	{
	X509_ALGOR_free(a->signature);
	X509_NAME_free(a->issuer);
	X509_VAL_free(a->validity);
	X509_NAME_free(a->subject);
	X509_PUBKEY_free(a->key);
	free(a);
	}

void X509_REVOKED_free(a)
X509_REVOKED *a;
	{
	DER_BIT_STRING_free(a->serialNumber);
	if (a->revocationDate != NULL) free(a->revocationDate);
	free(a);
	}

void X509_CRL_INFO_free(a)
X509_CRL_INFO *a;
	{
	unsigned int i;

	X509_ALGOR_free(a->sig_alg);
	X509_NAME_free(a->issuer);
	if (a->lastUpdate != NULL) free(a->lastUpdate);
	if (a->nextUpdate != NULL) free(a->nextUpdate);
	for (i=0; i<a->num; i++)
		X509_REVOKED_free(a->revoked[i]);
	if (a->revoked != NULL) free(a->revoked);
	free(a);
	}

void X509_CRL_free(a)
X509_CRL *a;
	{
	X509_CRL_INFO_free(a->crl);
	X509_ALGOR_free(a->sig_alg);
	DER_BIT_STRING_free(a->signature);
	free(a);
	}

void X509_free(a)
X509 *a;
	{
	X509_CINF_free(a->cert_info);
	X509_ALGOR_free(a->sig_alg);
	DER_BIT_STRING_free(a->signature);
	free(a);
	}

void X509_REQ_INFO_free(a)
X509_REQ_INFO *a;
	{
	DER_BIT_STRING_free(a->version);
	X509_NAME_free(a->subject);
	X509_PUBKEY_free(a->pubkey);
	free(a);
	}

void X509_REQ_free(a)
X509_REQ *a;
	{
	X509_REQ_INFO_free(a->req_info);
	X509_ALGOR_free(a->sig_alg);
	DER_BIT_STRING_free(a->signature);
	free(a);
	}

/* ugly but the easiest way I could think of duplicated the structure.  */
X509 *X509_dup(x)
X509 *x;
	{
	unsigned char *b,*p;
	int i;
	X509 *ret;

	i=i2D_X509(x,NULL);
	b=(unsigned char *)malloc((unsigned int)i+10);
	if (b == NULL)
		{ X509err(X509_F_X509_DUP,ERR_R_MALLOC_FAILURE); return(NULL); }
	p= b;
	i2D_X509(x,&p);
	ret=X509_new_D2i_X509(i,b);
	free(b);
	return(ret);
	}

X509_NAME *X509_NAME_dup(n)
X509_NAME *n;
	{
	unsigned char *b,*p;
	int i;
	X509_NAME *ret;

	i=i2D_X509_NAME(n,NULL);
	b=(unsigned char *)malloc((unsigned int)i+10);
	if (b == NULL)
		{
		X509err(X509_F_X509_NAME_DUP,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	p= b;
	i2D_X509_NAME(n,&p);
	ret=(X509_NAME *)X509_NAME_new();
	if (ret == NULL) return(NULL);

	p= b;
	if (!D2i_X509_NAME(ret,&p))
		{
		X509_NAME_free(ret);
		X509err(X509_F_X509_NAME_DUP,ERR_R_DER_LIB);
		return(NULL);
		}

	free(b);
	return(ret);
	}

X509 *X509_new_D2i_X509(len, p)
int len;
unsigned char *p;
	{
	X509 *x;

	x=(X509 *)X509_new();
	if (x == NULL)
		{
		X509err(X509_F_X509_NEW_D2i_X509,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	if (!D2i_X509(x,len,p))
		{
		X509_free(x);
		X509err(X509_F_X509_NEW_D2i_X509,ERR_R_DER_LIB);
		return(NULL);
		}
	return(x);
	}
