/* x509_i2f.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "bn.h"
#include "buffer.h"
#include "x509.h"

void i2f_X509_ALGOR(fp, a)
FILE *fp;
X509_ALGOR *a;
	{
	Fprintf(fp,"%s\n",STRING_ALGORITHMIDENTIFIER_BEGIN);
	i2f_DER_OBJECT(fp,a->algorithm);
	i2f_DER_BIT_STRING(fp,a->parameters);
	Fprintf(fp,"%s\n",STRING_ALGORITHMIDENTIFIER_END);
	}

void i2f_X509_NAME(fp, a)
FILE *fp;
X509_NAME *a;
	{
	int i;

	Fprintf(fp,"%s\n",STRING_NAME_BEGIN);
	for (i=0; i<a->num; i++)
		{
		i2f_DER_OBJECT(fp,a->objects[i]);
		Fprintf(fp,"%c %s\n",(((i+1) == a->num)?'-':'='),
			a->values[i]->data);
		}
	Fprintf(fp,"%s\n",STRING_NAME_END);
	}

void i2f_X509_VAL(fp, a)
FILE *fp;
X509_VAL *a;
	{
	Fprintf(fp,"%s\n",STRING_VALIDITY_BEGIN);
	Fprintf(fp,"= %s\n",(a->notBefore != NULL)?a->notBefore:"");
	Fprintf(fp,"= %s\n",(a->notAfter != NULL)?a->notAfter:"");
	Fprintf(fp,"%s\n",STRING_VALIDITY_END);
	}

void i2f_X509_PUBKEY(fp, a)
FILE *fp;
X509_PUBKEY *a;
	{
	Fprintf(fp,"%s\n",STRING_SUBJECTPUBLICKEYINFO_BEGIN);
	i2f_X509_ALGOR(fp,a->algor);
	i2f_DER_BIT_STRING(fp,a->public_key);
	Fprintf(fp,"%s\n",STRING_SUBJECTPUBLICKEYINFO_END);
	}

void i2f_X509_SIG(fp, a)
FILE *fp;
X509_SIG *a;
	{
	Fprintf(fp,"%s\n",STRING_SIGNATURE_BEGIN);
	i2f_X509_ALGOR(fp,a->algor);
	i2f_DER_BIT_STRING(fp,a->digest);
	Fprintf(fp,"%s\n",STRING_SIGNATURE_END);
	}

void i2f_X509_CINF(fp, a)
FILE *fp;
X509_CINF *a;
	{
	Fprintf(fp,"%s\n",STRING_CERTIFICATE_BEGIN);
/*	Fprintf(fp,"= %ld\n",a->version); */
	i2f_DER_BIT_STRING(fp,a->serialNumber);
	i2f_X509_ALGOR(fp,a->signature);
	i2f_X509_NAME(fp,a->issuer);
	i2f_X509_VAL(fp,a->validity);
	i2f_X509_NAME(fp,a->subject);
	i2f_X509_PUBKEY(fp,a->key);
	Fprintf(fp,"%s\n",STRING_CERTIFICATE_END);
	}

void i2f_X509_CRL_INFO(fp, a)
FILE *fp;
X509_CRL_INFO *a;
	{
	int i;

	Fprintf(fp,"%s\n",STRING_CRL_INFO_BEGIN);
	i2f_X509_ALGOR(fp,a->sig_alg);
	i2f_X509_NAME(fp,a->issuer);
	Fprintf(fp,"= %s\n",(a->lastUpdate != NULL)?a->lastUpdate:"");
	Fprintf(fp,"= %s\n",(a->nextUpdate != NULL)?a->nextUpdate:"");
	for (i=0; i<a->num; i++)
		{
		i2f_DER_BIT_STRING(fp,a->revoked[i]->serialNumber);
		Fprintf(fp,"%c %s\n",
			(i+1 == a->num)?'-':'=',
			(a->revoked[i]->revocationDate != NULL)?
			 a->revoked[i]->revocationDate:"");
		}
	Fprintf(fp,"%s\n",STRING_CRL_INFO_END);
	}

void i2f_X509_CRL(fp, a)
FILE *fp;
X509_CRL *a;
	{
	Fprintf(fp,"%s\n",STRING_CRL_BEGIN);
	i2f_X509_CRL_INFO(fp,a->crl);
	i2f_X509_ALGOR(fp,a->sig_alg);
	i2f_DER_BIT_STRING(fp,a->signature);
	Fprintf(fp,"%s\n",STRING_CRL_END);
	}

void i2f_X509(fp, a)
FILE *fp;
X509 *a;
	{
	Fprintf(fp,"%s\n",STRING_X509_CERTIFICATE_BEGIN);
	i2f_X509_CINF(fp,a->cert_info);
	i2f_X509_ALGOR(fp,a->sig_alg);
	i2f_DER_BIT_STRING(fp,a->signature);
	Fprintf(fp,"%s\n",STRING_X509_CERTIFICATE_END);
	}

int i2f_RSAPrivateKey(fp, rsa)
FILE *fp;
RSA *rsa;
	{
	int btos,n=RSA_size(rsa)+2,i;
	BUFFER *b;
	DER_BIT_STRING bs;
	BIGNUM *nums[9];

	btos=buffer_get_tos();
	b=buffer_get_buf();
	if (b == NULL)
		{
		DERerr(DER_F_I2F_RSAPRIVATEKEY,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	if (!buffer_grow(b,n))
		{
		DERerr(DER_F_I2F_RSAPRIVATEKEY,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	
	nums[0]=NULL;
	nums[1]=rsa->n;
	nums[2]=rsa->e;
	nums[3]=rsa->d;
	nums[4]=rsa->p;
	nums[5]=rsa->q;
	nums[6]=rsa->dmp1;
	nums[7]=rsa->dmq1;
	nums[8]=rsa->iqmp;
	bs.data=(unsigned char *)b->data;
	Fprintf(fp,"%s\n",STRING_RSAPRIVATEKEY_BEGIN);
	for (i=0; i<=8; i++)
		{
		if (nums[i] == NULL)
			{
			bs.length=1;
			b->data[0]=0;
			}
		else
			bs.length=bn_bn2bin(nums[i],
				(unsigned char *)b->data);
		i2f_DER_BIT_STRING(fp,&bs);
		}
	Fprintf(fp,"%s\n",STRING_RSAPRIVATEKEY_END);
	buffer_set_tos(btos);
	return(1);
	}

int i2f_RSAPublicKey(fp, rsa)
FILE *fp;
RSA *rsa;
	{
	int btos,n=RSA_size(rsa)+2,i;
	BUFFER *b;
	DER_BIT_STRING bs;
	BIGNUM *nums[2];

	btos=buffer_get_tos();
	b=buffer_get_buf();
	if (b == NULL)
		{
		DERerr(DER_F_I2F_RSAPUBLICKEY,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	if (!buffer_grow(b,n*2))
		{
		DERerr(DER_F_I2F_RSAPUBLICKEY,ERR_R_MALLOC_FAILURE);
		goto err;
		}

	nums[0]=rsa->n;
	nums[1]=rsa->e;
	bs.data=(unsigned char *)b->data;
	Fprintf(fp,"%s\n",STRING_RSAPUBLICKEY_BEGIN);
	for (i=0; i<=1; i++)
		{
		if (nums[i] == NULL)
			{
			bs.length=1;
			b->data[0]=0;
			}
		else
			bs.length=bn_bn2bin(nums[i],
				(unsigned char *)b->data);
		i2f_DER_BIT_STRING(fp,&bs);
		}
	Fprintf(fp,"%s\n",STRING_RSAPUBLICKEY_END);
	buffer_set_tos(btos);
	return(1);
err:
	buffer_set_tos(btos);
	return(0);
	}
