/* x509_i2d.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "bn.h"
#include "buffer.h"
#include "x509.h"

int i2D_X509_ALGOR(a, pp)
X509_ALGOR *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret=i2D_DER_OBJECT(a->algorithm,NULL);
	if (a->parameters->length != 0)
		ret+=i2D_DER_BIT_STRING(a->parameters,NULL);
	else
		ret+=DER_object_size(0,(int)0,DER_NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;
	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_DER_OBJECT(a->algorithm,&p);
	if (a->parameters->length != 0)
		i2D_DER_BIT_STRING(a->parameters,&p);
	else
		DER_put_object(&p,0,0,DER_NULL,DER_UNIVERSAL);
	*pp=p;
	return(r);
	}

int i2D_X509_NAME(a, pp)
X509_NAME *a;
unsigned char **pp;
	{
	int set,ret,i,j,k,z,rr,r,n[4];
	unsigned char *p;

	ret=rr=0;
	for (i=0; i<a->num; i++)
		{
		r=i2D_DER_OBJECT(a->objects[i],NULL);
		j=a->values[i]->length;
		r+=DER_object_size(0,j,a->types[i]&0xff);
		rr+=DER_object_size(1,r,DER_SEQUENCE);
		z=a->types[i]>>8;
		if (((i+1) == a->num) || (z != (a->types[i+1]>>8)))
			{
			ret+=DER_object_size(1,rr,DER_SET);
			rr=0;
			}
		}
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;
	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	for (i=0; i<a->num; )
		{
		n[3]=0;
		set=a->types[i]>>8;
		for (j=i; j<a->num; j++)
			{
			if (set != (a->types[j]>>8)) break;
			n[0]=i2D_DER_OBJECT(a->objects[j],NULL);
			n[1]=a->values[j]->length;
			n[2]=DER_object_size(0,n[1],a->types[j]&0xff);
			n[3]+=DER_object_size(0,n[0]+n[2],DER_SEQUENCE);
			}

		DER_put_object(&p,1,n[3],DER_SET,DER_UNIVERSAL);
		for (k=i; k<j; k++)
			{
			n[0]=i2D_DER_OBJECT(a->objects[k],NULL);
			n[1]=a->values[k]->length;
			n[2]=DER_object_size(0,n[1],a->types[k]&0xff);
			DER_put_object(&p,1,n[0]+n[2],
				DER_SEQUENCE,DER_UNIVERSAL);
			i2D_DER_OBJECT(a->objects[k],&p);
			DER_put_object(&p,0,n[1],a->types[k]&0xff,
				DER_UNIVERSAL);
			memcpy(p,a->values[k]->data,(unsigned int)n[1]);
			p+=n[1];
			i++;
			}
		}
	*pp=p;
	return(r);
	}

int i2D_X509_VAL(a, pp)
X509_VAL *a;
unsigned char **pp;
	{
	int ret,r;
	unsigned char *p;

	ret =i2D_UTCTime(a->notBefore,NULL);
	ret+=i2D_UTCTime(a->notAfter,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;
	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_UTCTime(a->notBefore,&p);
	i2D_UTCTime(a->notAfter,&p);
	*pp=p;
	return(r);
	}

int i2D_X509_PUBKEY(a, pp)
X509_PUBKEY *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret=i2D_X509_ALGOR(a->algor,NULL);
	ret+=i2D_DER_BIT_STRING(a->public_key,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_ALGOR(a->algor,&p);
	i2D_DER_BIT_STRING(a->public_key,&p);
	*pp=p;
	return(r);
	}

int i2D_X509_SIG(a, pp)
X509_SIG *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret=i2D_X509_ALGOR(a->algor,NULL);
	ret+=i2D_OCTET_STRING(a->digest,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_ALGOR(a->algor,&p);
	i2D_OCTET_STRING(a->digest,&p);
	*pp=p;
	return(r);
	}

int i2D_X509_REVOKED(a, pp)
X509_REVOKED *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret =i2D_INTEGER(a->serialNumber,NULL);
	ret+=i2D_UTCTime(a->revocationDate,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);

	p= *pp;
	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_INTEGER(a->serialNumber,&p);
	i2D_UTCTime(a->revocationDate,&p);
	r=DER_object_size(1,ret,DER_SEQUENCE);

	*pp=p;
	return(r);
	}

int i2D_X509_CRL_INFO(a, pp)
X509_CRL_INFO *a;
unsigned char **pp;
	{
	int r,ret0,ret1;
	unsigned char *p;
	int i;

	ret1 =i2D_X509_ALGOR(a->sig_alg,NULL);
	ret1+=i2D_X509_NAME(a->issuer,NULL);
	ret1+=i2D_UTCTime(a->lastUpdate,NULL);
	ret1+=i2D_UTCTime(a->nextUpdate,NULL);
	ret0=0;
	for (i=0; i<a->num; i++)
		ret0+=i2D_X509_REVOKED(a->revoked[i],NULL);
	ret1+=DER_object_size(1,ret0,DER_SEQUENCE);
	r=DER_object_size(1,ret1,DER_SEQUENCE);
	if (pp == NULL) return(r);

	p= *pp;
	DER_put_object(&p,1,ret1,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_ALGOR(a->sig_alg,&p);
	i2D_X509_NAME(a->issuer,&p);
	i2D_UTCTime(a->lastUpdate,&p);
	i2D_UTCTime(a->nextUpdate,&p);
	DER_put_object(&p,1,ret0,DER_SEQUENCE,DER_UNIVERSAL);
	for (i=0; i<a->num; i++)
		i2D_X509_REVOKED(a->revoked[i],&p);
	*pp=p;
	return(r);
	}

int i2D_X509_CRL(a, pp)
X509_CRL *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret =i2D_X509_CRL_INFO(a->crl,NULL);
	ret+=i2D_X509_ALGOR(a->sig_alg,NULL);
	ret+=i2D_DER_BIT_STRING(a->signature,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);

	p= *pp;
	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_CRL_INFO(a->crl,&p);
	i2D_X509_ALGOR(a->sig_alg,&p);
	i2D_DER_BIT_STRING(a->signature,&p);

	*pp=p;
	return(r);
	}

int i2D_X509_CRL_fp(fp, a)
FILE *fp;
X509_CRL *a;
	{
	int btos,r,ret;
	unsigned char *p;
	BUFFER *b;

	btos=buffer_get_tos();
	b=buffer_get_buf();
	if (b == NULL)
		{
		DERerr(DER_F_I2D_X509_CRL_FP,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	
	r=i2D_X509_CRL(a,NULL);
	if (!buffer_grow(b,r))
		{
		DERerr(DER_F_I2D_X509_CRL_FP,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	p=(unsigned char *)b->data;
	r=i2D_X509_CRL(a,&p);
	ret=fwrite(b->data,(unsigned int)r,1,fp);
	buffer_set_tos(btos);
	return(ret);
err:
	buffer_set_tos(btos);
	return(0);
	}

int i2D_X509_CINF(a, pp)
X509_CINF *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

/*	ret =i2D_INTEGER(a->version,NULL); */
	ret =i2D_INTEGER(a->serialNumber,NULL);
	ret+=i2D_X509_ALGOR(a->signature,NULL);
	ret+=i2D_X509_NAME(a->issuer,NULL);
	ret+=i2D_X509_VAL(a->validity,NULL);
	ret+=i2D_X509_NAME(a->subject,NULL);
	ret+=i2D_X509_PUBKEY(a->key,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);
	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
/*	i2D_INTEGER(a->version,&p); */
	i2D_INTEGER(a->serialNumber,&p);
	i2D_X509_ALGOR(a->signature,&p);
	i2D_X509_NAME(a->issuer,&p);
	i2D_X509_VAL(a->validity,&p);
	i2D_X509_NAME(a->subject,&p);
	i2D_X509_PUBKEY(a->key,&p);

	*pp=p;
	return(r);
	}

int i2D_X509_REQ_INFO(a, pp)
X509_REQ_INFO *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret =i2D_INTEGER(a->version,NULL);
	ret+=i2D_X509_NAME(a->subject,NULL);
	ret+=i2D_X509_PUBKEY(a->pubkey,NULL);
	ret+=i2D_TAG(0,DER_CONTEXT_SPECIFIC,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);

	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_INTEGER(a->version,&p);
	i2D_X509_NAME(a->subject,&p);
	i2D_X509_PUBKEY(a->pubkey,&p);
	i2D_TAG(0,DER_CONTEXT_SPECIFIC,&p);

	*pp=p;
	return(r);
	}

int i2D_X509_REQ(a, pp)
X509_REQ *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;

	ret=i2D_X509_REQ_INFO(a->req_info,NULL);
	ret+=i2D_X509_ALGOR(a->sig_alg,NULL);
	ret+=i2D_DER_BIT_STRING(a->signature,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);

	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object(&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_REQ_INFO(a->req_info,&p);
	i2D_X509_ALGOR(a->sig_alg,&p);
	i2D_DER_BIT_STRING(a->signature,&p);

	*pp=p;
	return(r);
	}

int i2D_X509(a, pp)
X509 *a;
unsigned char **pp;
	{
	int r,ret;
	unsigned char *p;
	
	ret =i2D_X509_CINF(a->cert_info,NULL);
	ret+=i2D_X509_ALGOR(a->sig_alg,NULL);
	ret+=i2D_DER_BIT_STRING(a->signature,NULL);
	r=DER_object_size(1,ret,DER_SEQUENCE);

	if (pp == NULL) return(r);
	p= *pp;

	DER_put_object((unsigned char **)&p,1,ret,DER_SEQUENCE,DER_UNIVERSAL);
	i2D_X509_CINF(a->cert_info,&p);
	i2D_X509_ALGOR(a->sig_alg,&p);
	i2D_DER_BIT_STRING(a->signature,&p);

	*pp=p;
	return(r);
	}

int i2D_X509_fp(fp, a)
FILE *fp;
X509 *a;
	{
	int btos,r,ret;
	unsigned char *p;
	BUFFER *b;

	btos=buffer_get_tos();
	b=buffer_get_buf();
	if (b == NULL)
		{
		DERerr(DER_F_I2D_X509_FP,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	
	r=i2D_X509(a,NULL);
	if (!buffer_grow(b,r))
		{
		DERerr(DER_F_I2D_X509_FP,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	p=(unsigned char *)b->data;
	r=i2D_X509(a,&p);
	ret=fwrite(b->data,(unsigned int)r,1,fp);
	buffer_set_tos(btos);
	return(ret);
err:
	buffer_set_tos(btos);
	return(0);
	}

int i2D_RSAPrivateKey_fp(fp, rsa)
FILE *fp;
RSA *rsa;
	{
	BUFFER *b;
	int i,btos;
	char *p;

	i=i2D_RSAPrivateKey(rsa,NULL);
	if (i <= 5)
		{
		DERerr(DER_F_I2D_PRIVATEKEY_FP,DER_R_NOT_ENOUGH_DATA);
		return(0);
		}
	btos=buffer_get_tos();
	b=buffer_get_buf();
	if (b == NULL)
		{
		DERerr(DER_F_I2D_PRIVATEKEY_FP,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	if (!buffer_grow(b,(long)i))
		{
		DERerr(DER_F_I2D_PRIVATEKEY_FP,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	p=b->data;
	i=i2D_RSAPrivateKey(rsa,(unsigned char **)&p);
	i=fwrite(b->data,(unsigned int)i,1,fp);
	buffer_set_tos(btos);
	return(i);
	}

int i2D_RSAPrivateKey(rsa, pp)
RSA *rsa;
unsigned char **pp;
	{
	unsigned int j,i,tot,t;
	unsigned char *p;
	BIGNUM *num[9];
	unsigned char data[1];
	DER_BIT_STRING bs[9];

	num[1]=rsa->n;
	num[2]=rsa->e;
	num[3]=rsa->d;
	num[4]=rsa->p;
	num[5]=rsa->q;
	num[6]=rsa->dmp1;
	num[7]=rsa->dmq1;
	num[8]=rsa->iqmp;
	data[0]=0;
	bs[0].length=1;
	bs[0].data=data;
	tot =i2D_INTEGER(&(bs[0]),NULL);
	for (i=1; i<9; i++)
		{
		bs[i].length=bn_num_bytes(num[i])+4;
		bs[i].data=(unsigned char *)malloc((unsigned int)bs[i].length);
		if (bs[i].data == NULL)
			{
			DERerr(DER_F_I2D_PRIVATEKEY,ERR_R_MALLOC_FAILURE);
			return(0);
			}
		bs[i].length=bn_bn2bin(num[i],bs[i].data);
		j=i2D_INTEGER(&(bs[i]),NULL);
		tot+=j;
		}
	t=DER_object_size(1,(int)tot,DER_SEQUENCE);
	if (pp ==  NULL)
		{
		for (i=1; i<9; i++) free(bs[i].data);
		return(t);
		}
	p= *pp;

	for (i=0; i<t; i++) p[i]=0;

	DER_put_object(&p,1,(int)tot,DER_SEQUENCE,DER_UNIVERSAL);
	for (i=0; i<9; i++)
		i2D_INTEGER(&bs[i],&p);
	for (i=1; i<9; i++) free(bs[i].data);
	*pp=p;
	return(t);
	}

int i2D_RSAPublicKey(rsa, pp)
RSA *rsa;
unsigned char **pp;
	{
	unsigned int i,tot,t;
	unsigned char *p;
	BIGNUM *num[2];
	DER_BIT_STRING bs[2];

	num[0]=rsa->n;
	num[1]=rsa->e;
	tot=0;
	for (i=0; i<2; i++)
		{
		bs[i].length=bn_num_bytes(num[i])+4;
		bs[i].data=(unsigned char *)malloc((unsigned int)bs[i].length);
		if (bs[i].data == NULL)
			{
			DERerr(DER_F_I2D_PUBLICKEY,ERR_R_MALLOC_FAILURE);
			return(0);
			}
		bs[i].length=bn_bn2bin(num[i],bs[i].data);
		tot+=i2D_INTEGER(&(bs[i]),NULL);
		}
	t=DER_object_size(1,(int)tot,DER_SEQUENCE);
	if (pp ==  NULL)
		{
		for (i=1; i<2; i++) free(bs[i].data);
		return(t);
		}
	p= *pp;

	for (i=0; i<t; i++) p[i]=0;

	DER_put_object(&p,1,(int)tot,DER_SEQUENCE,DER_UNIVERSAL);
	for (i=0; i<2; i++)
		i2D_INTEGER(&(bs[i]),&p);
	for (i=0; i<2; i++) free(bs[i].data);
	*pp=p;
	return(t);
	}
