/* x509_err.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#define DER_F_D2I_X509_ALGOR			1
#define DER_F_D2I_X509_NAME			2
#define DER_F_D2I_X509_VAL			3
#define DER_F_D2I_X509_PUBKEY			4
#define DER_F_D2I_X509_SIG			5
#define DER_F_D2I_X509_CINF			6
#define DER_F_D2I_X509_REVOKED			7
#define DER_F_D2I_X509_REVOKED_LIST		8
#define DER_F_D2I_X509_CRL_INFO			9
#define DER_F_D2I_X509_CRL			10
#define DER_F_D2I_X509_CRL_FILE			11
#define DER_F_D2I_X509_CRL_FP			12
#define DER_F_D2I_X509_FILE			13
#define DER_F_D2I_X509_FP			14
#define DER_F_D2I_X509				15
#define DER_F_D2I_RSAPRIVATEKEY_FP		16
#define DER_F_D2I_RSAPRIVATEKEY			17
#define DER_F_D2I_RSAPUBLICKEY			18
#define DER_F_F2I_X509_ALGOR			19
#define DER_F_F2I_X509_NAME			20
#define DER_F_F2I_X509_VAL			21
#define DER_F_F2I_X509_PUBKEY			22
#define DER_F_F2I_X509_SIG			23
#define DER_F_F2I_X509_CINF			24
#define DER_F_F2I_X509_REVOKED			25
#define DER_F_F2I_X509_REVOKED_LIST		26
#define DER_F_F2I_X509_CRL_INFO			27
#define DER_F_F2I_X509_CRL			28
#define DER_F_F2I_X509				29
#define DER_F_F2I_PRINTABLESTRING		30
#define DER_F_F2I_DER_BIT_STRING		31
#define DER_F_F2I_DER_OBJECT			32
#define DER_F_F2I_RSAPRIVATEKEY			33
#define DER_F_F2I_RSAPUBLICKEY			34
#define DER_F_I2D_X509_CRL_FP			35
#define DER_F_I2D_X509_FP			36
#define DER_F_I2D_PRIVATEKEY_FP			37
#define DER_F_I2D_PRIVATEKEY			38
#define DER_F_I2D_PUBLICKEY			39
#define DER_F_I2F_RSAPRIVATEKEY			40
#define DER_F_I2F_RSAPUBLICKEY			41
#define DER_F_DER_BIT_STRING_NEW		42
#define DER_F_DER_OBJECT_NEW			43
#define DER_F_D2I_INTEGER			44
#define DER_F_D2I_DER_OBJECT			45
#define DER_F_D2I_PRINTABLESTRING		46
#define DER_F_D2I_DER_BIT_STRING		47
#define DER_F_D2I_DER_OCTET_STRING		48
#define DER_F_D2I_UTCTIME			49

#define DER_R_EXPECTING_A_SEQUENCE		1
#define DER_R_EXPECTING_A_NULL			2
#define DER_R_EXPECTING_A_SET			3
#define DER_R_EXPECTING_AN_INTEGER		4
#define DER_R_EXPECTING_AN_OBJECT		5
#define DER_R_EXPECTING_A_PRINTABLESTRING	6
#define DER_R_EXPECTING_A_BIT_STRING		7
#define DER_R_EXPECTING_AN_OCTET_STRING		8
#define DER_R_EXPECTING_AN_UTCTIME		9
#define DER_R_NOT_ENOUGH_DATA			10
#define DER_R_EXPECTING_A_BEGIN_TOKEN		11
#define DER_R_EXPECTING_A_END_TOKEN		12
#define DER_R_SHORT_LINE			13
#define DER_R_BAD_SOL_CHARACTER			14
#define DER_R_BAD_EOL_CHARACTER			15
#define DER_R_ODD_NUMBER_OF_CHARS		16
#define DER_R_NON_HEX_CHARACTERS		17
#define DER_R_LENGTH_MISMATCH			18

#define	X509_F_BUFFER_NEW			1
#define	X509_F_BUFFER_GROW			2
#define	X509_F_BUFFER_GET_BUF			3
#define X509_F_X509_ALGOR_NEW			4
#define X509_F_X509_NAME_NEW			5
#define X509_F_X509_VAL_NEW			6
#define X509_F_X509_PUBKEY_NEW			7
#define X509_F_X509_SIG_NEW			8
#define X509_F_X509_CINF_NEW			9
#define X509_F_X509_REVOKED_NEW			10
#define X509_F_X509_CRL_INFO_NEW		11
#define X509_F_X509_CRL_NEW			12
#define X509_F_X509_NEW				13
#define X509_F_X509_DUP				14
#define X509_F_X509_NEW_D2i_X509		15
#define X509_F_X509_DUP_DER_OBJECT		16
#define X509_F_X509_ONELINE_X509_NAME		17
#define X509_F_INIT_OBJ				18
#define X509_F_INIT_CERTS			19
#define X509_F_X509_GET_CERT			20
#define X509_F_X509_ADD_CERT			21
#define X509_F_X509_ADD_CERT_FILE		22
#define X509_F_X509_ADD_CERT_DIR		23
#define X509_F_X509_REQ				24
#define X509_F_X509_REQ_INFO			25
#define X509_F_X509_NAME_DUP			26
#define X509_F_X509_SIGN			27
#define X509_F_X509_X509_TO_REQ			28
#define X509_F_X509_REQ_SIGN			29

#define X509_R_BAD_X509_FILETYPE		1

/* fatal */
#define X509_R_HIT_IN_OBJECT_STORAGE		(2|ERR_R_FATAL)
#define X509_R_HIT_IN_NID_STORAGE		(3|ERR_R_FATAL)
#define X509_R_HIT_IN_SN_STORAGE		(4|ERR_R_FATAL)
#define X509_R_HIT_IN_LN_STORAGE		(5|ERR_R_FATAL)
#define X509_R_CERT_ALREADY_IN_HASH_TABLE	(6|ERR_R_FATAL)


#define RSA_F_RSAREF_BN2BIN			1
#define RSA_F_RSA_PUBLIC_ENCRYPT		2
#define RSA_F_RSA_PRIVATE_ENCRYPT		3
#define RSA_F_RSA_PUBLIC_DECRYPT		4
#define RSA_F_RSA_PRIVATE_DECRYPT		5
#define RSA_F_RSA_BN_RAND			6
#define RSA_F_RSA_NEW				7
#define RSA_F_BN_NEW				8
#define RSA_F_BN_EXPAND				9
#define RSA_F_BN_DIV				10
#define RSA_F_BN_MODMUL_RECIP			11
#define RSA_F_BN_GET_REG			12
#define RSA_F_BN_INVERSE_MODN			13
#define RSA_F_RSA_SIGN				14

#define RSA_R_DATA_TO_LARGE			1
#define RSA_R_DATA_NOT_EQ_TO_MOD_LEN		2
#define RSA_R_BLOCK_TYPE_IS_NOT_01		3
#define RSA_R_BLOCK_TYPE_IS_NOT_02		4
#define RSA_R_NULL_BEFORE_BLOCK_MISSING		5
#define RSA_R_BAD_PAD_BYTE_COUNT		6
#define RSA_R_BAD_FF_HEADER			7
#define RSA_R_BAD_SIG_TYPE			8
#define RSA_R_DIGEST_KEY_TOO_BIG_FOR_KEY	9
#define RSA_R_RSA_PRIVATE_ENCRYPT		10

/* fatal */
#define RSA_R_NULL_ARG				(8|ERR_R_FATAL)
#define RSA_R_DIV_BY_ZERO			(9|ERR_R_FATAL)
#define RSA_R_BAD_BN_MODMUL_RECIP		(10|ERR_R_FATAL)
#define RSA_R_INVERSE_MODN_NO_SOLUTION		(11|ERR_R_FATAL)

#define PEM_F_PEM_WRITE_X509			1
#define PEM_F_PEM_READ_X509			2
#define PEM_F_PEM_WRITE_CRL			3
#define PEM_F_PEM_READ_CRL			4
#define PEM_F_PEM_READ_RSA			5
#define PEM_F_PEM_WRITE_RSA			6
#define PEM_F_PEM_DO_HEADER			7
#define PEM_F_GET_KEY_BYTES			8
#define PEM_F_LOAD_IV				9
#define PEM_F_PEM_ASCII2BIN			10
#define PEM_F_PEM_READ				11
#define PEM_F_PEM_WRITE				12
#define PEM_F_PEM_DES_CBC_ENCRYPT		13
#define PEM_F_PEM_DES_EDE2_ENCRYPT		14
#define PEM_F_PEM_IDEA_CBC_ENCRYPT		15
#define PEM_F_PEM_WRITE_X509_REQ		16
#define PEM_F_DEF_CALLBACK			17
#define PEM_F_PEM_DIGESTINIT			18
#define PEM_F_PEM_DIGESTUPDATE			19
#define PEM_F_PEM_DIGESTFINAL			20
#define PEM_F_PEM_SIGNFINAL			21
#define PEM_F_PEM_VERIFYFINAL			22
#define PEM_F_PEM_SEALINIT			23
#define PEM_F_PEM_SEALUPDATE			24
#define PEM_F_INIT_CIPHER			25
#define PEM_F_DO_CIPHER				26
#define PEM_F_PEM_OPENINIT			27
#define PEM_F_PEM_OPENFINAL			28
	
#define PEM_R_READ_KEY				1
#define PEM_R_NOT_PROC_TYPE			2
#define PEM_R_NOT_ENCRYPTED			3
#define PEM_R_SHORT_HEADER			4
#define PEM_R_NOT_DEK_INFO			5
#define PEM_R_UNSUPPORTED_ENCRYPTION		6
#define PEM_R_BAD_READ_PW_STRING		7
#define PEM_R_BASE64_BAD_INPUT_CHAR		8
#define PEM_R_BASE64_LINE_TOO_LONG		9
#define PEM_R_NO_START_LINE			10
#define PEM_R_BAD_END_LINE			11
#define PEM_R_BAD_DECRYPT			12
#define PEM_R_BAD_IV_CHARS			13
#define PEM_R_BAD_MD_TYPE			14
#define PEM_R_DIGEST_DATA_TOO_BIG_FOR_KEY	15
#define PEM_R_BAD_SIGNATURE			16
#define PEM_R_BAD_CIPHER_TYPE			17
#define PEM_R_DATA_SIZE_NO_EQ_RSA_SIZE		18
