/* x509_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "x509.h"

static ERR_STRING_DATA X509_str_functs[]=
	{
{ERR_PACK(0,X509_F_BUFFER_NEW,0),		"BUFFER_NEW"},
{ERR_PACK(0,X509_F_BUFFER_GROW,0),		"BUFFER_GROW"},
{ERR_PACK(0,X509_F_BUFFER_GET_BUF,0),		"BUFFER_GET_BUF"},
{ERR_PACK(0,X509_F_X509_ALGOR_NEW,0),		"X509_ALGOR_NEW"},
{ERR_PACK(0,X509_F_X509_NAME_NEW,0),		"X509_NAME_NEW"},
{ERR_PACK(0,X509_F_X509_VAL_NEW,0),		"X509_VAL_NEW"},
{ERR_PACK(0,X509_F_X509_PUBKEY_NEW,0),		"X509_PUBKEY_NEW"},
{ERR_PACK(0,X509_F_X509_SIG_NEW,0),		"X509_SIG_NEW"},
{ERR_PACK(0,X509_F_X509_CINF_NEW,0),		"X509_CINF_NEW"},
{ERR_PACK(0,X509_F_X509_REVOKED_NEW,0),		"X509_REVOKED_NEW"},
{ERR_PACK(0,X509_F_X509_CRL_INFO_NEW,0),	"X509_CRL_INFO_NEW"},
{ERR_PACK(0,X509_F_X509_CRL_NEW,0),		"X509_CRL_NEW"},
{ERR_PACK(0,X509_F_X509_NEW,0),			"X509_NEW"},
{ERR_PACK(0,X509_F_X509_DUP,0),			"X509_DUP"},
{ERR_PACK(0,X509_F_X509_NEW_D2i_X509,0),	"X509_NEW_D2i_X509"},
{ERR_PACK(0,X509_F_X509_DUP_DER_OBJECT,0),	"X509_DUP_DER_OBJECT"},
{ERR_PACK(0,X509_F_X509_ONELINE_X509_NAME,0),	"X509_ONELINE_X509_NAME"},
{ERR_PACK(0,X509_F_INIT_OBJ,0),			"INIT_OBJ"},
{ERR_PACK(0,X509_F_INIT_CERTS,0),		"INIT_CERTS"},
{ERR_PACK(0,X509_F_X509_GET_CERT,0),		"X509_GET_CERT"},
{ERR_PACK(0,X509_F_X509_ADD_CERT,0),		"X509_ADD_CERT"},
{ERR_PACK(0,X509_F_X509_ADD_CERT_FILE,0),	"X509_ADD_CERT_FILE"},
{ERR_PACK(0,X509_F_X509_ADD_CERT_DIR,0),	"X509_ADD_CERT_DIR"},
{0,NULL},
	};

static ERR_STRING_DATA X509_str_reasons[]=
	{
{X509_R_BAD_X509_FILETYPE                ,"BAD_X509_FILETYPE"},
{X509_R_HIT_IN_OBJECT_STORAGE            ,"HIT_IN_OBJECT_STORAGE"},
{X509_R_HIT_IN_NID_STORAGE               ,"HIT_IN_NID_STORAGE"},
{X509_R_HIT_IN_SN_STORAGE                ,"HIT_IN_SN_STORAGE"},
{X509_R_HIT_IN_LN_STORAGE                ,"HIT_IN_LN_STORAGE"},
{X509_R_CERT_ALREADY_IN_HASH_TABLE       ,"CERT_ALREADY_IN_HASH_TABLE"},
{0,NULL},
	};

void ERR_load_X509_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(ERR_LIB_X509,X509_str_functs);
		ERR_load_strings(ERR_LIB_X509,X509_str_reasons);
		init=0;
		}
	}

