/* x509.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_X509_H
#define HEADER_X509_H

#ifndef HEADER_DER_H
#define DER_OBJECT	char
#define DER_BIT_STRING	char
#endif

typedef struct AlgorithmIdentifier_st
	{
	DER_OBJECT *algorithm;
	DER_BIT_STRING *parameters;
	} X509_ALGOR;

typedef struct Name_st
	{
	int num;
	DER_OBJECT **objects;
#define X509_get_name_type(t)	((t)&0xff)
#define X509_get_name_set(t)	(((t)>>8)&0xff)
#define X509_set_name_type(t,v)	((t)=((t)&0xff00)|(v))
#define X509_set_name_set(t,v)	((t)=((t)&0x00ff)|(((t)<<8)&0xff00))
	int *types;
	DER_BIT_STRING **values;
	} X509_NAME;

typedef struct Validity_st
	{
	char *notBefore;
	char *notAfter;
	} X509_VAL;

typedef struct subject_public_keyinfo_st
	{
	X509_ALGOR *algor;
	DER_BIT_STRING *public_key;
	} X509_PUBKEY;

typedef struct signature_st
	{
	X509_ALGOR *algor;
	DER_BIT_STRING *digest;
	} X509_SIG;

typedef struct CertificateInfo_st
	{
/*	DER_BIT_STRING version; */
	DER_BIT_STRING *serialNumber;
	X509_ALGOR *signature;
	X509_NAME *issuer;
	X509_VAL *validity;
	X509_NAME *subject;
	X509_PUBKEY *key;
	} X509_CINF;

typedef struct X509_revoked_st
	{
	DER_BIT_STRING *serialNumber;
	char *revocationDate;
	} X509_REVOKED;

typedef struct X509_certificate_revocation_list_info_st
	{
	X509_ALGOR *sig_alg;
	X509_NAME *issuer;
	char *lastUpdate;
	char *nextUpdate;
	unsigned int num;
	X509_REVOKED **revoked;
	} X509_CRL_INFO;

typedef struct X509_certificate_revocation_list_st
	{
	/* actual signature */
	X509_CRL_INFO *crl;
	X509_ALGOR *sig_alg;
	DER_BIT_STRING *signature;
	} X509_CRL;

typedef struct X509_certificate_st
	{
	X509_CINF *cert_info;
	X509_ALGOR *sig_alg;
	DER_BIT_STRING *signature;
	} X509;

typedef struct X509_req_info_st
	{
	DER_BIT_STRING *version;
	X509_NAME *subject;
	X509_PUBKEY *pubkey;
	/*  d=2 hl=2 l=  0 cons: cont: 00 */
	} X509_REQ_INFO;

typedef struct X509_req_st
	{
	X509_REQ_INFO *req_info;
	X509_ALGOR *sig_alg;
	DER_BIT_STRING *signature;
	} X509_REQ;

#define TOKEN_ERROR				0

#define TOKEN_ERROR				0
#define TOKEN_X509_CERTIFICATE_BEGIN		1
#define TOKEN_X509_CERTIFICATE_END		2
#define TOKEN_CERTIFICATE_BEGIN			3
#define TOKEN_CERTIFICATE_END			4
#define TOKEN_ALGORITHMIDENTIFIER_BEGIN		5
#define TOKEN_ALGORITHMIDENTIFIER_END		6
#define TOKEN_NAME_BEGIN			7
#define TOKEN_NAME_END				8
#define TOKEN_VALIDITY_BEGIN			9
#define TOKEN_VALIDITY_END			10
#define TOKEN_SUBJECTPUBLICKEYINFO_BEGIN	11
#define TOKEN_SUBJECTPUBLICKEYINFO_END		12
#define TOKEN_RSAPUBLICKEY_BEGIN		13
#define TOKEN_RSAPUBLICKEY_END			14
#define TOKEN_RSAPRIVATEKEY_BEGIN		15
#define TOKEN_RSAPRIVATEKEY_END			16
#define TOKEN_SIGNATURE_BEGIN			17
#define TOKEN_SIGNATURE_END			18
#define TOKEN_CRL_BEGIN				19
#define TOKEN_CRL_END				20
#define TOKEN_CRL_INFO_BEGIN			21
#define TOKEN_CRL_INFO_END			22

#define STRING_X509_CERTIFICATE_BEGIN		"X.509-Certificate begin"
#define STRING_X509_CERTIFICATE_END		"X.509-Certificate end"
#define STRING_CERTIFICATE_BEGIN		"CertificateInfo begin"
#define STRING_CERTIFICATE_END			"CertificateInfo end"
#define STRING_NAME_BEGIN			"Name begin"
#define STRING_NAME_END				"Name end"
#define STRING_VALIDITY_BEGIN			"Validity begin"
#define STRING_VALIDITY_END			"Validity end"
#define STRING_SUBJECTPUBLICKEYINFO_BEGIN	"SubjectPublicKeyInfo begin"
#define STRING_SUBJECTPUBLICKEYINFO_END		"SubjectPublicKeyInfo end"
#define STRING_ALGORITHMIDENTIFIER_BEGIN	"AlgorithmIdentifier begin"
#define STRING_ALGORITHMIDENTIFIER_END		"AlgorithmIdentifier end"
#define STRING_RSAPRIVATEKEY_BEGIN		"RSAPrivateKey begin"
#define STRING_RSAPRIVATEKEY_END		"RSAPrivateKey end"
#define STRING_RSAPUBLICKEY_BEGIN		"RSAPublicKey begin"
#define STRING_RSAPUBLICKEY_END			"RSAPublicKey end"
#define STRING_SIGNATURE_BEGIN			"Signature begin"
#define STRING_SIGNATURE_END			"Signature end"
#define STRING_CRL_BEGIN		"CertificateRevocationList begin"
#define STRING_CRL_END			"CertificateRevocationList end"
#define STRING_CRL_INFO_BEGIN		"CertificateRevocationListInfo begin"
#define STRING_CRL_INFO_END		"CertificateRevocationListInfo end"

#define X509_FILETYPE_PEM			1
#define X509_FILETYPE_TEXT			2
#define X509_FILETYPE_DER			3

#ifndef HEADER_BN_H
#define BIGNUM 		char
#endif

typedef struct rsa_st
	{
	BIGNUM *n;
	BIGNUM *e;
	BIGNUM *d;
	BIGNUM *p;
	BIGNUM *q;
	BIGNUM *dmp1;
	BIGNUM *dmq1;
	BIGNUM *iqmp;
	} RSA;


#ifdef PROTO
RSA *	RSA_new(void);
int 	RSA_size(RSA *rsa);
RSA *	RSA_generate_key(int bits, int use_f4);
	/* next 4 return -1 on error */
int	RSA_public_encrypt(int flen, unsigned char *from,
		unsigned char *to, RSA *rsa);
int	RSA_private_encrypt(int flen, unsigned char *from,
		unsigned char *to, RSA *rsa);
int	RSA_public_decrypt(int flen, unsigned char *from, 
		unsigned char *to, RSA *rsa);
int	RSA_private_decrypt(int flen, unsigned char *from, 
		unsigned char *to, RSA *rsa);
int	RSA_mod_exp(BIGNUM *r0, BIGNUM *I, RSA *rsa);
int	RSA_bn_rand(BIGNUM *rnd, int bits, int prime);
int	RSA_bn_rand(BIGNUM *rnd, int bits, int prime);
void	RSA_free (RSA *r);
int 	RSA_sign(char *inb, int inl, char *outb, int *outl, int type, RSA *rsa);
void	RSA_set_generate_prime_callback (void (*a) ());
BIGNUM *RSA_generate_prime(int bits);
#else
RSA *	RSA_new();
int 	RSA_size();
RSA *	RSA_generate_key();
	/* next 4 return -1 on error */
int	RSA_public_encrypt();
int	RSA_private_encrypt();
int	RSA_public_decrypt();
int	RSA_private_decrypt();
int	RSA_mod_exp();
int	RSA_bn_rand();
int	RSA_bn_rand();
void	RSA_free ();
void	RSA_set_generate_prime_callback ();
BIGNUM *RSA_generate_prime();
int 	RSA_sign();
#endif

/*#define RSA_DEBUG */

#define	VERIFY_OK					0
#define	VERIFY_ERR_UNABLE_TO_GET_ISSUER			1
#define	VERIFY_ERR_UNABLE_TO_DECRYPT_SIGNATURE		2
#define	VERIFY_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY	3
#define	VERIFY_ERR_UNABLE_TO_UNPACK_SIGNATURE		4
#define	VERIFY_ERR_UNKNOWN_X509_SIG_ALGORITHM		5
#define	VERIFY_ERR_SIG_DIGEST_LENGTH_WRONG		6
#define	VERIFY_ERR_SIGNATURE_FAILURE			7
#define	VERIFY_ERR_CERT_NOT_YET_VALID			8
#define	VERIFY_ERR_CERT_HAS_EXPIRED			9
#define	VERIFY_ERR_ERROR_IN_NOT_BEFORE_FIELD		10
#define	VERIFY_ERR_ERROR_IN_NOT_AFTER_FIELD		11
#define	VERIFY_ERR_OUT_OF_MEM				12
#define	VERIFY_ERR_DEPTH_ZERO_SELF_SIGNED_CERT		13

#ifdef PROTO
int             D2i_PRINTABLESTRING(unsigned char **sp, unsigned char **pp);
int		D2i_DER_BIT_STRING (DER_BIT_STRING *bp, unsigned char **pp);
int		D2i_DER_OBJECT (DER_OBJECT *o, unsigned char **pp);
int		D2i_INTEGER (DER_BIT_STRING *bs, unsigned char **pp);
int		D2i_OCTET_STRING (DER_BIT_STRING *bp, unsigned char **pp);
int		D2i_RSAPrivateKey (RSA *rsa, unsigned char **pp);
int		D2i_RSAPrivateKey_fp (FILE *in, RSA *rsa);
int		D2i_RSAPublicKey (RSA *rsa, unsigned char **pp);
int		D2i_UTCTime (unsigned char **sp, unsigned char **pp);
int		D2i_X509_SIG (X509_SIG *a, unsigned char **pp);
int		D2i_X509_REVOKED(X509_REVOKED **a, unsigned char **pp);
int		D2i_X509_CRL_INFO(X509_CRL_INFO *a, unsigned char **pp);
int		D2i_X509_CRL(X509_CRL *a, int len, unsigned char *p);
int		D2i_X509_CRL_fp(FILE *in, X509_CRL *a);
int		D2i_X509_CRL_file(char *file, X509_CRL *a);
int		D2i_X509 (X509 *a, int lenbuf, unsigned char *p);
int		D2i_X509_fp (FILE *in, X509 *a);
int		D2i_X509_file(char *file, X509 *a);
int		D2i_X509_ALGOR(X509_ALGOR *a, unsigned char **pp);
int		D2i_X509_NAME(X509_NAME *n,unsigned char **pp);
int		D2i_X509_VAL(X509_VAL *a, unsigned char **pp);
int		D2i_X509_PUBKEY(X509_PUBKEY *a, unsigned char **pp);
int		D2i_X509_CINF(X509_CINF *a, unsigned char **pp);

X509_ALGOR *	X509_ALGOR_new(void);
X509_NAME *	X509_NAME_new(void);
X509_VAL *	X509_VAL_new(void);
X509_PUBKEY *	X509_PUBKEY_new(void);
X509_SIG *	X509_SIG_new(void);
X509_CINF *	X509_CINF_new(void);
X509_REVOKED *	X509_REVOKED_new(void);
X509_CRL_INFO *	X509_CRL_INFO_new(void);
X509_CRL *	X509_CRL_new(void);
void		X509_REVOKED_free(X509_REVOKED *a);
void		X509_CRL_INFO_free(X509_CRL_INFO *a);
void		X509_CRL_free(X509_CRL *a);
X509 *		X509_new(void);
X509_REQ_INFO *	X509_REQ_INFO_new(void);
X509_REQ *	X509_REQ_new(void);
void		X509_REQ_INFO_free(X509_REQ_INFO *a);
void		X509_REQ_free(X509_REQ *a);
DER_OBJECT *	X509_dup_DER_OBJECT(DER_OBJECT *o);
DER_OBJECT *	X509_nid2obj(int n);
char *		X509_oneline_X509_NAME(X509_NAME *a);
char *		X509_verify_error_string(int n);
int 		X509_add_cert_file(char *file, int type);
char *		X509_gmtime (char *s, long adj);
char *		X509_nid2ln (int n);
int		X509_ln2nid(char *s);
int		X509_sn2nid(char *s);
void		X509_ALGOR_free (X509_ALGOR *a);
void		X509_SIG_free (X509_SIG *a);
int		X509_add_cert (X509 *x);
int		X509_add_cert_dir (char *dir, int type);
void		X509_free (X509 *a);
int		X509_load_verify_locations (char *file_env, char *dir_env);
int		X509_name_cmp (X509_NAME *a, X509_NAME *b);
int		X509_obj2nid (DER_OBJECT *a);
int		X509_set_default_verify_paths (void);
unsigned long	X509_subject_name_hash(X509 *x);
unsigned long	X509_name_hash(X509_NAME *x);
X509_NAME *	X509_get_issuer_name(X509 *a);
X509_NAME *	X509_get_subject_name(X509 *a);
X509 *		X509_new_D2i_X509(int len, unsigned char *p);
X509 *		X509_dup(X509 *x);
X509_NAME *	X509_NAME_dup(X509_NAME *n);
void		X509_NAME_free(X509_NAME *a);
void		X509_VAL_free(X509_VAL *a);
void		X509_PUBKEY_free(X509_PUBKEY *a);
void		X509_CINF_free(X509_CINF *a);
char *		X509_nid2sn(int n);
X509 *		X509_get_cert(X509_NAME * name);
char *		X509_get_default_cert_area(void );
char *		X509_get_default_cert_dir(void );
char *		X509_get_default_cert_file(void );
char *		X509_get_default_cert_dir_env(void );
char *		X509_get_default_cert_file_env(void );
X509_REQ *	X509_X509_TO_req(X509 *x, RSA *rsa);
int		X509_REQ_sign(X509_REQ *x,RSA *rsa, int type);
void		X509_REQ_print(FILE *fp, X509_REQ *x);
int		X509_sign(X509 *x, RSA *rsa, int type);
int		X509_verify(X509 *xs, int (*cb)()); 

int		f2i_DER_BIT_STRING (FILE *fp, DER_BIT_STRING *bs,
			int size, char *buf);
int		f2i_DER_OBJECT (FILE *fp, DER_OBJECT *o, int size, char *buf);
int		f2i_PRINTABLESTRING (FILE *fp, unsigned char **s,
			int size, char *buf);
int		f2i_RSAPrivateKey (FILE *fp, RSA *rsa);
int		f2i_UTCTime (FILE *fp, unsigned char **s, int size, char *buf);
int		f2i_X509_REVOKED(FILE *fp, X509_REVOKED **a,
			int size, char *buf);
int		f2i_X509_REVOKED_list(FILE *fp, X509_CRL_INFO *a,
			int size, char *buf);
int		f2i_X509_CRL_INFO(FILE *fp, X509_CRL_INFO *a,
			int size, char *buf);
int		f2i_X509_CRL(FILE *fp, X509_CRL *a);
int		f2i_X509 (FILE *fp, X509 *a);
int		f2i_X509_ALGOR(FILE *fp, X509_ALGOR *a, int size, char *buf);
int		f2i_X509_NAME(FILE *fp, X509_NAME *a, int size, char *buf);
int		f2i_X509_VAL(FILE *fp, X509_VAL *a, int size, char *buf);
int		f2i_X509_PUBKEY(FILE *fp, X509_PUBKEY *a, int size, char *buf);
int		f2i_X509_SIG(FILE *fp, X509_SIG *a, int size, char *buf);
int		f2i_X509_CINF(FILE *fp, X509_CINF *a, int size, char *buf);
int		f2i_error_line(void);
int		f2i_RSAPublicKey(FILE *fp, RSA *rsa, int size, char *buf);

int		i2D_DER_BIT_STRING (DER_BIT_STRING *a, unsigned char **pp);
int		i2D_DER_OBJECT (DER_OBJECT *a, unsigned char **pp);
int		i2D_INTEGER (DER_BIT_STRING *a, unsigned char **pp);
int		i2D_OCTET_STRING (DER_BIT_STRING *a, unsigned char **pp);
int		i2D_RSAPrivateKey (RSA *rsa, unsigned char **pp);
int		i2D_RSAPrivateKey_fp (FILE *fp, RSA *rsa);
int		i2D_RSAPublicKey (RSA *rsa, unsigned char **pp);
int		i2D_UTCTime (char *a, unsigned char **pp);
int		i2D_X509_ALGOR(X509_ALGOR *a, unsigned char **pp);
int		i2D_X509_REVOKED(X509_REVOKED *a, unsigned char **pp);
int		i2D_X509_CRL_INFO(X509_CRL_INFO *a,unsigned char **pp);
int		i2D_X509_CRL(X509_CRL *a,unsigned char **pp);
int		i2D_X509 (X509 *a, unsigned char **pp);
int		i2D_X509_CINF (X509_CINF *a, unsigned char **pp);
int		i2D_X509_SIG (X509_SIG *a, unsigned char **pp);
int		i2D_X509_fp (FILE *fp, X509 *a);
int		i2D_X509_REQ(X509_REQ *a, unsigned char **pp);
int		i2D_X509_REQ_INFO(X509_REQ_INFO *a, unsigned char **pp);
int		i2D_TAG(int a, int c, unsigned char **pp);
int		i2D_X509_NAME(X509_NAME *n,unsigned char **pp);
int		i2D_X509_VAL(X509_VAL *a,unsigned char **pp);
int		i2D_X509_PUBKEY(X509_PUBKEY *a,unsigned char **pp);
int		i2D_X509_CRL_fp(FILE *fp,X509_CRL *a);

void		i2f_DER_BIT_STRING (FILE *fp, DER_BIT_STRING *a);
void		i2f_DER_OBJECT (FILE *fp, DER_OBJECT *a);
int		i2f_RSAPrivateKey (FILE *fp, RSA *rsa);
void 		i2f_X509_CRL_INFO(FILE *fp, X509_CRL_INFO *a);
void 		i2f_X509_CRL(FILE *fp, X509_CRL *a);
void		i2f_X509 (FILE *fp, X509 *a);
void		i2f_X509_ALGOR(FILE *fp, X509_ALGOR *a);
void		i2f_X509_NAME(FILE *fp, X509_NAME *a);
void		i2f_X509_VAL(FILE *fp, X509_VAL *a);
void		i2f_X509_PUBKEY(FILE *fp, X509_PUBKEY *a);
void		i2f_X509_SIG(FILE *fp, X509_SIG *a);
void		i2f_X509_CINF(FILE *fp, X509_CINF *a);
int		i2f_RSAPublicKey(FILE *fp, RSA *rsa);

#else

int             D2i_PRINTABLESTRING();
int		D2i_DER_BIT_STRING ();
int		D2i_DER_OBJECT ();
int		D2i_INTEGER ();
int		D2i_OCTET_STRING ();
int		D2i_RSAPrivateKey ();
int		D2i_RSAPrivateKey_fp ();
int		D2i_RSAPublicKey ();
int		D2i_UTCTime ();
int		D2i_X509_SIG ();
int		D2i_X509_REVOKED();
int		D2i_X509_CRL_INFO();
int		D2i_X509_CRL();
int		D2i_X509_CRL_fp();
int		D2i_X509_CRL_file();
int		D2i_X509 ();
int		D2i_X509_fp ();
int		D2i_X509_file();
int		D2i_X509_NAME();
int		D2i_X509_ALGOR();
int		D2i_X509_VAL();
int		D2i_X509_PUBKEY();
int		D2i_X509_CINF();

X509_ALGOR *	X509_ALGOR_new();
X509_NAME *	X509_NAME_new();
X509_VAL *	X509_VAL_new();
X509_PUBKEY *	X509_PUBKEY_new();
X509_SIG *	X509_SIG_new();
X509_CINF *	X509_CINF_new();
X509_REVOKED *	X509_REVOKED_new();
X509_CRL_INFO *	X509_CRL_INFO_new();
X509_CRL *	X509_CRL_new();
void		X509_REVOKED_free();
void		X509_CRL_INFO_free();
void		X509_CRL_free();
X509 *		X509_new();
X509_REQ_INFO *	X509_REQ_INFO_new();
X509_REQ *	X509_REQ_new();
void		X509_REQ_INFO_free();
void		X509_REQ_free();
DER_OBJECT *	X509_dup_DER_OBJECT();
DER_OBJECT *	X509_nid2obj();
char *		X509_oneline_X509_NAME();
char *		X509_verify_error_string();
int 		X509_add_cert_file();
char *		X509_gmtime ();
char *		X509_nid2ln ();
int		X509_ln2nid();
int		X509_sn2nid();
void		X509_ALGOR_free ();
void		X509_SIG_free ();
int		X509_add_cert ();
int		X509_add_cert_dir ();
void		X509_free ();
int		X509_load_verify_locations ();
int		X509_name_cmp ();
int		X509_obj2nid ();
int		X509_set_default_verify_paths ();
unsigned long	X509_subject_name_hash();
unsigned long	X509_name_hash();
X509_NAME *	X509_get_issuer_name();
X509_NAME *	X509_get_subject_name();
X509 *		X509_new_D2i_X509();
X509 *		X509_dup();
X509_NAME *	X509_NAME_dup();
void		X509_NAME_free();
void		X509_VAL_free();
void		X509_PUBKEY_free();
void		X509_CINF_free();
char *		X509_nid2sn();
X509 *		X509_get_cert();
char *		X509_get_default_cert_area();
char *		X509_get_default_cert_dir();
char *		X509_get_default_cert_file();
char *		X509_get_default_cert_dir_env();
char *		X509_get_default_cert_file_env();
X509_REQ *	X509_X509_TO_req();
int		X509_REQ_sign();
void		X509_REQ_print();
int		X509_sign();
int		X509_verify(); 

int		f2i_DER_BIT_STRING();
int		f2i_DER_OBJECT ();
int		f2i_PRINTABLESTRING ();
int		f2i_RSAPrivateKey ();
int		f2i_UTCTime ();
int		f2i_X509_REVOKED();
int		f2i_X509_REVOKED_list();
int		f2i_X509_CRL_INFO();
int		f2i_X509_CRL();
int		f2i_X509 ();
int		f2i_X509_ALGOR();
int		f2i_X509_NAME();
int		f2i_X509_VAL();
int		f2i_X509_PUBKEY();
int		f2i_X509_SIG();
int		f2i_X509_CINF();
int		f2i_error_line();
int		f2i_RSAPublicKey();

int		i2D_DER_BIT_STRING ();
int		i2D_DER_OBJECT ();
int		i2D_INTEGER ();
int		i2D_OCTET_STRING ();
int		i2D_RSAPrivateKey ();
int		i2D_RSAPrivateKey_fp ();
int		i2D_RSAPublicKey ();
int		i2D_UTCTime ();
int		i2D_X509_ALGOR();
int		i2D_X509_REVOKED();
int		i2D_X509_CRL_INFO();
int		i2D_X509_CRL();
int		i2D_X509 ();
int		i2D_X509_CINF ();
int		i2D_X509_SIG ();
int		i2D_X509_fp ();
int		i2D_X509_REQ();
int		i2D_X509_REQ_INFO();
int		i2D_TAG();
int		i2D_X509_NAME();
int		i2D_X509_VAL();
int		i2D_X509_PUBKEY();
int		i2D_X509_CRL_fp();

void		i2f_DER_BIT_STRING ();
void		i2f_DER_OBJECT ();
int		i2f_RSAPrivateKey ();
void 		i2f_X509_CRL_INFO();
void 		i2f_X509_CRL();
void		i2f_X509 ();
void		i2f_X509_ALGOR();
void		i2f_X509_NAME();
void		i2f_X509_VAL();
void		i2f_X509_PUBKEY();
void		i2f_X509_SIG();
void		i2f_X509_CINF();
int		i2f_RSAPublicKey();

#endif

#ifdef PROTO
void ERR_load_X509_strings(void );
void ERR_load_DER_strings(void );
void ERR_load_PEM_strings(void );
void ERR_load_RSA_strings(void );
#else
void ERR_load_X509_strings();
void ERR_load_DER_strings();
void ERR_load_PEM_strings();
void ERR_load_RSA_strings();
#endif

#endif
