/* verify.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "bn.h"
#include "x509.h"
#include "pem.h"

#ifdef PROTO
static int cb(int ok, X509 *xs, X509 *xi, int depth, int error);
static void check(char *file);
#else
static int cb();
static void check();
#endif

int main(argc, argv)
int argc;
char **argv;
	{
	int i;

	ERR_load_crypto_strings();

	if (!X509_set_default_verify_paths()) exit(1);

	if (argc < 2) check(NULL);
	else
		for (i=1; i<argc; i++)
			check(argv[i]);
	exit(0);
	return(0);
	}

static void check(file)
char *file;
	{
	X509 *x;
	FILE *in;
	int i;

	if (file != NULL)
		{
		in=fopen(file,"r");
		if (in == NULL)
			{
			perror(file);
			exit(1);
			}
		}
	else
		in=stdin;

	x=(X509 *)X509_new();
	i=PEM_read_X509(in,x);
	if (!i)
		{
		fprintf(stdout,"%s: unable to load certificate file\n",
			file);
		ERR_print_error_stack(stderr);
		X509_free(x);
		return;
		}
	fprintf(stdout,"%s: ",file);
	i=X509_verify(x,cb);
	if (i) fprintf(stdout,"OK\n");
	else	ERR_print_error_stack(stderr);
	X509_free(x);
	return;
	}

static int cb(ok, xs, xi, depth, error)
int ok;
X509 *xs;
X509 *xi;
int depth;
int error;
	{
	if (!ok)
		{
		char *s;
		/* since we are just checking the certificates, it is
		 * ok if they are self signed. */
		if (error == VERIFY_ERR_DEPTH_ZERO_SELF_SIGNED_CERT)
			ok=1;
		else
			{
			s=X509_oneline_X509_NAME(X509_get_subject_name(xs));
			printf("%s\n",s);
			free(s);
			printf("error %d at %d:%s\n",error,depth,
				X509_verify_error_string(error));
			}
		}
	ERR_clear_error();
#ifdef LINT
	xi=xs; xs=xi;
#endif
	return(ok);
	}

