/* rsa_lib.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "bn.h"
#include "buffer.h"
#include "md5.h"
#include "x509.h"

char *RSA_version="\0RSA part of SSLeay v 0.4.4 17/07/95";

RSA *RSA_new()
	{
	RSA *ret;

	ret=(RSA *)malloc(sizeof(RSA));
	if (ret == NULL)
		{
		RSAerr(RSA_F_RSA_NEW,ERR_R_MALLOC_FAILURE);
		return(NULL);
		}
	ret->n=NULL;
	ret->e=NULL;
	ret->d=NULL;
	ret->p=NULL;
	ret->q=NULL;
	ret->dmp1=NULL;
	ret->dmq1=NULL;
	ret->iqmp=NULL;
	return(ret);
	}

int RSA_size(r)
RSA *r;
	{
	return(bn_num_bytes(r->n));
	}

void RSA_free(r)
RSA *r;
	{
	if (r->n != NULL) bn_free(r->n);
	if (r->e != NULL) bn_free(r->e);
	if (r->d != NULL) bn_free(r->d);
	if (r->p != NULL) bn_free(r->p);
	if (r->q != NULL) bn_free(r->q);
	if (r->dmp1 != NULL) bn_free(r->dmp1);
	if (r->dmq1 != NULL) bn_free(r->dmq1);
	if (r->iqmp != NULL) bn_free(r->iqmp);
	free(r);
	}

int RSA_mod_exp(r0, I, rsa)
BIGNUM *r0;
BIGNUM *I;
RSA *rsa;
	{
	BIGNUM *r1,*m1;
	int tos;

	tos=bn_get_tos();

	m1=bn_get_reg();
	r1=bn_get_reg();
	if ((m1 == NULL) || (r1 == NULL)) goto err;

	if (!bn_mod(r1,I,rsa->q)) goto err;
	if (!bn_mod_exp(m1,r1,rsa->dmq1,rsa->q)) goto err;

	if (!bn_mod(r1,I,rsa->p)) goto err;
	if (!bn_mod_exp(r0,r1,rsa->dmp1,rsa->p)) goto err;

	if (!bn_add(r1,r0,rsa->p)) goto err;
	if (!bn_sub(r0,r1,m1)) goto err;

	if (!bn_mul(r1,r0,rsa->iqmp)) goto err;
	if (!bn_mod(r0,r1,rsa->p)) goto err;
	if (!bn_mul(r1,r0,rsa->q)) goto err;
	if (!bn_add(r0,r1,m1)) goto err;
	
	bn_set_tos(tos);
	return(1);
err:
	bn_set_tos(tos);
	return(0);
	}

