/* rsa_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
*/

#include <stdio.h>
#include "crypto.h"
#include "x509.h"

static ERR_STRING_DATA RSA_str_functs[]=
	{
{ERR_PACK(0,RSA_F_RSAREF_BN2BIN,0),		"RSAREF_BN2BIN"},
{ERR_PACK(0,RSA_F_RSA_PUBLIC_ENCRYPT,0),	"RSA_PUBLIC_ENCRYPT"},
{ERR_PACK(0,RSA_F_RSA_PRIVATE_ENCRYPT,0),	"RSA_PRIVATE_ENCRYPT"},
{ERR_PACK(0,RSA_F_RSA_PUBLIC_DECRYPT,0),	"RSA_PUBLIC_DECRYPT"},
{ERR_PACK(0,RSA_F_RSA_PRIVATE_DECRYPT,0),	"RSA_PRIVATE_DECRYPT"},
{ERR_PACK(0,RSA_F_RSA_BN_RAND,0),		"RSA_BN_RAND"},
{ERR_PACK(0,RSA_F_RSA_NEW,0),			"RSA_NEW"},
{ERR_PACK(0,RSA_F_BN_NEW,0),			"BN_NEW"},
{ERR_PACK(0,RSA_F_BN_EXPAND,0),			"BN_EXPAND"},
{ERR_PACK(0,RSA_F_BN_DIV,0),			"BN_DIV"},
{ERR_PACK(0,RSA_F_BN_MODMUL_RECIP,0),		"BN_MODMUL_RECIP"},
{ERR_PACK(0,RSA_F_BN_GET_REG,0),		"BN_GET_REG"},
{ERR_PACK(0,RSA_F_BN_INVERSE_MODN,0),		"BN_INVERSE_MODN"},
{0,NULL},
	};

static ERR_STRING_DATA RSA_str_reasons[]=
	{
{RSA_R_DATA_TO_LARGE                     ,"DATA_TO_LARGE"},
{RSA_R_DATA_NOT_EQ_TO_MOD_LEN            ,"DATA_NOT_EQ_TO_MOD_LEN"},
{RSA_R_BLOCK_TYPE_IS_NOT_01              ,"BLOCK_TYPE_IS_NOT_01"},
{RSA_R_BLOCK_TYPE_IS_NOT_02              ,"BLOCK_TYPE_IS_NOT_02"},
{RSA_R_NULL_BEFORE_BLOCK_MISSING         ,"NULL_BEFORE_BLOCK_MISSING"},
{RSA_R_BAD_PAD_BYTE_COUNT                ,"BAD_PAD_BYTE_COUNT"},
{RSA_R_BAD_FF_HEADER                     ,"BAD_FF_HEADER"},
{RSA_R_NULL_ARG                          ,"NULL_ARG"},
{RSA_R_DIV_BY_ZERO                       ,"DIV_BY_ZERO"},
{RSA_R_BAD_BN_MODMUL_RECIP               ,"BAD_BN_MODMUL_RECIP"},
{RSA_R_INVERSE_MODN_NO_SOLUTION          ,"INVERSE_MODN_NO_SOLUTION"},
{0,NULL},
	};

void ERR_load_RSA_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(ERR_LIB_RSA,RSA_str_functs);
		ERR_load_strings(ERR_LIB_RSA,RSA_str_reasons);
		init=0;
		}
	}

