/* rsa_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef RSAref

#include <stdio.h>
#include "crypto.h"
#include "bn.h"
#include "buffer.h"
#include "md5.h"
#include "x509.h"

int RSA_public_encrypt(flen, from, to, rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,k,btos,num;
	unsigned char *p;
	BUFFER *buf;

	tos=bn_get_tos();
	btos=buffer_get_tos();
	num=bn_num_bytes(rsa->n);
	if (flen > (num-11))
		{
		RSAerr(RSA_F_RSA_PUBLIC_ENCRYPT,RSA_R_DATA_TO_LARGE);
		goto err;
		}
	
	buf=buffer_get_buf();
	if ((buf == NULL) || (buffer_grow(buf,num) ==0))
		{
		RSAerr(RSA_F_RSA_PUBLIC_ENCRYPT,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	p=(unsigned char *)buf->data;

	*(p++)=0;
	*(p++)=2; /* Public Key BT (Block Type) */

	/* pad out with non-zero random data */
	j=num-3-flen;
	MD5_rand(j,p);
	for (i=0; i<j; i++)
		{
		if (*p == '\0')
			do	{
				MD5_rand(1,p);
				} while (*p == '\0');
		p++;
		}
	*(p++)='\0';
	memcpy(p,from,(unsigned int)flen);
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(num,(unsigned char *)buf->data,f) == NULL) goto err;
	if (!bn_mod_exp(ret,f,rsa->e,rsa->n)) goto err;

	/* put in leading 0 bytes if the number is less than the
	 * length of the modulus */
	j=bn_num_bytes(ret);
	i=bn_bn2bin(ret,&(to[num-j]));
	for (k=0; k<(num-i); k++)
		to[k]=0;

	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(num);
err:
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(0);
	}

int RSA_private_encrypt(flen, from, to, rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,k,num,btos;
	unsigned char *p;
	BUFFER *buf;

	tos=bn_get_tos();
	btos=buffer_get_tos();
	num=bn_num_bytes(rsa->n);
	if (flen > (num-11))
		{
		RSAerr(RSA_F_RSA_PRIVATE_ENCRYPT,RSA_R_DATA_TO_LARGE);
		goto err;
		}
	buf=buffer_get_buf();
	if ((buf == NULL) || (buffer_grow(buf,num) <= 0))
		{
		RSAerr(RSA_F_RSA_PRIVATE_ENCRYPT,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	p=(unsigned char *)buf->data;

	*(p++)=0;
	*(p++)=1; /* Private Key BT (Block Type) */

	/* padd out with 0xff data */
	j=num-3-flen;
	for (i=0; i<j; i++)
		*(p++)=0xff;
	*(p++)='\0';
	memcpy(p,from,(unsigned int)flen);
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(num,(unsigned char *)buf->data,f) == NULL) goto err;
	if (	(rsa->p != NULL) &&
		(rsa->q != NULL) &&
		(rsa->dmp1 != NULL) &&
		(rsa->dmq1 != NULL) &&
		(rsa->iqmp != NULL))
		{ if (!RSA_mod_exp(ret,f,rsa)) goto err; }
	else
		{ if (!bn_mod_exp(ret,f,rsa->d,rsa->n)) goto err; }

	p=(unsigned char *)buf->data;
	i=bn_bn2bin(ret,p);

	/* put in leading 0 bytes if the number is less than the
	 * length of the modulus */
	j=bn_num_bytes(ret);
	i=bn_bn2bin(ret,&(to[num-j]));
	for (k=0; k<(num-i); k++)
		to[k]=0;

	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(num);
err:
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(-1);
	}

int RSA_private_decrypt(flen, from, to, rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,num,btos;
	unsigned char *p;
	BUFFER *buf;

	tos=bn_get_tos();
	btos=buffer_get_tos();
	num=bn_num_bytes(rsa->n);

	buf=buffer_get_buf();
	if ((buf == NULL) || (buffer_grow(buf,num) <= 0))
		{
		RSAerr(RSA_F_RSA_PRIVATE_DECRYPT,ERR_R_MALLOC_FAILURE);
		goto err;
		}

	if (flen != num)
		{
		RSAerr(RSA_F_RSA_PRIVATE_DECRYPT,RSA_R_DATA_NOT_EQ_TO_MOD_LEN);
		goto err;
		}

	/* make data into a big number */
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn((int)flen,from,f) == NULL) goto err;
	/* do the decrypt */
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	if (	(rsa->p != NULL) &&
		(rsa->q != NULL) &&
		(rsa->dmp1 != NULL) &&
		(rsa->dmq1 != NULL) &&
		(rsa->iqmp != NULL))
		{ if (!RSA_mod_exp(ret,f,rsa)) goto err; }
	else
		{ if (!bn_mod_exp(ret,f,rsa->d,rsa->n)) goto err; }

	p=(unsigned char *)buf->data;
	i=bn_bn2bin(ret,p);

	/* BT must be 02 */
	if (*(p++) != 02)
		{
		RSAerr(RSA_F_RSA_PRIVATE_DECRYPT,RSA_R_BLOCK_TYPE_IS_NOT_02);
		goto err;
		}

	/* scan over padding data */
	j=num-2; /* one for type and one for the prepended 0. */
	for (i=0; i<j; i++)
		if (*(p++) == 0) break;
	if (i == j)
		{
		RSAerr(RSA_F_RSA_PRIVATE_DECRYPT,
			RSA_R_NULL_BEFORE_BLOCK_MISSING);
		goto err;
		}
	if (i < 8)
		{
		RSAerr(RSA_F_RSA_PRIVATE_DECRYPT,RSA_R_BAD_PAD_BYTE_COUNT);
		goto err;
		}

	/* skip over the '\0' */
	i++;	
	j-=i;

	/* output data */
	memcpy(to,p,(unsigned int)j);
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(j);
err:
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(-1);
	}

int RSA_public_decrypt(flen, from, to, rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,num,btos;
	unsigned char *p;
	BUFFER *buf;

	tos=bn_get_tos();
	btos=buffer_get_tos();
	num=bn_num_bytes(rsa->n);
	buf=buffer_get_buf();
	if ((buf == NULL) || (buffer_grow(buf,num) <= 0))
		{
		RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,ERR_R_MALLOC_FAILURE);
		goto err;
		}

	if (flen != num)
		{
		RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,RSA_R_DATA_NOT_EQ_TO_MOD_LEN);
		goto err;
		}
	/* make data into a big number */
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(flen,from,f) == NULL) goto err;
	/* do the decrypt */
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	if (!bn_mod_exp(ret,f,rsa->e,rsa->n)) goto err;

	p=(unsigned char *)buf->data;
	i=bn_bn2bin(ret,p);

	/* BT must be 01 */
	if (*(p++) != 01)
		{
		RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,RSA_R_BLOCK_TYPE_IS_NOT_01);
		goto err;
		}

	/* scan over padding data */
	j=num-2; /* one for type and one for the prepended 0. */
	for (i=0; i<j; i++)
		{
		if (*p != 0xff) /* should decrypt to 0xff */
			{
			if (*p == 0)
				{ p++; break; }
			else	{
				RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,
					RSA_R_BAD_FF_HEADER);
				goto err;
				}
			}
		p++;
		}
	if (i == j)
		{
		RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,
			RSA_R_NULL_BEFORE_BLOCK_MISSING);
		goto err;
		}
	if (i < 8)
		{
		RSAerr(RSA_F_RSA_PUBLIC_DECRYPT,RSA_R_BAD_PAD_BYTE_COUNT);
		goto err;
		}

	/* skip over the '\0' */
	i++;	
	j-=i;

	/* output data */
	memcpy(to,p,(unsigned int)j);
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(j);
err:
	bn_set_tos(tos);
	bn_clean_up();
	buffer_set_tos(btos);
	buffer_clean_up();
	return(-1);
	}

#else
#include "RSAref.c"
#endif

