#include <stdio.h>
#include "crypto.h"
#include "x509.h"
#include "x509_obj.h"
#include "pem.h"

char *usage[]={
"usage: x509 args\n",
"\n",
" -in arg         - input file - default stdin\n",
" -out arg        - output file - default stdout\n",
" -cert arg       - the certificate to use\n",
" -key arg        - the private key to use\n",
" -sign           - sign the message\n",
" -enc arg        - encrypt with one of cbc-des\n",
NULL
};

int main(argc, argv)
int argc;
char **argv;
	{
	FILE *in;
	X509 *x=NULL;
	RSA *rsa=NULL;
	PEM_DIGEST_CTX ctx;
	int i,n;
	char buf[1024*10];
	char buff[1024*10];

	ERR_load_crypto_strings();

	in=fopen("/home/eay/lib/rsa/eay1024.PEM","r");
	if (in == NULL)
		{
		perror("open");
		exit(1);
		}
	x=X509_new();
	if (!PEM_read_X509(in,x))
		{
		ERR_print_error_stack(stderr);
		exit(1);
		}
	fclose(in);

	in=fopen("/home/eay/lib/rsa/eay1024.PEM","r");
	if (in == NULL)
		{
		perror("open");
		exit(1);
		}
	rsa=RSA_new();
	if (!PEM_read_RSA(in,rsa)) goto err;
	fclose(in);


	PEM_SignInit(&ctx,NID_md5);
	for (;;)
		{
		i=fread(buf,1,1024*10,stdin);
		if (i <= 0) break;
		if (!PEM_SignUpdate(&ctx,buf,i)) goto err;
		}
	if (!PEM_SignFinal(&ctx,buf,&n,rsa)) goto err;
	PEM_bin2ascii(n,buf,buff);
	fprintf(stderr,"%s\n",buff);
	exit(0);
err:
	ERR_print_error_stack(stderr);
	exit(1);
	}
