/* pem_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices
in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
*/

#include <stdio.h>
#include "crypto.h"
#include "x509.h"

static ERR_STRING_DATA PEM_str_functs[]=
	{
{ERR_PACK(0,PEM_F_PEM_WRITE_X509,0),	"PEM_WRITE_X509"},
{ERR_PACK(0,PEM_F_PEM_READ_X509,0),	"PEM_READ_X509"},
{ERR_PACK(0,PEM_F_PEM_WRITE_CRL,0),	"PEM_WRITE_CRL"},
{ERR_PACK(0,PEM_F_PEM_READ_CRL,0),	"PEM_READ_CRL"},
{ERR_PACK(0,PEM_F_PEM_READ_RSA,0),	"PEM_READ_RSA"},
{ERR_PACK(0,PEM_F_PEM_WRITE_RSA,0),	"PEM_WRITE_RSA"},
{ERR_PACK(0,PEM_F_PEM_DO_HEADER,0),	"PEM_DO_HEADER"},
{ERR_PACK(0,PEM_F_GET_KEY_BYTES,0),	"GET_KEY_BYTES"},
{ERR_PACK(0,PEM_F_LOAD_IV,0),		"LOAD_IV"},
{ERR_PACK(0,PEM_F_PEM_ASCII2BIN,0),	"PEM_ASCII2BIN"},
{ERR_PACK(0,PEM_F_PEM_READ,0),		"PEM_READ"},
{ERR_PACK(0,PEM_F_PEM_WRITE,0),		"PEM_WRITE"},
{ERR_PACK(0,PEM_F_PEM_DES_CBC_ENCRYPT,0),"PEM_DES_CBC_ENCRYPT"},
{ERR_PACK(0,PEM_F_PEM_DES_EDE2_ENCRYPT,0),"PEM_DES_EDE2_ENCRYPT"},
{ERR_PACK(0,PEM_F_PEM_IDEA_CBC_ENCRYPT,0),"PEM_IDEA_CBC_ENCRYPT"},
{ERR_PACK(0,PEM_F_DEF_CALLBACK,0),	"DEF_CALLBACK"},
{0,NULL},
	};

static ERR_STRING_DATA PEM_str_reasons[]=
	{
{PEM_R_READ_KEY                          ,"READ_KEY"},
{PEM_R_NOT_PROC_TYPE                     ,"NOT_PROC_TYPE"},
{PEM_R_NOT_ENCRYPTED                     ,"NOT_ENCRYPTED"},
{PEM_R_SHORT_HEADER                      ,"SHORT_HEADER"},
{PEM_R_NOT_DEK_INFO                      ,"NOT_DEK_INFO"},
{PEM_R_UNSUPPORTED_ENCRYPTION            ,"UNSUPPORTED_ENCRYPTION"},
{PEM_R_BAD_READ_PW_STRING                ,"BAD_READ_PW_STRING"},
{PEM_R_BASE64_BAD_INPUT_CHAR             ,"BASE64_BAD_INPUT_CHAR"},
{PEM_R_BASE64_LINE_TOO_LONG              ,"BASE64_LINE_TOO_LONG"},
{PEM_R_NO_START_LINE                     ,"NO_START_LINE"},
{PEM_R_BAD_END_LINE                      ,"BAD_END_LINE"},
{PEM_R_BAD_DECRYPT                       ,"BAD_DECRYPT"},
{PEM_R_BAD_IV_CHARS                      ,"BAD_IV_CHARS"},
{0,NULL},
	};

void ERR_load_PEM_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(ERR_LIB_PEM,PEM_str_functs);
		ERR_load_strings(ERR_LIB_PEM,PEM_str_reasons);
		init=0;
		}
	}

