/* pem2der.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "crypto.h"
#include "x509.h"
#include "pem.h"

/* -in arg	- input file - default stdin
 * -out arg	- output file -default stdout
 */

int main(argc, argv)
int argc;
char **argv;
	{
	int tot,i,badops=0;
	FILE *in,*out;
	char *infile,*outfile,*prog;
	char *name,*header;
	unsigned char *data;
	long len;

	infile=NULL;
	outfile=NULL;

	prog=argv[0];
	argc--;
	argv++;
	while (argc >= 1)
		{
		if	(strcmp(*argv,"-in") == 0)
			{
			if (argc-- < 1) goto bad;
			infile= *(++argv);
			}
		else if (strcmp(*argv,"-out") == 0)
			{
			if (argc-- < 1) goto bad;
			outfile= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
bad:
		fprintf(stderr,"%s [options] <infile >outfile\n",prog);
		fprintf(stderr,"where options are\n");
		fprintf(stderr," -in arg       inout file\n");
		fprintf(stderr," -out arg      output file\n");
		exit(1);
		}

	if (infile == NULL)
		in=stdin;
	else
		{
		in=fopen(infile,"r");
		if (in == NULL)
			{
			perror(infile);
			exit(1);
			}
		}

	i=PEM_read(in,&name,&header,&len,&data);
	free(name);
	free(header);
	if (!i)
		{
		fprintf(stderr,"unable to load PEM file\n");
		exit(1);
		}

	if (outfile == NULL)
		out=stdout;
	else
		{
		out=fopen(outfile,"w");
		if (out == NULL)
			{
			perror(outfile);
			exit(1);
			}
		}

	tot=0;
	i=fwrite(&(data[tot]),(unsigned int)len,1,out);
	if (i != 1)
		{
		perror("fwrite");
		exit(1);
		}
	fclose(out);
	exit(0);
	return(0);
	}

