/* PEM.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include "md2.h"
#include "md5.h"

#ifndef HEADER_PEM_H
#define HEADER_PEM_H

#define PEM_ERROR 	     	0
#define PEM_TYPE_ENCRYPTED      10
#define PEM_TYPE_MIC_ONLY       20
#define PEM_TYPE_MIC_CLEAR      30

#define PEM_DEK_DES_CBC         40
#define PEM_DEK_IDEA_CBC        45
#define PEM_DEK_DES_EDE         50
#define PEM_DEK_DES_ECB         60
#define PEM_DEK_RSA             70
#define PEM_DEK_RSA_MD2         80
#define PEM_DEK_RSA_MD5         90

#define PEM_MAX_MD_SIZE		16

#define PEM_MD_MD2		NID_md2
#define PEM_MD_MD5		NID_md5
#define PEM_MD_MD2_RSA		NID_md2withRSAEncryption
#define PEM_MD_MD5_RSA		NID_md5withRSAEncryption

#define	PEM_STRING_DES_CBC	"DES-CBC"
#define	PEM_STRING_DES_CBC_LEN	7
#define	PEM_STRING_IDEA_CBC	"IDEA-CBC"
#define	PEM_STRING_IDEA_CBC_LEN	8
#define	PEM_STRING_RSA		"RSA"
#define	PEM_STRING_RSA_LEN	9
#define	PEM_STRING_RSA_MD2	"RSA-MD2"
#define	PEM_STRING_RSA_MD2_LEN	7
#define	PEM_STRING_RSA_MD5	"RSA-MD5"
#define	PEM_STRING_RSA_MD5_LEN	7
#define	PEM_STRING_DES_ECB	"DES_ECB"
#define	PEM_STRING_DES_ECB_LEN	7
#define	PEM_STRING_DES_EDE	"DES_EDE"
#define	PEM_STRING_DES_EDE_LEN	7
#define PEM_STRING_BAD_DAK	"BAD_DAK"
#define	PEM_STRING_BAD_DAK_LEN	7

typedef struct PEM_Digest_Ctx_st
	{
	int type;
	union	{
		union	{
			MD2_CTX md2;
			MD5_CTX md5;
			} md;
		union	{
			int encrypt;		/* encrypt or decrypt */
			int block;		/* block size (max 8) */
			int left;
			unsigned char buf[8];
			int cipher_size;	/* how big it is for zeroing */
			char *cipher;		/* cipher context */
			} c;
		} d;
	} PEM_CTX;

typedef struct PEM_Encode_Ctx_st
	{
	int count;
	unsigned char data[65];
	} PEM_ENCODE_CTX;

#ifdef PROTO
int	PEM_bin2ascii(int len, unsigned char *f, unsigned char *t);
int	PEM_ascii2bin(unsigned char *f, unsigned char *t);
int	PEM_do_header (char *header, int len, unsigned char *data);
void	PEM_set_getkey_callback(int (*a) ());
int	PEM_write_X509(FILE *fp, X509 *x);
int	PEM_read (FILE *fp, char **name, char **header, long *len, unsigned char **data);
int	PEM_read_RSA(FILE *fp, RSA *x);
int	PEM_read_X509(FILE *fp, X509 *x);
int	PEM_write (FILE *fp, char *name, char *header, long len, unsigned char *data);
int	PEM_write_RSA(FILE *fp, RSA *r, int enc, int klen, char *kstr);

int	PEM_write_X509_REQ(FILE *fp, X509_REQ *x);
int	PEM_write_X509_CRL(FILE *fp, X509_CRL *x);
int	PEM_read_X509_REQ(FILE *fp, X509_REQ *x);
int	PEM_read_X509_CRL(FILE *fp, X509_CRL *x);

int	PEM_DigestInit(PEM_CTX *ctx, int type);
int	PEM_DigestUpdate(PEM_CTX *ctx,unsigned char *d,unsigned int cnt);
int	PEM_DigestFinal(PEM_CTX *ctx,unsigned char *md,unsigned int *s);

int	PEM_SignInit(PEM_CTX *ctx, int type);
int	PEM_SignUpdate(PEM_CTX *ctx,unsigned char *d,unsigned int cnt);
int	PEM_SignFinal(PEM_CTX *ctx,unsigned char *md,unsigned int *s, RSA *rsa);

int	PEM_VerifyInit(PEM_CTX *ctx, int type);
int	PEM_VerifyUpdate(PEM_CTX *ctx,unsigned char *d,unsigned int cnt);
int	PEM_VerifyFinal(PEM_CTX *ctx,unsigned char *md,unsigned int s, RSA *rsa);

int	PEM_EncryptInit(PEM_CTX *ctx, unsigned char **enc_keys,
	unsigned int *enc_keylen, unsigned char *ret_iv,
	unsigned int num_pkeys, RSA **pkeys, int type);
int	PEM_EncryptUpdate(PEM_CTX *ctx, unsigned char *out,
	unsigned int *outl, unsigned char *in, unsigned int inl);
int	PEM_EncryptFinal(PEM_CTX *ctx, unsigned char *out,
	unsigned int outl);
void	PEM_EncryptFinshed(PEM_CTX *ctx);

int	PEM_DecryptInit(PEM_CTX *ctx, int type, unsigned char *enc_key,
	unsigned int enc_key_len, unsigned char *iv, RSA *rsa);
int	PEM_DecryptUpdate(PEM_CTX *ctx, unsigned char *out,
	unsigned int *outl, unsigned char *in, unsigned int inl);
int	PEM_DecryptFinal(PEM_CTX *ctx, unsigned char *outm,
	unsigned int *outl);
void	PEM_DecryptFinshed(PEM_CTX *ctx);

#else

int	PEM_bin2ascii();
int	PEM_ascii2bin();
int	PEM_do_header ();
void	PEM_set_getkey_callback();
int	PEM_write_X509();
int	PEM_read ();
int	PEM_read_RSA();
int	PEM_read_X509();
int	PEM_write ();
int	PEM_write_RSA();
int	PEM_write_X509_REQ();
int	PEM_read_X509_REQ();
int	PEM_write_X509_CRL();
int	PEM_read_X509_CRL();

int	PEM_DigestInit();
int	PEM_DigestUpdate();
int	PEM_DigestFinal();

int	PEM_SignInit();
int	PEM_SignUpdate();
int	PEM_SignFinal();

int	PEM_VerifyInit();
int	PEM_VerifyUpdate();
int	PEM_VerifyFinal();

int	PEM_EncryptInit();
int	PEM_EncryptUpdate();
int	PEM_EncryptFinal();
void	PEM_EncryptFinshed();

int	PEM_DecryptInit();
int	PEM_DecryptUpdate();
int	PEM_DecryptFinal();
void	PEM_DecryptFinshed();

#endif

#endif
