/* p_sign.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "md2.h"
#include "md5.h"
#include "bn.h"
#include "der.h"
#include "x509.h"
#include "pem.h"

int PEM_VerifyInit(ctx,type)
PEM_CTX *ctx;
int type;
	{
	return(PEM_DigestInit(ctx,type));
	}

int PEM_VerifyUpdate(ctx,data,count)
PEM_CTX *ctx;
unsigned char *data;
unsigned int count;
	{
	return(PEM_DigestUpdate(ctx,data,count));
	}

int PEM_VerifyFinal(ctx,sigbuf,siglen,rsa)
PEM_CTX *ctx;
unsigned char *sigbuf;
unsigned int siglen;
RSA *rsa;
	{
	unsigned char m[PEM_MAX_MD_SIZE];
	unsigned int m_len;
	int i,j,ret=1;
	X509_SIG *sig;
	unsigned char *p,*s;

	if (!PEM_DigestFinal(ctx,&(m[0]),&m_len)) return(0);

	s=(unsigned char *)malloc((unsigned int)siglen);
	if (s == NULL)
		{
		PEMerr(PEM_F_PEM_VERIFYFINAL,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	i=RSA_public_decrypt((int)siglen,sigbuf,s,rsa);
	if (i <= 0)
		{
		ret=0;
		free(s);
		goto err;
		}

	sig=X509_SIG_new();
	if (sig == NULL) return(0);
	p=s;
	if (!D2i_X509_SIG(sig,&p)) return(0);
	if (	(sig->digest->length != m_len) ||
		(memcmp(&(m[0]),sig->digest->data,m_len) != 0))
		{
		PEMerr(PEM_F_PEM_VERIFYFINAL,PEM_R_BAD_SIGNATURE);
		ret=0;
		}
err:
	memset(s,0,(unsigned int)siglen);
	free(s);
	return(ret);
	}
