/* p_sign.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "md2.h"
#include "md5.h"
#include "bn.h"
#include "der.h"
#include "x509.h"
#include "pem.h"

int PEM_SignInit(ctx,type)
PEM_CTX *ctx;
int type;
	{
	return(PEM_DigestInit(ctx,type));
	}

int PEM_SignUpdate(ctx,data,count)
PEM_CTX *ctx;
unsigned char *data;
unsigned int count;
	{
	return(PEM_DigestUpdate(ctx,data,count));
	}

int PEM_SignFinal(ctx,sigret,siglen,rsa)
PEM_CTX *ctx;
unsigned char *sigret;
unsigned int *siglen;
RSA *rsa;
	{
	unsigned char m[PEM_MAX_MD_SIZE];
	unsigned int m_len;
	int i,j,ret=1;
	X509_SIG sig;
        X509_ALGOR algor;
	DER_BIT_STRING parameters;
	DER_BIT_STRING digest;
	unsigned char *p,*s;

	if (!PEM_DigestFinal(ctx,&(m[0]),&m_len)) return(0);

	sig.algor= &algor;
	sig.algor->algorithm=X509_nid2obj(ctx->type);
	if (sig.algor->algorithm == NULL)
		{ PEMerr(PEM_F_PEM_SIGNFINAL,ERR_R_X509_LIB); return(0); }
	parameters.length=0;
	parameters.data=NULL;
	sig.algor->parameters= &parameters;

	sig.digest= &digest;
	sig.digest->data=m;
	sig.digest->length=m_len;

	i=i2D_X509_SIG(&sig,NULL);
	j=RSA_size(rsa);
	if (i > j)
		{
		RSAerr(PEM_F_PEM_SIGNFINAL,RSA_R_DIGEST_KEY_TOO_BIG_FOR_KEY);
		return(0);
		}
	s=(unsigned char *)malloc((unsigned int)j+1);
	if (s == NULL)
		{ PEMerr(PEM_F_PEM_SIGNFINAL,ERR_R_MALLOC_FAILURE); return(0); }
	p=s;
	i2D_X509_SIG(&sig,&p);
	i=RSA_private_encrypt(i,s,sigret,rsa);
	if (i <= 0)
		ret=0;
	else
		*siglen=i;

	memset(s,0,(unsigned int)j+1);
	free(s);
	return(ret);
	}
