/* p_encode.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "x509.h"
#include "pem.h"

#define conv_bin2ascii(a)	(data_bin2ascii[(a)&0x3f])
#define conv_ascii2bin(a)	(data_ascii2bin[(a)&0x7f])

#ifdef PROTO
static void EncodeLine(unsigned char *t, unsigned char *f);
static void DecodeLine(unsigned char *t, unsigned char *f, int n);
#else
static void EncodeLine();
static void DecodeLine();
#endif

/* 64 char lines
 * pad input with 0
 * left over chars are set to =
 * 1 byte  => xx==
 * 2 bytes => xxx=
 * 3 bytes => xxxx
 */
#define BIN_PER_LINE    (64/4*3)
#define CHUNKS_PER_LINE (64/4)
#define CHAR_PER_LINE   (64+1)

static unsigned char data_bin2ascii[65]="ABCDEFGHIJKLMNOPQRSTUVWXYZ\
abcdefghijklmnopqrstuvwxyz0123456789+/";
static unsigned char data_ascii2bin[128]={
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0xFF,0xFF,0x3E,0xFF,0xFF,0xFF,0x3F,
	0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,
	0x3C,0x3D,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,
	0xFF,0x00,0x01,0x02,0x03,0x04,0x05,0x06,
	0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,
	0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
	0x17,0x18,0x19,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xFF,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,
	0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
	0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
	0x31,0x32,0x33,0xFF,0xFF,0xFF,0xFF,0xFF,
	};

void PEM_EncodeInit(ctx)
PEM_ENCODE_CTX *ctx;
	{
	ctx->count=0;
	}

void PEM_DecodeInit(ctx)
PEM_ENCODE_CTX *ctx;
	{
	ctx->count=0;
	}

unsigned int PEM_EncodeUpdate(ctx,out,in,inl)
PEM_ENCODE_CTX *ctx;
unsigned char *out;
unsigned char *in;
unsigned int inl;
	{
	int i;
	unsigned int total=0;
	unsigned char *p;

	if ((ctx->count+inl) < BIN_PER_LINE)
		{
		memcpy(&(ctx->data[ctx->count]),in,inl);
		ctx->count+=inl;
		return;
		}
	if (ctx->count != 0)
		{
		i=BIN_PER_LINE-ctx->count;
		memcpy(&(ctx->data[ctx->count]),in,i);
		in+=i;
		inl-=i;
		EncodeLine(out,ctx->data);
		total=CHAR_PER_LINE;
		}
	while (inl >= BIN_PER_LINE)
		{
		EncodeLine(out,in);
		in+=BIN_PER_LINE;
		inl-=BIN_PER_LINE;
		total+=BIN_PER_LINE;
		}
	memcpy(&(ctx->data[0]),in,inl);
	ctx->count=inl;
	return(total);
	}

int PEM_EncodeFinal(ctx,t)
PEM_ENCODE_CTX *ctx;
unsigned char *t;
	{
	unsigned char *f;
	unsigned int i,ret=0;
	unsigned long l;
	int len;

	f=ctx->data;
	len=ctx->count;
	for (;;)
		{
		if (len >= 3)
			{
			l=	((unsigned long)f[0]<<16L)|
				((unsigned long)f[1]<< 8L)|f[2];
			*(t++)=conv_bin2ascii(l>>18L);
			*(t++)=conv_bin2ascii(l>>12L);
			*(t++)=conv_bin2ascii(l>> 6L);
			*(t++)=conv_bin2ascii(l    );
			f+=3;
			}
		else
			{
			l=0;
			l=(f[0]<<16L);
			if (len == 2) l|=(f[1]<<8L);

			*(t++)=conv_bin2ascii(l>>18L);
			*(t++)=conv_bin2ascii(l>>12L);
			*(t++)=(len == 1)?'=':conv_bin2ascii(l>> 6L);
			*(t++)='=';
			}
		ret+=4;
		if (len <= 3) break;
		len-=3;
		}
	ret++;
	*(t++)='\n';
	*(t++)='\0';
	return(ret);
	}

static void EncodeLine(t,f)
unsigned char *t,*f;
	{
	int i;
	unsigned long l;

	for (i=0; i<CHUNKS_PER_LINE; i++)
		{
		l=	((unsigned long)f[0]<<16L)|
			((unsigned long)f[1]<< 8L)|f[2];
		*(t++)=conv_bin2ascii(l>>18L);
		*(t++)=conv_bin2ascii(l>>12L);
		*(t++)=conv_bin2ascii(l>> 6L);
		*(t++)=conv_bin2ascii(l     );
		f+=3;
		}
	*(t++)='\n';
	*(t++)='\0';
	}

int PEM_DecodeUpdate(ctx,out,outl,in,inl)
PEM_ENCODE_CTX *ctx;
unsigned char *out;
unsigned int *outl;
unsigned char *in;
unsigned int inl;
	{
	int i,j;
	unsigned int total=0;
	unsigned char *p;

	*outl=0;
	p= &(ctx->data[ctx->count]);
	if ((ctx->count+inl) < CHAR_PER_LINE)
		{
		for (i=0; i<inl; i++)
			{
			j=conv_ascii2bin(*(in++));
			if (j == 0xFF)
				{
				if (	(in[-1] == '\n') &&
					(((i+ctx->count-1) % 4) == 0))
					{
					ctx->count+=i;
					return(0);
					}
				else
					return(-1);
				}
			*(p++)=j;
			}
		ctx->count+=inl;
		return(1);;
		}
	if (ctx->count != 0)
		{
		i=BIN_PER_LINE-ctx->count;
		inl-=i;
		for (; i>0; i--)
			{
			j=conv_ascii2bin(*(in++));
			if (j == 0xFF) return(-1);
			*(p++)=j;
			}
		if (*(in++) != '\n') return(-1);
		DecodeLine(out,ctx->data,CHUNKS_PER_LINE);
		total=BIN_PER_LINE;
		}
	while (inl >= CHAR_PER_LINE)
		{
		p= &(ctx->data[0]);
		for (i=CHAR_PER_LINE; i>0; i--)
			{
			j=conv_ascii2bin(*(in++));
			if (j == 0xFF) return(-1);
			*(p++)=j;
			}
		if (*(in++) != '\n') return(-1);
		inl-=CHAR_PER_LINE;

		DecodeLine(out,ctx->data,CHUNKS_PER_LINE);
		total+=BIN_PER_LINE;
		}
	p= &(ctx->data[0]);
	for (i=0; i<inl; i++)
		{
		j=conv_ascii2bin(*(in++));
		if (j == 0xFF) return(-1);
		*(p++)=j;
		}
	ctx->count=inl;
	*outl=total;
	return(1);
	}

static void DecodeLine(t,f,n)
unsigned char *t,*f;
int n;
	{
	int i;
	unsigned long l;

	for (i=0; i<n; i++)
		{
		l=(	(unsigned long)(*(f++)<<18L)|
			(unsigned long)(*(f++)<<12L)|
			(unsigned long)(*(f++)<< 6L)|
			(unsigned long)(*(f++)     ));
		*(t++)=(unsigned char)(l>>16L)&0xff;
		*(t++)=(unsigned char)(l>> 8L)&0xff;
		*(t++)=(unsigned char)(l     )&0xff;
		}
	}

int PEM_DecodeFinal(ctx,out,outl)
PEM_ENCODE_CTX *ctx;
unsigned char *out;
unsigned int *outl;
	{
	int ret=0;
	int i;

	*outl=0;
	i=ctx->count%4;
	if ((i == 0) || ((i == 1) && (ctx->data[ctx->count-1] == '\n')))
		{
		DecodeLine(out,ctx->data,ctx->count/4);
		*outl=ctx->count/4*3;
		ctx->count=0;
		return(1);
		}
	else
		return(-1);
	}

