/* d_digest.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "md2.h"
#include "md5.h"
#include "x509.h"
#include "x509_obj.h"
#include "pem.h"

int PEM_DigestInit(ctx,type)
PEM_CTX *ctx;
int type;
	{
	ctx->type=type;
	switch (type)
		{
	case PEM_MD_MD2:
	case PEM_MD_MD2_RSA:
		MD2Init(&(ctx->d.md.md2));
		break;
	case PEM_MD_MD5:	
	case PEM_MD_MD5_RSA:
		MD5Init(&(ctx->d.md.md5));
		break;
	default:
		PEMerr(PEM_F_PEM_DIGESTINIT,PEM_R_BAD_MD_TYPE);
		return(0);
		}
	return(1);
	}

int PEM_DigestUpdate(ctx,data,count)
PEM_CTX *ctx;
unsigned char *data;
unsigned int count;
	{
	switch (ctx->type)
		{
	case PEM_MD_MD2:
	case PEM_MD_MD2_RSA:
		MD2Update(&(ctx->d.md.md2),data,(unsigned long)count);
		break;
	case PEM_MD_MD5:
	case PEM_MD_MD5_RSA:
		MD5Update(&(ctx->d.md.md5),data,(unsigned long)count);
		break;
	default:
		PEMerr(PEM_F_PEM_DIGESTUPDATE,PEM_R_BAD_MD_TYPE);
		return(0);
		}
	return(1);
	}

int PEM_DigestFinal(ctx,md,size)
PEM_CTX *ctx;
unsigned char *md;
unsigned int *size;
	{
	switch (ctx->type)
		{
	case PEM_MD_MD2:
	case PEM_MD_MD2_RSA:
		MD2Final(md,&(ctx->d.md.md2));
		*size=16;
		break;
	case PEM_MD_MD5:
	case PEM_MD_MD5_RSA:
		MD5Final(md,&(ctx->d.md.md5));
		*size=16;
		break;
	default:
		PEMerr(PEM_F_PEM_DIGESTFINAL,PEM_R_BAD_MD_TYPE);
		return(0);
		}
	return(1);
	}
