/* p_seal.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "md2.h"
#include "md5.h"
#include "des.h"
#ifndef NORC4
#include "rc4.h"
#endif
#ifndef NOIDEA
#include "idea.h"
#endif
#include "x509.h"
#include "x509_obj.h"
#include "pem.h"

#ifndef NORC4
typedef struct
	{
	unsigned char key[16];	/* initial key */
	RC4_KEY ks;		/* working key */
	} PEM_C_RC4;
#endif

typedef struct
	{
	C_Block oiv;		/* original iv */
	C_Block iv;		/* working iv */
	des_key_schedule ks;	/* key schedule */
	} PEM_C_CBC_DES;

typedef struct
	{
	C_Block oiv;		/* original iv */
	C_Block iv;		/* working iv */
	des_key_schedule ks1;	/* key schedule 1 */
	des_key_schedule ks2;	/* key schedule 2 */
	des_key_schedule ks3;	/* key schedule 3 */
	} PEM_C_EDE_DES;

#ifndef NOIDEA
typedef struct
	{
	unsigned char oiv[8];	/* original iv */
	unsigned char iv[8];	/* working iv */
	IDEA_KEY_SCHEDULE ks;	/* key schedule */
	} PEM_C_CBC_IDEA;
#endif

typedef union
	{
	char		*pointer;
	PEM_C_CBC_DES	*cbc_des;
	PEM_C_EDE_DES	*ede_des;
#ifndef NORC4
	PEM_C_RC4 	*rc4;
#endif
#ifndef NOIDEA
	PEM_C_CBC_IDEA	*cbc_idea;
#endif
	} CIPHER;

#ifdef PROTO
static int init_cipher(PEM_CTX *ctx, int type, unsigned char *key,
	unsigned char *iv, int enc, int *len, unsigned char *ret_iv);
static int do_cipher(PEM_CTX *ctx, unsigned char *out,
	unsigned int *outl, unsigned char *in, unsigned int inl);
static int reset_cipher(PEM_CTX *ctx);

#else

static int init_cipher();
static int do_cipher();
static int reset_cipher();
#endif

int PEM_EncryptInit(ctx,enc_keys,enc_keylen,ret_iv,num_pkeys,pkeys,type)
PEM_CTX *ctx;
unsigned char **enc_keys;
unsigned int *enc_keylen;
unsigned char *ret_iv;
unsigned int num_pkeys;
RSA **pkeys;
int type;
	{
	unsigned char key[24];	/* max key length */
	unsigned char iv[8];	/* max key length */
	int ret=1,j,i,len;

	MD5_rand(24,&(key[0]));
	MD5_rand(8,&(iv[0]));

	if (!init_cipher(ctx,type,&(key[0]),&(iv[0]),1,&len,&(ret_iv[0])))
		{ ret=0; goto err; }

	for (i=0; i<num_pkeys; i++)
		{
		j=RSA_public_encrypt(len,key,enc_keys[i],pkeys[i]);
		if (j <= 0)
			{
			ret=0;
			RSAerr(PEM_F_PEM_SEALINIT,ERR_LIB_RSA);
			goto err;
			}
		}
err:
	memset(key,0,24);
	memset(iv,0,8);
	return(ret);
	}


static int init_cipher(ctx,type,key,iv,enc,ret_len,ret_iv)
PEM_CTX *ctx;
int type;
unsigned char *key;
unsigned char *iv;
int enc;
int *ret_len;
unsigned char *ret_iv;
	{
	CIPHER c;
	int riv=1,block=8,size,len;

	switch (type)
		{
	case NID_cbc_des:
		size=sizeof(PEM_C_CBC_DES);
		c.cbc_des=(PEM_C_CBC_DES *)malloc(size);
		if (c.cbc_des == NULL) goto err1;
		memcpy(&(c.cbc_des->iv),iv,8);
		memcpy(&(c.cbc_des->oiv),iv,8);
		des_set_key((des_cblock *)key,c.cbc_des->ks);
		len=8;
		break;
	case NID_ede2_des:
	case NID_ede3_des:
		size=sizeof(PEM_C_EDE_DES);
		c.ede_des=(PEM_C_EDE_DES *)malloc(size);
		if (c.ede_des == NULL) goto err1;
		memcpy(&(c.ede_des->iv),iv,8);
		memcpy(&(c.ede_des->oiv),iv,8);
		des_set_key((des_cblock *)key,c.ede_des->ks1);
		des_set_key((des_cblock *)&(key[8]),c.ede_des->ks2);
		if (type == NID_ede2_des)
			{
			des_set_key((des_cblock *)&(key[0]),c.ede_des->ks3);
			len=16;
			}
		else
			{
			des_set_key((des_cblock *)&(key[16]),c.ede_des->ks3);
			len=24;
			}
		break;
#ifndef NORC4
	case NID_rc4:
		size=sizeof(PEM_C_RC4);
		c.rc4=(PEM_C_RC4 *)malloc(size);
		if (c.rc4 == NULL) goto err1;
		memcpy(&(c.rc4->key[0]),key,16);
		RC4_set_key(&(c.rc4->ks),16,key);
		len=16;
		riv=0;
		block=1;
		break;
#endif
#ifndef NOIDEA
	case NID_cbc_idea:
		size=sizeof(PEM_C_CBC_IDEA);
		c.cbc_idea=(PEM_C_CBC_IDEA *)malloc(size);
		if (c.cbc_idea == NULL) goto err1;
		memcpy(&(c.cbc_idea->iv),iv,8);
		memcpy(&(c.cbc_idea->oiv),iv,8);
		idea_encrypt_key(key,&(c.cbc_idea->ks));
		if (!enc)
			{
			IDEA_KEY_SCHEDULE tmp;

			memcpy((unsigned char *)&tmp,
				(unsigned char *)&c.cbc_idea->ks,
				sizeof(IDEA_KEY_SCHEDULE));
			idea_decrypt_key(&tmp,&(c.cbc_idea->ks));
			memset((unsigned char *)&tmp,0,
				sizeof(IDEA_KEY_SCHEDULE));
			}
		len=16;
		break;
#endif
	default:
		PEMerr(PEM_F_INIT_CIPHER,PEM_R_BAD_CIPHER_TYPE);
		return(0);
		}

	if ((riv) && (ret_iv != NULL)) memcpy(ret_iv,iv,8);
	if (ret_len != NULL) *ret_len=len;

	if (ctx->d.c.cipher != NULL) free(ctx->d.c.cipher);
	ctx->type=type;
	ctx->d.c.encrypt=enc;
	ctx->d.c.block=block;
	ctx->d.c.left=0;
	ctx->d.c.cipher_size=size;
	ctx->d.c.cipher=c.pointer;
	return(1);
err1:
	return(0);
	}

int PEM_EncryptUpdate(ctx,out,outl,in,inl)
PEM_CTX *ctx;
unsigned char *out;
unsigned int *outl;
unsigned char *in;
unsigned int inl;
	{
	int i;
	unsigned int num=0;

	*outl=0;
	if (ctx->d.c.left != 0)
		{
		if (ctx->d.c.left+inl < ctx->d.c.block)
			{
			memcpy(&(ctx->d.c.buf[ctx->d.c.left]),in,inl);
			ctx->d.c.left+=inl;
			return(1);
			}
		else
			{
			i=ctx->d.c.block-ctx->d.c.left;
			memcpy(&(ctx->d.c.buf[ctx->d.c.left]),in,i);
			if (!do_cipher(ctx,out,&num,ctx->d.c.buf,
				ctx->d.c.block))
				return(0);
			inl-=i;
			in+=i;
			out+=num;
			}
		}
	i=inl%ctx->d.c.block;	/* how much is left */
	inl-=i;
	do_cipher(ctx,out,outl,in,inl);
	*outl+=num;

	memcpy(ctx->d.c.buf,&(in[inl]),i);
	ctx->d.c.left=i;
	return(1);
	}

int PEM_EncryptFinal(ctx,out,outl)
PEM_CTX *ctx;
unsigned char *out;
unsigned int outl;
	{
	int i,n;

	if (ctx->d.c.block == 1) return(0);
	n=ctx->d.c.block-ctx->d.c.left;
	for (i=ctx->d.c.left; i<ctx->d.c.block; i++)
		ctx->d.c.buf[i]=n;
	if (!do_cipher(ctx,out,&outl,ctx->d.c.buf,ctx->d.c.block))
		return(0);
	reset_cipher(ctx);
	return(1);
	}

void PEM_EncryptFinshed(ctx)
PEM_CTX *ctx;
	{
	memset(ctx->d.c.cipher,0,ctx->d.c.cipher_size);
	free(ctx->d.c.cipher);
	memset(ctx,0,sizeof(ctx));
	}

void PEM_DecryptFinshed(ctx)
PEM_CTX *ctx;
	{
	PEM_EncryptFinished(ctx);
	}

static int do_cipher(ctx,out,outl,in,inl)
PEM_CTX *ctx;
unsigned char *out;
unsigned int *outl;
unsigned char *in;
unsigned int inl;
	{
	CIPHER c;

	c.pointer=ctx->d.c.cipher;
	switch (ctx->type)
		{
	case NID_cbc_des:
		des_ncbc_encrypt(
			(des_cblock *)in,(des_cblock *)out,
			(long)inl, c.cbc_des->ks,
			(des_cblock *)&(c.cbc_des->iv[0]),ctx->d.c.encrypt);
		break;
	case NID_ede2_des:
	case NID_ede3_des:
		des_ede3_cbc_encrypt(
			(des_cblock *)in,(des_cblock *)out,
			(long)inl, c.ede_des->ks1,
			c.ede_des->ks2, c.ede_des->ks3,
			(des_cblock *)&(c.ede_des->iv[0]),ctx->d.c.encrypt);
		break;
#ifndef NORC4
	case NID_rc4:
		RC4(&(c.rc4->ks),inl,in,out);
		break;
#endif
#ifndef NOIDEA
	case NID_cbc_idea:
		idea_cbc_encrypt(in,out,(long)inl,
			&c.cbc_idea->ks,&(c.cbc_idea->iv[0]),ctx->d.c.encrypt);
		break;
#endif
	default:
		PEMerr(PEM_F_DO_CIPHER,PEM_R_BAD_CIPHER_TYPE);
		return(0);
		}
	*outl=inl;
	return(1);
	}

static int reset_cipher(ctx)
PEM_CTX *ctx;
	{
	CIPHER c;

	ctx->d.c.left=0;

	memset(ctx->d.c.buf,0,sizeof(ctx->d.c.buf));
	switch (ctx->type)
		{
	case NID_cbc_des:
		memcpy(&(c.cbc_des->iv),&(c.cbc_des->oiv),8);
		break;
	case NID_ede2_des:
	case NID_ede3_des:
		memcpy(&(c.ede_des->iv),&(c.ede_des->oiv),8);
		break;
#ifndef NORC4
	case NID_rc4:
		RC4_set_key(&(c.rc4->ks),16,&(c.rc4->key[0]));
		break;
#endif
#ifndef NOIDEA
	case NID_cbc_idea:
		memcpy(&(c.cbc_idea->iv),&(c.cbc_idea->oiv),8);
		break;
#endif
	default:
		PEMerr(PEM_F_INIT_CIPHER,PEM_R_BAD_CIPHER_TYPE);
		return(0);
		}

	return(1);
	}

int PEM_DecryptInit(ctx,type,enc_key,enc_key_len,iv,rsa)
PEM_CTX *ctx;
int type;
unsigned char *enc_key;
unsigned int enc_key_len;
unsigned char *iv;
RSA *rsa;
	{
	int j,ret=1;
	unsigned char *buf;

	if (enc_key_len != RSA_size(rsa))
		{
		PEMerr(PEM_F_PEM_OPENINIT,PEM_R_DATA_SIZE_NO_EQ_RSA_SIZE);
		return(0);
		}
	buf=(unsigned char *)malloc(enc_key_len);
	if (buf == NULL)
		{
		PEMerr(PEM_F_PEM_OPENINIT,ERR_R_MALLOC_FAILURE);
		return(0);
		}
	j=RSA_private_decrypt(enc_key_len,enc_key,buf,rsa);
	if (j <= 0)
		{
		RSAerr(PEM_F_PEM_OPENINIT,ERR_LIB_RSA);
		{ ret=0; goto err; }
		}

	if (!init_cipher(ctx,type,buf,iv,0,NULL,NULL))
		{ ret=0; goto err; }
err:
	memset(buf,0,enc_key_len);
	free(buf);
	return(ret);
	}

int PEM_DecryptUpdate(ctx,out,outl,in,inl)
PEM_CTX *ctx;
unsigned char *out;
unsigned int *outl;
unsigned char *in;
unsigned int inl;
	{
	int i;
	unsigned int num=0;

	*outl=0;
	if (ctx->d.c.left != 0)
		{
		if (ctx->d.c.left+inl <= ctx->d.c.block)
			{
			memcpy(&(ctx->d.c.buf[ctx->d.c.left]),in,inl);
			ctx->d.c.left+=inl;
			return(1);
			}
		else
			{
			i=ctx->d.c.block-ctx->d.c.left;
			memcpy(&(ctx->d.c.buf[ctx->d.c.left]),in,i);
			if (!do_cipher(ctx,out,&num,ctx->d.c.buf,
				ctx->d.c.block))
				return(0);
			inl-=i;
			in+=i;
			out+=num;
			}
		}
	inl--;
	i=inl%ctx->d.c.block;
	inl-=i;
	if (inl) do_cipher(ctx,out,outl,in,inl);
	*outl+=num;

	memcpy(ctx->d.c.buf,&(in[inl]),i+1);
	ctx->d.c.left=i+1;
	return(1);
	}

int PEM_DecryptFinal(ctx,out,outl)
PEM_CTX *ctx;
unsigned char *out;
unsigned int *outl;
	{
	int i,n;
	unsigned int num;

	if (!do_cipher(ctx,ctx->d.c.buf,&num,ctx->d.c.buf,ctx->d.c.block))
		return(0);
	n=ctx->d.c.buf[ctx->d.c.block-1];
	if (n > ctx->d.c.block)
		{
		PEMerr(PEM_F_PEM_OPENFINAL,PEM_R_BAD_DECRYPT);
		return(0);
		}
	for (i=0; i<n; i++)
		{
		if (ctx->d.c.buf[ctx->d.c.block-1-i] != n)
			{
			PEMerr(PEM_F_PEM_OPENFINAL,PEM_R_BAD_DECRYPT);
			return(0);
			}
		}
	i=ctx->d.c.block-n;
	memcpy(out,ctx->d.c.buf,i);
	*outl=i;
	reset_cipher(ctx);
	return(1);
	}

