/* genrsa.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "x509.h"
#include "pem.h"

#define DEFBITS	512

#ifdef PROTO
static void cb(int p, int n);
#else
static void cb();
#endif

int main(argc, argv)
int argc;
char **argv;
	{
	RSA *rsa;
	int num=DEFBITS;
	int i,enc=0;

	for (i=1; i<argc; i++)
		{
		if (strcmp(argv[i],"-des") == 0)
			enc=PEM_DEK_DES_CBC;
#ifndef NOIDEA
		else if (strcmp(argv[i],"-idea") == 0)
			enc=PEM_DEK_IDEA_CBC;
#endif
		else
			break;
		}
	if ((i < argc) && (sscanf(argv[i],"%d",&num) == 0))
		{
		num=DEFBITS;
#ifndef NOIDEA
		fprintf(stderr,"usage: genrsa [-des|-idea] [numbits]\n");
#else
		fprintf(stderr,"usage: genrsa [-des] [numbits]\n");
#endif
		exit(1);
		}
	fprintf(stderr,"Generating RSA private key, %d bit long modulus\n",
		num);
	RSA_set_generate_prime_callback(cb);
	rsa=RSA_generate_key(num,1);
	if ((rsa == NULL) || (!PEM_write_RSA(stdout,rsa,enc,0,NULL)))
		{
		unsigned long l;

		while ((l=ERR_get_error()))
			fprintf(stderr,"ERROR:%s\n",ERR_error_string(l));
		exit(1);
		}
	exit(0);
	return(0); /* shut lint up */
	}

static void cb(p, n)
int p;
int n;
	{
	int c='*';

	if (p == 0) c='.';
	if (p == 1) c='+';
	if (p == 2) c='\n';
	fputc(c,stderr);
	fflush(stderr);
#ifdef LINT
	p=n;
#endif
	}
