/* derparse.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "bn.h"
#include "buffer.h"
#include "x509.h"
#include "pem.h"

#define FORMAT_UNDEF	0
#define FORMAT_DER	1
#define FORMAT_TEXT	2
#define FORMAT_PEM	3

/* -inform arg	- input format - default PEM (DER or PEM)
 * -in arg	- input file - default stdin
 */

#ifdef PROTO
static int str2fmt (char *s);
#else
static int str2fmt ();
#endif

int main(argc, argv)
int argc;
char **argv;
	{
	int i,badops=0;
	long num;
	FILE *in;
	int informat;
	char *infile,*str,*prog;
	BUFFER *buf;

	infile=NULL;
	informat=FORMAT_PEM;

	prog=argv[0];
	argc--;
	argv++;
	while (argc >= 1)
		{
		if 	(strcmp(*argv,"-inform") == 0)
			{
			if (argc-- < 1) goto bad;
			informat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-in") == 0)
			{
			if (argc-- < 1) goto bad;
			infile= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
bad:
		fprintf(stderr,"%s [options] <infile\n",prog);
		fprintf(stderr,"where options are\n");
		fprintf(stderr," -inform arg   input format - one of DER TXT PEM\n");
		fprintf(stderr," -in arg       inout file\n");
		exit(1);
		}

	ERR_load_crypto_strings();

	if (infile == NULL)
		in=stdin;
	else
		{
		in=fopen(infile,"r");
		if (in == NULL)
			{
			perror(infile);
			exit(1);
			}
		}
	if (informat == FORMAT_DER)
		{
		num=0;
		buf=buffer_new();
		if (buf == NULL) goto memerr;
		for (;;)
			{
			if (!buffer_grow(buf,num+BUFSIZ)) goto memerr;
			i=fread(&(buf->data[num]),1,BUFSIZ,in);
			if (i <= 0) break;
			num+=i;
			}
		str=buf->data;
		}
	else
		{
		char *name,*header;

		if (!(i=PEM_read(in,&name,&header,&num,(unsigned char **)&str)) ||
			(!(i=PEM_do_header(header,num,(unsigned char *)str))))
			{
			ERR_print_error_stack(stderr);
			exit(1);
			}
		}
	fclose(in);
	if (i < 0)
		{
		perror("error reading input");
		ERR_print_error_stack(stderr);
		exit(1);
		}
	DER_parse(stdout,(unsigned char *)str,(unsigned int)num);
	exit(0);
memerr:
	fprintf(stderr,"malloc failure\n");
	exit(1);
	return(0);
	}

static int str2fmt(s)
char *s;
	{
	if 	((*s == 'D') || (*s == 'd'))
		return(FORMAT_DER);
	else if ((*s == 'T') || (*s == 't'))
		return(FORMAT_TEXT);
	else if ((*s == 'P') || (*s == 'p'))
		return(FORMAT_PEM);
	else
		return(FORMAT_UNDEF);
	}
