/* DER_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices
in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
*/

#include <stdio.h>
#include "crypto.h"
#include "x509.h"

static ERR_STRING_DATA DER_str_functs[]=
	{
{ERR_PACK(0,DER_F_D2I_X509_ALGOR,0),	"D2I_X509_ALGOR"},
{ERR_PACK(0,DER_F_D2I_X509_NAME,0),	"D2I_X509_NAME"},
{ERR_PACK(0,DER_F_D2I_X509_VAL,0),	"D2I_X509_VAL"},
{ERR_PACK(0,DER_F_D2I_X509_PUBKEY,0),	"D2I_X509_PUBKEY"},
{ERR_PACK(0,DER_F_D2I_X509_SIG,0),	"D2I_X509_SIG"},
{ERR_PACK(0,DER_F_D2I_X509_CINF,0),	"D2I_X509_CINF"},
{ERR_PACK(0,DER_F_D2I_X509_REVOKED,0),	"D2I_X509_REVOKED"},
{ERR_PACK(0,DER_F_D2I_X509_REVOKED_LIST,0),"D2I_X509_REVOKED_LIST"},
{ERR_PACK(0,DER_F_D2I_X509_CRL_INFO,0),	"D2I_X509_CRL_INFO"},
{ERR_PACK(0,DER_F_D2I_X509_CRL,0),	"D2I_X509_CRL"},
{ERR_PACK(0,DER_F_D2I_X509_CRL_FILE,0),	"D2I_X509_CRL_FILE"},
{ERR_PACK(0,DER_F_D2I_X509_CRL_FP,0),	"D2I_X509_CRL_FP"},
{ERR_PACK(0,DER_F_D2I_X509_FILE,0),	"D2I_X509_FILE"},
{ERR_PACK(0,DER_F_D2I_X509_FP,0),	"D2I_X509_FP"},
{ERR_PACK(0,DER_F_D2I_X509,0),		"D2I_X509"},
{ERR_PACK(0,DER_F_D2I_RSAPRIVATEKEY_FP,0),"D2I_RSAPRIVATEKEY_FP"},
{ERR_PACK(0,DER_F_D2I_RSAPRIVATEKEY,0),	"D2I_RSAPRIVATEKEY"},
{ERR_PACK(0,DER_F_D2I_RSAPUBLICKEY,0),	"D2I_RSAPUBLICKEY"},
{ERR_PACK(0,DER_F_F2I_X509_ALGOR,0),	"F2I_X509_ALGOR"},
{ERR_PACK(0,DER_F_F2I_X509_NAME,0),	"F2I_X509_NAME"},
{ERR_PACK(0,DER_F_F2I_X509_VAL,0),	"F2I_X509_VAL"},
{ERR_PACK(0,DER_F_F2I_X509_PUBKEY,0),	"F2I_X509_PUBKEY"},
{ERR_PACK(0,DER_F_F2I_X509_SIG,0),	"F2I_X509_SIG"},
{ERR_PACK(0,DER_F_F2I_X509_CINF,0),	"F2I_X509_CINF"},
{ERR_PACK(0,DER_F_F2I_X509_REVOKED,0),	"F2I_X509_REVOKED"},
{ERR_PACK(0,DER_F_F2I_X509_REVOKED_LIST,0),"F2I_X509_REVOKED_LIST"},
{ERR_PACK(0,DER_F_F2I_X509_CRL_INFO,0),	"F2I_X509_CRL_INFO"},
{ERR_PACK(0,DER_F_F2I_X509_CRL,0),	"F2I_X509_CRL"},
{ERR_PACK(0,DER_F_F2I_X509,0),		"F2I_X509"},
{ERR_PACK(0,DER_F_F2I_PRINTABLESTRING,0),"F2I_PRINTABLESTRING"},
{ERR_PACK(0,DER_F_F2I_DER_BIT_STRING,0),"F2I_DER_BIT_STRING"},
{ERR_PACK(0,DER_F_F2I_DER_OBJECT,0),	"F2I_DER_OBJECT"},
{ERR_PACK(0,DER_F_F2I_RSAPRIVATEKEY,0),	"F2I_RSAPRIVATEKEY"},
{ERR_PACK(0,DER_F_F2I_RSAPUBLICKEY,0),	"F2I_RSAPUBLICKEY"},
{ERR_PACK(0,DER_F_I2D_X509_CRL_FP,0),	"I2D_X509_CRL_FP"},
{ERR_PACK(0,DER_F_I2D_X509_FP,0),	"I2D_X509_FP"},
{ERR_PACK(0,DER_F_I2D_PRIVATEKEY_FP,0),	"I2D_PRIVATEKEY_FP"},
{ERR_PACK(0,DER_F_I2D_PRIVATEKEY,0),	"I2D_PRIVATEKEY"},
{ERR_PACK(0,DER_F_I2D_PUBLICKEY,0),	"I2D_PUBLICKEY"},
{ERR_PACK(0,DER_F_I2F_RSAPRIVATEKEY,0),	"I2F_RSAPRIVATEKEY"},
{ERR_PACK(0,DER_F_I2F_RSAPUBLICKEY,0),	"I2F_RSAPUBLICKEY"},
{ERR_PACK(0,DER_F_DER_BIT_STRING_NEW,0),"DER_BIT_STRING_NEW"},
{ERR_PACK(0,DER_F_DER_OBJECT_NEW,0),	"DER_OBJECT_NEW"},
{ERR_PACK(0,DER_F_D2I_INTEGER,0),	"D2I_INTEGER"},
{ERR_PACK(0,DER_F_D2I_DER_OBJECT,0),	"D2I_DER_OBJECT"},
{ERR_PACK(0,DER_F_D2I_PRINTABLESTRING,0),"D2I_PRINTABLESTRING"},
{ERR_PACK(0,DER_F_D2I_DER_BIT_STRING,0),"D2I_DER_BIT_STRING"},
{ERR_PACK(0,DER_F_D2I_DER_OCTET_STRING,0),"D2I_DER_OCTET_STRING"},
{ERR_PACK(0,DER_F_D2I_UTCTIME,0),	"D2I_UTCTIME"},
{0,NULL},
	};

static ERR_STRING_DATA DER_str_reasons[]=
	{
{DER_R_EXPECTING_A_SEQUENCE              ,"EXPECTING_A_SEQUENCE"},
{DER_R_EXPECTING_A_NULL                  ,"EXPECTING_A_NULL"},
{DER_R_EXPECTING_A_SET                   ,"EXPECTING_A_SET"},
{DER_R_EXPECTING_AN_INTEGER              ,"EXPECTING_AN_INTEGER"},
{DER_R_EXPECTING_AN_OBJECT               ,"EXPECTING_AN_OBJECT"},
{DER_R_EXPECTING_A_PRINTABLESTRING       ,"EXPECTING_A_PRINTABLESTRING"},
{DER_R_EXPECTING_A_BIT_STRING            ,"EXPECTING_A_BIT_STRING"},
{DER_R_EXPECTING_AN_OCTET_STRING         ,"EXPECTING_AN_OCTET_STRING"},
{DER_R_EXPECTING_AN_UTCTIME              ,"EXPECTING_AN_UTCTIME"},
{DER_R_NOT_ENOUGH_DATA                   ,"NOT_ENOUGH_DATA"},
{DER_R_EXPECTING_A_BEGIN_TOKEN           ,"EXPECTING_A_BEGIN_TOKEN"},
{DER_R_EXPECTING_A_END_TOKEN             ,"EXPECTING_A_END_TOKEN"},
{DER_R_SHORT_LINE                        ,"SHORT_LINE"},
{DER_R_BAD_SOL_CHARACTER                 ,"BAD_SOL_CHARACTER"},
{DER_R_BAD_EOL_CHARACTER                 ,"BAD_EOL_CHARACTER"},
{DER_R_ODD_NUMBER_OF_CHARS               ,"ODD_NUMBER_OF_CHARS"},
{DER_R_NON_HEX_CHARACTERS                ,"NON_HEX_CHARACTERS"},
{0,NULL},
	};

void ERR_load_DER_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(ERR_LIB_DER,DER_str_functs);
		ERR_load_strings(ERR_LIB_DER,DER_str_reasons);
		init=0;
		}
	}

