/* der.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_DER_H
#define HEADER_DER_H

#define DER_UNIVERSAL		0x00
#define	DER_APPLICATION		0x40
#define DER_CONTEXT_SPECIFIC	0x80
#define DER_PRIVATE		0xb0

#define DER_CONSTRUCTED		0x20
#define DER_PRIMATIVE_TAG	0x1f

#define DER_EOC				0
#define DER_INTEGER			2
#define DER_BIT_STRING_IDENTIFIER	3
#define DER_OCTET_STRING		4
#define DER_NULL			5
#define DER_OBJECT_IDENTIFIER		6
#define DER_SEQUENCE			16
#define DER_SET				17
#define DER_PRINTABLESTRING		19
#define DER_T61STRING			20
#define DER_IA5STRING			22
#define DER_UTCTIME			23

typedef struct object_st
	{
	int num;
	unsigned long *values;
	int nid;
	char *sn,*ln;
	} DER_OBJECT;

typedef struct bit_string_st
	{
	int length;
	unsigned char *data;
	} DER_BIT_STRING;

/*#define DER_DEBUG */
/*#define VRFY_DEBUG */

#ifdef PROTO
DER_BIT_STRING *DER_BIT_STRING_new(void);
DER_OBJECT *    DER_OBJECT_new(void);
void 		DER_BIT_STRING_free (DER_BIT_STRING *a);
int		DER_OBJECT_eq (DER_OBJECT *a, DER_OBJECT *b);
void		DER_OBJECT_free (DER_OBJECT *a);
int		DER_get_object (unsigned char **pp, unsigned long *plength, int * ptag, int *pclass);
void		DER_put_object(unsigned char **pp, int constructed, int length, int tag, int class);
int		DER_object_size (int constructed, int length, int tag);
void		DER_parse (FILE *fp, unsigned char *pp, unsigned int len);

#else

DER_BIT_STRING *DER_BIT_STRING_new();
DER_OBJECT *    DER_OBJECT_new();
void 		DER_BIT_STRING_free ();
int		DER_OBJECT_eq ();
void		DER_OBJECT_free ();
int		DER_get_object ();
void		DER_put_object();
int		DER_object_size ();
void		DER_parse ();
#endif

#endif
