/* bntest.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "bn.h"
#include "x509.h"

#ifdef PROTO
void test_add (FILE *fp);
void test_sub (FILE *fp);
void test_lshift1 (FILE *fp);
void test_lshift (FILE *fp);
void test_rshift1 (FILE *fp);
void test_rshift (FILE *fp);
void test_div (FILE *fp);
void test_mul (FILE *fp);
void test_mod (FILE *fp);
void test_mul_mod (FILE *fp);
void test_mod_exp (FILE *fp);
#else
void test_add ();
void test_sub ();
void test_lshift1 ();
void test_lshift ();
void test_rshift1 ();
void test_rshift ();
void test_div ();
void test_mul ();
void test_mod ();
void test_mul_mod ();
void test_mod_exp ();
#endif

static int results=0;

int main(argc,argv)
int argc;
char *argv[];
	{
	argc--;
	argv++;
	while (argc >= 1)
		{
		if (strcmp(*argv,"-results") == 0)
			results=1;
		argc--;
		argv++;
		}

	if (!results)
		fprintf(stdout,"obase=16\nibase=16\n");

	test_add(stdout);/**/
	test_sub(stdout);/**/
	test_lshift1(stdout);/**/
	test_lshift(stdout);/**/
	test_rshift1(stdout);/**/
	test_rshift(stdout);/**/
	test_div(stdout);/**/
	test_mul(stdout);/**/
	test_mod(stdout);/**/
	test_mul_mod(stdout);/**/
	test_mod_exp(stdout);/**/
	exit(0);
#ifdef LINT
	return(0);
#endif
	}

void test_add(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;
	int j;

	a=bn_new();
	b=bn_new();
	c=bn_new();

	RSA_bn_rand(a,512,0);
	for (i=0; i<100; i++)
		{
		RSA_bn_rand(b,450+i,0);
		if (fp == NULL)
			for (j=0; j<10000; j++)
				bn_add(c,a,b);
		bn_add(c,a,b);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," + ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,c);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	}

void test_sub(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;
	int j;

	a=bn_new();
	b=bn_new();
	c=bn_new();

	RSA_bn_rand(a,512,0);
	for (i=0; i<100; i++)
		{
		RSA_bn_rand(b,400+i,0);
		if (fp == NULL)
			for (j=0; j<10000; j++)
				bn_sub(c,a,b);
		bn_sub(c,a,b);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," - ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,c);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	}

void test_div(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c,*d;
	int i;
	int j;

	a=bn_new();
	b=bn_new();
	c=bn_new();
	d=bn_new();

	RSA_bn_rand(a,400,0);
	for (i=0; i<100; i++)
		{
		RSA_bn_rand(b,50+i,0);
		if (fp == NULL)
			for (j=0; j<100; j++)
				bn_div(d,c,a,b);
		bn_div(d,c,a,b);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," / ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,d);
			fprintf(fp,"\n");

			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," %% ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,c);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	bn_free(d);
	}

void test_mul(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;
	int j;

	a=bn_new();
	b=bn_new();
	c=bn_new();

	RSA_bn_rand(a,100,0);
	for (i=0; i<100; i++)
		{
		RSA_bn_rand(b,50+i,0);
		if (fp == NULL)
			for (j=0; j<100; j++)
				bn_mul(c,a,b);
		bn_mul(c,a,b);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," * ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,c);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	}

void test_mod(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;
	int j;

	a=bn_new();
	b=bn_new();
	c=bn_new();

	RSA_bn_rand(a,1024,0); /**/
	for (i=0; i<20; i++)
		{
		RSA_bn_rand(b,450+i*10,0); /**/
		/*bn_mod2_init(b,1500);*//**/
		if (fp == NULL)
			for (j=0; j<100; j++)
/*				bn_mod2(c,a,b);*//**/
				bn_mod(c,a,b);/**/
		/*bn_mod2(c,a,b);*//**/
		bn_mod(c,a,b);/**/
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," %% ");
				bn_print(fp,b);
				fprintf(fp," - ");
				}
			bn_print(fp,c);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	}

void test_mul_mod(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c,*d,*e;
	int i;

	a=bn_new();
	b=bn_new();
	c=bn_new();
	d=bn_new();
	e=bn_new();

	RSA_bn_rand(c,1024,0); /**/
	for (i=0; i<10; i++)
		{
		RSA_bn_rand(a,475+i*10,0); /**/
		RSA_bn_rand(b,425+i*10,0); /**/
	/*	if (fp == NULL)
			for (j=0; j<100; j++)
				bn_mul_mod(d,a,b,c);*/ /**/

		if (!bn_mul_mod(e,a,b,c))
			{
			unsigned long l;

			while ((l=ERR_get_error()))
				fprintf(stderr,"ERROR:%s\n",
					ERR_error_string(l));
			exit(1);
			}
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," * ");
				bn_print(fp,b);
				fprintf(fp," %% ");
				bn_print(fp,c);
				fprintf(fp," - ");
				}
			bn_print(fp,e);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	bn_free(d);
	}

void test_mod_exp(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c,*d,*e;
	int i;

	a=bn_new();
	b=bn_new();
	c=bn_new();
	d=bn_new();
	e=bn_new();

	RSA_bn_rand(c,30,0); /**/
	for (i=0; i<6; i++)
		{
		RSA_bn_rand(a,20+i*5,0); /**/
		RSA_bn_rand(b,2+i,0); /**/

		bn_mod_exp(d,a,b,c);

		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," ^ ");
				bn_print(fp,b);
				fprintf(fp," %% ");
				bn_print(fp,c);
				fprintf(fp," - ");
				}
			bn_print(fp,d);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	bn_free(c);
	bn_free(d);
	bn_free(e);
	}

void test_lshift(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;

	a=bn_new();
	b=bn_new();
	c=bn_new();
	bn_one(c);

	RSA_bn_rand(a,200,0); /**/
	for (i=0; i<70; i++)
		{
		bn_lshift(b,a,i+1);
		bn_add(c,c,c);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," * ");
				bn_print(fp,c);
				fprintf(fp," - ");
				}
			bn_print(fp,b);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	}

void test_lshift1(fp)
FILE *fp;
	{
	BIGNUM *a,*b;
	int i;

	a=bn_new();
	b=bn_new();

	RSA_bn_rand(a,200,0); /**/
	for (i=0; i<10; i++)
		{
		bn_lshift1(b,a);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," * 2");
				fprintf(fp," - ");
				}
			bn_print(fp,b);
			fprintf(fp,"\n");
			}
		bn_copy(a,b);
		}
	bn_free(a);
	bn_free(b);
	}

void test_rshift(fp)
FILE *fp;
	{
	BIGNUM *a,*b,*c;
	int i;

	a=bn_new();
	b=bn_new();
	c=bn_new();
	bn_one(c);

	RSA_bn_rand(a,200,0); /**/
	for (i=0; i<70; i++)
		{
		bn_rshift(b,a,i+1);
		bn_add(c,c,c);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," / ");
				bn_print(fp,c);
				fprintf(fp," - ");
				}
			bn_print(fp,b);
			fprintf(fp,"\n");
			}
		}
	bn_free(a);
	bn_free(b);
	}

void test_rshift1(fp)
FILE *fp;
	{
	BIGNUM *a,*b;
	int i;

	a=bn_new();
	b=bn_new();

	RSA_bn_rand(a,200,0); /**/
	for (i=0; i<10; i++)
		{
		bn_rshift1(b,a);
		if (fp != NULL)
			{
			if (!results)
				{
				bn_print(fp,a);
				fprintf(fp," / 2");
				fprintf(fp," - ");
				}
			bn_print(fp,b);
			fprintf(fp,"\n");
			}
		bn_copy(a,b);
		}
	bn_free(a);
	bn_free(b);
	}
