#!/usr/local/bin/perl
# bn_prime.pl
# Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
# All rights reserved.
# Copyright remains Eric Young's, and as such any Copyright notices in
# the code are not to be removed.
# See the COPYRIGHT file in the SSLeay distribution for more details.

$num=1024;
$num=$ARGV[0] if ($#ARGV >= 0);

push(@primes,2);
$p=1;
loop: while ($#primes < $num-1)
	{
	$p+=2;
	$s=int(sqrt($p));

	for ($i=0; $primes[$i]<=$s; $i++)
		{
		next loop if (($p%$primes[$i]) == 0);
		}
	push(@primes,$p);
	}

print <<"EOF";
/* Auto generated by bn_prime.pl */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

EOF
printf "#define NUMPRIMES %d\n",$num;
print "static unsigned int primes[NUMPRIMES]=\n\t{\n\t";
for ($i=0; $i <= $#primes; $i++)
	{
	printf("\n\t") if (($i%8) == 0) && ($i != 0);
	printf("%4d,",$primes[$i]);
	}
print "\n\t};\n";

